/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.ClientPool;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jmeter.protocol.jms.client.Publisher;
import org.apache.jmeter.protocol.jms.sampler.BaseJMSSampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.io.TextFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherSampler
extends BaseJMSSampler
implements TestListener {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String INPUT_FILE = "jms.input_file";
    private static final String RANDOM_PATH = "jms.random_path";
    private static final String TEXT_MSG = "jms.text_message";
    private static final String CONFIG_CHOICE = "jms.config_choice";
    private static final String MESSAGE_CHOICE = "jms.config_msg_type";
    private transient Publisher publisher = null;
    private static final FileServer FSERVER = FileServer.getFileServer();
    private String file_contents = null;
    private static final String USE_FILE_LOCALNAME = JMeterUtils.getResString((String)"jms_use_file");
    private static final String USE_RANDOM_LOCALNAME = JMeterUtils.getResString((String)"jms_use_random_file");

    public void testStarted(String test) {
        this.testStarted();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testEnded() {
        log.debug("PublisherSampler.testEnded called");
        ClientPool.clearClient();
        InitialContextFactory.close();
    }

    public void testStarted() {
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    private void initClient() throws JMSException, NamingException {
        this.publisher = new Publisher(this.getUseJNDIPropertiesAsBoolean(), this.getJNDIInitialContextFactory(), this.getProviderUrl(), this.getConnectionFactory(), this.getDestination(), this.isUseAuth(), this.getUsername(), this.getPassword(), this.isDestinationStatic());
        ClientPool.addClient(this.publisher);
        log.debug("PublisherSampler.initClient called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult sample() {
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        result.setSuccessful(false);
        result.setResponseCode("000");
        if (this.publisher == null) {
            try {
                this.initClient();
            }
            catch (JMSException e) {
                result.setResponseMessage(e.toString());
                return result;
            }
            catch (NamingException e) {
                result.setResponseMessage(e.toString());
                return result;
            }
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder propBuffer = new StringBuilder();
        int loop = this.getIterationCount();
        result.sampleStart();
        String type = this.getMessageChoice();
        try {
            for (int idx = 0; idx < loop; ++idx) {
                TextMessage msg;
                if ("jms_text_message".equals(type)) {
                    String tmsg = this.getMessageContent();
                    msg = this.publisher.publish(tmsg, this.getDestination());
                    buffer.append(tmsg);
                    Utils.messageProperties(propBuffer, (Message)msg);
                    continue;
                }
                if ("jms_map_message".equals(type)) {
                    Map<String, Object> m = this.getMapContent();
                    msg = this.publisher.publish(m, this.getDestination());
                    Utils.messageProperties(propBuffer, (Message)msg);
                    continue;
                }
                if ("jms_object_message".equals(type)) {
                    throw new JMSException(type + " is not yet supported");
                }
                throw new JMSException(type + " is not recognised");
            }
            result.setResponseCodeOK();
            result.setResponseMessage(loop + " messages published");
            result.setSuccessful(true);
            result.setSamplerData(buffer.toString());
            result.setSampleCount(loop);
            result.setRequestHeaders(propBuffer.toString());
        }
        catch (Exception e) {
            result.setResponseMessage(e.toString());
        }
        finally {
            result.sampleEnd();
        }
        return result;
    }

    private Map<String, Object> getMapContent() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] lines;
        HashMap<String, Object> m = new HashMap<String, Object>();
        String text = this.getMessageContent();
        for (String line : lines = text.split("\n")) {
            Object obj;
            String[] parts = line.split(",", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("line must have 3 parts: " + line);
            }
            String name = parts[0];
            String type = parts[1];
            if (!type.contains(".")) {
                type = "java.lang." + type;
            }
            String value = parts[2];
            if (type.equals("java.lang.String")) {
                obj = value;
            } else {
                Class<?> clazz = Class.forName(type);
                Method method = clazz.getMethod("valueOf", String.class);
                obj = method.invoke(clazz, value);
            }
            m.put(name, obj);
        }
        return m;
    }

    private String getMessageContent() {
        if (this.getConfigChoice().equals("jms_use_file")) {
            if (this.file_contents == null) {
                this.file_contents = this.getFileContent(this.getInputFile());
            }
            return this.file_contents;
        }
        if (this.getConfigChoice().equals("jms_use_random_file")) {
            String fname = FSERVER.getRandomFile(this.getRandomPath(), new String[]{".txt", ".obj"}).getAbsolutePath();
            return this.getFileContent(fname);
        }
        return this.getTextMessage();
    }

    public String getFileContent(String path) {
        TextFile tf = new TextFile(path);
        return tf.getText();
    }

    public void setConfigChoice(String choice) {
        this.setProperty(CONFIG_CHOICE, choice);
    }

    public String getConfigChoice() {
        String config = this.getPropertyAsString(CONFIG_CHOICE);
        if (config.equals(USE_FILE_LOCALNAME) || config.equals("jms_use_file")) {
            return "jms_use_file";
        }
        if (config.equals(USE_RANDOM_LOCALNAME) || config.equals("jms_use_random_file")) {
            return "jms_use_random_file";
        }
        return config;
    }

    public void setMessageChoice(String choice) {
        this.setProperty(MESSAGE_CHOICE, choice);
    }

    public String getMessageChoice() {
        return this.getPropertyAsString(MESSAGE_CHOICE);
    }

    public void setInputFile(String file) {
        this.setProperty(INPUT_FILE, file);
    }

    public String getInputFile() {
        return this.getPropertyAsString(INPUT_FILE);
    }

    public void setRandomPath(String path) {
        this.setProperty(RANDOM_PATH, path);
    }

    public String getRandomPath() {
        return this.getPropertyAsString(RANDOM_PATH);
    }

    public void setTextMessage(String message) {
        this.setProperty(TEXT_MSG, message);
    }

    public String getTextMessage() {
        return this.getPropertyAsString(TEXT_MSG);
    }
}

