/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.client;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class InitialContextFactory {
    private static final ConcurrentHashMap<String, Context> MAP = new ConcurrentHashMap();
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static Context lookupContext(String initialContextFactory, String providerUrl, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException {
        String cacheKey = InitialContextFactory.createKey(Thread.currentThread().getId(), initialContextFactory, providerUrl, securityPrincipal, securityCredentials);
        Context ctx = MAP.get(cacheKey);
        if (ctx == null) {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", initialContextFactory);
            props.setProperty("java.naming.provider.url", providerUrl);
            if (useAuth && securityPrincipal != null && securityCredentials != null && securityPrincipal.length() > 0 && securityCredentials.length() > 0) {
                props.setProperty("java.naming.security.principal", securityPrincipal);
                props.setProperty("java.naming.security.credentials", securityCredentials);
                log.info("authentication properties set");
            }
            try {
                ctx = new InitialContext(props);
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new NamingException(e.toString());
            }
            Context oldCtx = MAP.putIfAbsent(cacheKey, ctx);
            if (oldCtx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx = oldCtx;
            }
        }
        return ctx;
    }

    private static String createKey(long threadId, String initialContextFactory, String providerUrl, String securityPrincipal, String securityCredentials) {
        StringBuilder builder = new StringBuilder();
        builder.append(threadId);
        builder.append("#");
        builder.append(initialContextFactory);
        builder.append("#");
        builder.append(providerUrl);
        builder.append("#");
        if (!StringUtils.isEmpty((CharSequence)securityPrincipal)) {
            builder.append(securityPrincipal);
            builder.append("#");
        }
        if (!StringUtils.isEmpty((CharSequence)securityCredentials)) {
            builder.append(securityCredentials);
        }
        return builder.toString();
    }

    public static Context getContext(boolean useProps, String initialContextFactory, String providerUrl, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException {
        if (useProps) {
            try {
                return new InitialContext();
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new NamingException(e.toString());
            }
        }
        return InitialContextFactory.lookupContext(initialContextFactory, providerUrl, useAuth, securityPrincipal, securityCredentials);
    }

    public static void close() {
        for (Context ctx : MAP.values()) {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                log.error(e.getMessage());
            }
        }
        MAP.clear();
        log.info("InitialContextFactory.close() called and Context instances cleaned up");
    }
}

