/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JUnitSampler
extends AbstractSampler
implements ThreadListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String CLASSNAME = "junitSampler.classname";
    private static final String CONSTRUCTORSTRING = "junitsampler.constructorstring";
    private static final String METHOD = "junitsampler.method";
    private static final String ERROR = "junitsampler.error";
    private static final String ERRORCODE = "junitsampler.error.code";
    private static final String FAILURE = "junitsampler.failure";
    private static final String FAILURECODE = "junitsampler.failure.code";
    private static final String SUCCESS = "junitsampler.success";
    private static final String SUCCESSCODE = "junitsampler.success.code";
    private static final String FILTER = "junitsampler.pkg.filter";
    private static final String DOSETUP = "junitsampler.exec.setup";
    private static final String APPEND_ERROR = "junitsampler.append.error";
    private static final String APPEND_EXCEPTION = "junitsampler.append.exception";
    private static final String JUNIT4 = "junitsampler.junit4";
    private static final String CREATE_INSTANCE_PER_SAMPLE = "junitsampler.createinstancepersample";
    private static final boolean CREATE_INSTANCE_PER_SAMPLE_DEFAULT = false;
    private static final String SETUP = "setUp";
    private static final String TEARDOWN = "tearDown";
    private transient Method setUpMethod;
    private transient Method tearDownMethod;
    private transient TestCase testCase;
    private transient Object testObject;
    private transient String methodName;
    private transient String className;
    private transient Protectable protectable;

    private void initMethodObjects(Object testObject) {
        this.setUpMethod = null;
        this.tearDownMethod = null;
        if (!this.getDoNotSetUpTearDown()) {
            this.setUpMethod = this.getJunit4() ? this.getMethodWithAnnotation(testObject, Before.class) : this.getMethod(testObject, SETUP);
            this.tearDownMethod = this.getJunit4() ? this.getMethodWithAnnotation(testObject, After.class) : this.getMethod(testObject, TEARDOWN);
        }
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    public void setConstructorString(String constr) {
        this.setProperty(CONSTRUCTORSTRING, constr);
    }

    public String getConstructorString() {
        return this.getPropertyAsString(CONSTRUCTORSTRING);
    }

    public String getMethod() {
        return this.getPropertyAsString(METHOD);
    }

    public void setMethod(String methodName) {
        this.setProperty(METHOD, methodName);
    }

    public String getSuccess() {
        return this.getPropertyAsString(SUCCESS);
    }

    public void setSuccess(String success) {
        this.setProperty(SUCCESS, success);
    }

    public String getSuccessCode() {
        return this.getPropertyAsString(SUCCESSCODE);
    }

    public void setSuccessCode(String code) {
        this.setProperty(SUCCESSCODE, code);
    }

    public String getFailure() {
        return this.getPropertyAsString(FAILURE);
    }

    public void setFailure(String fail) {
        this.setProperty(FAILURE, fail);
    }

    public String getFailureCode() {
        return this.getPropertyAsString(FAILURECODE);
    }

    public void setFailureCode(String code) {
        this.setProperty(FAILURECODE, code);
    }

    public String getError() {
        return this.getPropertyAsString(ERROR);
    }

    public void setError(String error) {
        this.setProperty(ERROR, error);
    }

    public String getErrorCode() {
        return this.getPropertyAsString(ERRORCODE);
    }

    public void setErrorCode(String code) {
        this.setProperty(ERRORCODE, code);
    }

    public String getFilterString() {
        return this.getPropertyAsString(FILTER);
    }

    public void setFilterString(String text) {
        this.setProperty(FILTER, text);
    }

    public boolean getDoNotSetUpTearDown() {
        return this.getPropertyAsBoolean(DOSETUP);
    }

    public void setDoNotSetUpTearDown(boolean setup) {
        this.setProperty(DOSETUP, String.valueOf(setup));
    }

    public boolean getAppendError() {
        return this.getPropertyAsBoolean(APPEND_ERROR, false);
    }

    public void setAppendError(boolean error) {
        this.setProperty(APPEND_ERROR, String.valueOf(error));
    }

    public boolean getAppendException() {
        return this.getPropertyAsBoolean(APPEND_EXCEPTION, false);
    }

    public void setAppendException(boolean exc) {
        this.setProperty(APPEND_EXCEPTION, String.valueOf(exc));
    }

    public boolean getJunit4() {
        return this.getPropertyAsBoolean(JUNIT4, false);
    }

    public void setJunit4(boolean junit4) {
        this.setProperty(JUNIT4, junit4, false);
    }

    public SampleResult sample(Entry entry) {
        if (this.getCreateOneInstancePerSample()) {
            this.initializeTestObject();
        }
        SampleResult sresult = new SampleResult();
        sresult.setSampleLabel(this.getName());
        sresult.setSamplerData(this.className + "." + this.methodName);
        sresult.setDataType("text");
        sresult.setSuccessful(true);
        sresult.setResponseMessage(this.getSuccess());
        sresult.setResponseCode(this.getSuccessCode());
        if (this.testCase != null) {
            TestResult tr = new TestResult();
            TestCase theClazz = this.testCase;
            try {
                if (this.setUpMethod != null) {
                    this.setUpMethod.invoke(this.testObject, new Object[0]);
                }
                sresult.sampleStart();
                tr.startTest((junit.framework.Test)this.testCase);
                tr.runProtected((junit.framework.Test)theClazz, this.protectable);
                tr.endTest((junit.framework.Test)this.testCase);
                sresult.sampleEnd();
                if (this.tearDownMethod != null) {
                    this.tearDownMethod.invoke(this.testObject, new Object[0]);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionFailedError) {
                    tr.addFailure((junit.framework.Test)theClazz, (AssertionFailedError)cause);
                } else if (cause instanceof AssertionError) {
                    AssertionFailedError afe = new AssertionFailedError(cause.toString());
                    afe.setStackTrace(cause.getStackTrace());
                    tr.addFailure((junit.framework.Test)theClazz, afe);
                } else if (cause != null) {
                    tr.addError((junit.framework.Test)theClazz, cause);
                } else {
                    tr.addError((junit.framework.Test)theClazz, (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                tr.addError((junit.framework.Test)theClazz, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                tr.addError((junit.framework.Test)theClazz, (Throwable)e);
            }
            if (!tr.wasSuccessful()) {
                sresult.setSuccessful(false);
                StringBuilder buf = new StringBuilder();
                StringBuilder buftrace = new StringBuilder();
                if (this.getAppendError()) {
                    TestFailure item;
                    Enumeration en = tr.failures();
                    if (en.hasMoreElements()) {
                        sresult.setResponseCode(this.getFailureCode());
                        buf.append(this.getFailure());
                        buf.append("\n");
                    }
                    while (en.hasMoreElements()) {
                        item = (TestFailure)en.nextElement();
                        buf.append("Failure -- ");
                        buf.append(item.toString());
                        buf.append("\n");
                        buftrace.append("Failure -- ");
                        buftrace.append(item.toString());
                        buftrace.append("\n");
                        buftrace.append("Trace -- ");
                        buftrace.append(item.trace());
                    }
                    en = tr.errors();
                    if (en.hasMoreElements()) {
                        sresult.setResponseCode(this.getErrorCode());
                        buf.append(this.getError());
                        buf.append("\n");
                    }
                    while (en.hasMoreElements()) {
                        item = (TestFailure)en.nextElement();
                        buf.append("Error -- ");
                        buf.append(item.toString());
                        buf.append("\n");
                        buftrace.append("Error -- ");
                        buftrace.append(item.toString());
                        buftrace.append("\n");
                        buftrace.append("Trace -- ");
                        buftrace.append(item.trace());
                    }
                }
                sresult.setResponseMessage(buf.toString());
                sresult.setResponseData(buftrace.toString(), null);
            }
        } else {
            sresult.setSuccessful(false);
            sresult.setResponseMessage("Failed to create an instance of the class:" + this.getClassname() + ", reasons may be missing both empty constructor and one " + "String constructor or failure to instantiate constructor," + " check warning messages in jmeter log file");
            sresult.setResponseCode(this.getErrorCode());
        }
        return sresult;
    }

    private static Object getClassInstance(String className, String label) {
        Object testclass = null;
        if (className != null) {
            Constructor<?> con = null;
            Constructor<?> strCon = null;
            Class<?> theclazz = null;
            Object[] strParams = null;
            Object[] params = null;
            try {
                theclazz = Thread.currentThread().getContextClassLoader().loadClass(className.trim());
            }
            catch (ClassNotFoundException e) {
                log.warn("ClassNotFoundException:: " + e.getMessage());
            }
            if (theclazz != null) {
                try {
                    strCon = theclazz.getDeclaredConstructor(String.class);
                    if (label == null || label.length() == 0) {
                        label = className;
                    }
                    if (strCon.getModifiers() == 1) {
                        strParams = new Object[]{label};
                    } else {
                        strCon = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    log.info("Trying to find constructor with one String parameter returned error: " + e.getMessage());
                }
                try {
                    con = theclazz.getDeclaredConstructor(new Class[0]);
                    if (con != null) {
                        params = new Object[]{};
                    }
                }
                catch (NoSuchMethodException e) {
                    log.info("Trying to find empty constructor returned error: " + e.getMessage());
                }
                try {
                    if (strCon != null) {
                        testclass = strCon.newInstance(strParams);
                    } else if (con != null) {
                        testclass = con.newInstance(params);
                    } else {
                        log.error("No empty constructor nor string constructor found for class:" + theclazz);
                    }
                }
                catch (InvocationTargetException e) {
                    log.error("Error instantiating class:" + theclazz + ":" + e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error("Error instantiating class:" + theclazz + ":" + e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Error instantiating class:" + theclazz + ":" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return testclass;
    }

    private Method getMethod(Object clazz, String method) {
        if (clazz != null && method != null) {
            try {
                return clazz.getClass().getMethod(method, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                log.warn(e.getMessage());
            }
        }
        return null;
    }

    private Method getMethodWithAnnotation(Object clazz, Class<? extends Annotation> annotation) {
        if (null != clazz && null != annotation) {
            for (Method m : clazz.getClass().getMethods()) {
                if (!m.isAnnotationPresent(annotation)) continue;
                return m;
            }
        }
        return null;
    }

    public void threadFinished() {
    }

    public void threadStarted() {
        this.testObject = null;
        this.testCase = null;
        this.methodName = this.getMethod();
        this.className = this.getClassname();
        this.protectable = null;
        if (!this.getCreateOneInstancePerSample()) {
            this.initializeTestObject();
        }
    }

    private void initializeTestObject() {
        String rlabel = this.getConstructorString();
        if (rlabel.length() == 0) {
            rlabel = JUnitSampler.class.getName();
        }
        this.testObject = JUnitSampler.getClassInstance(this.className, rlabel);
        if (this.testObject != null) {
            this.initMethodObjects(this.testObject);
            final Method m = this.getMethod(this.testObject, this.methodName);
            if (this.getJunit4()) {
                Class expectedException = Test.None.class;
                long timeout = 0L;
                Test annotation = m.getAnnotation(Test.class);
                if (null != annotation) {
                    expectedException = annotation.expected();
                    timeout = annotation.timeout();
                }
                final AnnotatedTestCase at = new AnnotatedTestCase(m, expectedException, timeout);
                this.testCase = at;
                this.protectable = new Protectable(){

                    public void protect() throws Throwable {
                        at.runTest();
                    }
                };
            } else {
                this.testCase = (TestCase)this.testObject;
                final Object theClazz = this.testObject;
                this.protectable = new Protectable(){

                    public void protect() throws Throwable {
                        try {
                            m.invoke(theClazz, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            Throwable t = e.getCause();
                            if (t != null) {
                                throw t;
                            }
                            throw e;
                        }
                    }
                };
            }
            if (this.testCase != null) {
                this.testCase.setName(this.methodName);
            }
        }
    }

    public void setCreateOneInstancePerSample(boolean createOneInstancePerSample) {
        this.setProperty(CREATE_INSTANCE_PER_SAMPLE, createOneInstancePerSample, false);
    }

    public boolean getCreateOneInstancePerSample() {
        return this.getPropertyAsBoolean(CREATE_INSTANCE_PER_SAMPLE, false);
    }

    private class AnnotatedTestCase
    extends TestCase {
        private final Method method;
        private final Class<? extends Throwable> expectedException;
        private final long timeout;

        public AnnotatedTestCase(Method method, Class<? extends Throwable> expectedException2, long timeout) {
            this.method = method;
            this.expectedException = expectedException2;
            this.timeout = timeout;
        }

        protected void runTest() throws Throwable {
            block7: {
                try {
                    long elapsed;
                    long start = System.currentTimeMillis();
                    this.method.invoke(JUnitSampler.this.testObject, (Object[])null);
                    if (this.expectedException != Test.None.class) {
                        throw new AssertionFailedError("No error was generated for a test case which specifies an error.");
                    }
                    if (this.timeout > 0L && (elapsed = System.currentTimeMillis() - start) > this.timeout) {
                        throw new AssertionFailedError("Test took longer than the specified timeout.");
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable thrown = e.getCause();
                    if (thrown == null) {
                        throw e;
                    }
                    if (this.expectedException == Test.None.class) {
                        if (thrown instanceof AssertionError && !(thrown instanceof AssertionFailedError)) {
                            AssertionFailedError afe = new AssertionFailedError(thrown.toString());
                            afe.setStackTrace(thrown.getStackTrace());
                            throw afe;
                        }
                        throw thrown;
                    }
                    if (this.expectedException.isAssignableFrom(thrown.getClass())) break block7;
                    throw new AssertionFailedError("The wrong exception was thrown from the test case");
                }
            }
        }
    }
}

