/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.protocol;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;

public class LocalTrustStoreSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTrustStoreSSLSocketFactory(File truststore) {
        SSLContext sslcontext = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(truststore));
                ks.load(stream, null);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            TrustManager[] trustmanagers = tmf.getTrustManagers();
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, trustmanagers, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the SSL context", e);
        }
        this.factory = sslcontext.getSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

