/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.monitor.parser;

import java.util.Stack;
import org.apache.jmeter.monitor.model.Connector;
import org.apache.jmeter.monitor.model.Jvm;
import org.apache.jmeter.monitor.model.Memory;
import org.apache.jmeter.monitor.model.ObjectFactory;
import org.apache.jmeter.monitor.model.RequestInfo;
import org.apache.jmeter.monitor.model.Status;
import org.apache.jmeter.monitor.model.ThreadInfo;
import org.apache.jmeter.monitor.model.Worker;
import org.apache.jmeter.monitor.model.Workers;
import org.apache.jmeter.monitor.model.WorkersImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MonitorHandler
extends DefaultHandler {
    private Stack<Object> stacktree = new Stack();
    private ObjectFactory factory = null;
    private Status status = null;
    private Jvm jvm = null;
    private Memory memory = null;
    private Connector connector = null;
    private ThreadInfo threadinfo = null;
    private RequestInfo requestinfo = null;
    private Worker worker = null;
    private Workers workers = null;

    public void setObjectFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block33: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block32: {
                                        if (!qName.equals("status")) break block32;
                                        this.status = this.factory.createStatus();
                                        this.stacktree.push(this.status);
                                        break block33;
                                    }
                                    if (!qName.equals("jvm")) break block34;
                                    this.jvm = this.factory.createJvm();
                                    if (!(this.stacktree.peek() instanceof Status)) break block33;
                                    this.status.setJvm(this.jvm);
                                    this.stacktree.push(this.jvm);
                                    break block33;
                                }
                                if (!qName.equals("memory")) break block35;
                                this.memory = this.factory.createMemory();
                                if (!(this.stacktree.peek() instanceof Jvm)) break block33;
                                this.stacktree.push(this.memory);
                                if (attributes != null) {
                                    for (int idx = 0; idx < attributes.getLength(); ++idx) {
                                        String attr = attributes.getQName(idx);
                                        if (attr.equals("free")) {
                                            this.memory.setFree(this.parseLong(attributes.getValue(idx)));
                                            continue;
                                        }
                                        if (attr.equals("total")) {
                                            this.memory.setTotal(this.parseLong(attributes.getValue(idx)));
                                            continue;
                                        }
                                        if (!attr.equals("max")) continue;
                                        this.memory.setMax(this.parseLong(attributes.getValue(idx)));
                                    }
                                }
                                this.jvm.setMemory(this.memory);
                                break block33;
                            }
                            if (!qName.equals("connector")) break block36;
                            this.connector = this.factory.createConnector();
                            if (!(this.stacktree.peek() instanceof Status) && !(this.stacktree.peek() instanceof Connector)) break block33;
                            this.status.addConnector(this.connector);
                            this.stacktree.push(this.connector);
                            if (attributes != null) {
                                for (int idx = 0; idx < attributes.getLength(); ++idx) {
                                    String attr = attributes.getQName(idx);
                                    if (!attr.equals("name")) continue;
                                    this.connector.setName(attributes.getValue(idx));
                                }
                            }
                            break block33;
                        }
                        if (!qName.equals("threadInfo")) break block37;
                        this.threadinfo = this.factory.createThreadInfo();
                        if (!(this.stacktree.peek() instanceof Connector)) break block33;
                        this.stacktree.push(this.threadinfo);
                        this.connector.setThreadInfo(this.threadinfo);
                        if (attributes != null) {
                            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                                String attr = attributes.getQName(idx);
                                if (attr.equals("maxThreads")) {
                                    this.threadinfo.setMaxThreads(this.parseInt(attributes.getValue(idx)));
                                    continue;
                                }
                                if (attr.equals("minSpareThreads")) {
                                    this.threadinfo.setMinSpareThreads(this.parseInt(attributes.getValue(idx)));
                                    continue;
                                }
                                if (attr.equals("maxSpareThreads")) {
                                    this.threadinfo.setMaxSpareThreads(this.parseInt(attributes.getValue(idx)));
                                    continue;
                                }
                                if (attr.equals("currentThreadCount")) {
                                    this.threadinfo.setCurrentThreadCount(this.parseInt(attributes.getValue(idx)));
                                    continue;
                                }
                                if (!attr.equals("currentThreadsBusy")) continue;
                                this.threadinfo.setCurrentThreadsBusy(this.parseInt(attributes.getValue(idx)));
                            }
                        }
                        break block33;
                    }
                    if (!qName.equals("requestInfo")) break block38;
                    this.requestinfo = this.factory.createRequestInfo();
                    if (!(this.stacktree.peek() instanceof Connector)) break block33;
                    this.stacktree.push(this.requestinfo);
                    this.connector.setRequestInfo(this.requestinfo);
                    if (attributes != null) {
                        for (int idx = 0; idx < attributes.getLength(); ++idx) {
                            String attr = attributes.getQName(idx);
                            if (attr.equals("maxTime=")) {
                                this.requestinfo.setMaxTime(this.parseInt(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("processingTime=")) {
                                this.requestinfo.setProcessingTime(this.parseInt(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("requestCount")) {
                                this.requestinfo.setRequestCount(this.parseInt(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("errorCount=")) {
                                this.requestinfo.setErrorCount(this.parseInt(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("bytesReceived")) {
                                this.requestinfo.setBytesReceived(this.parseLong(attributes.getValue(idx)));
                                continue;
                            }
                            if (!attr.equals("bytesSent")) continue;
                            this.requestinfo.setBytesSent(this.parseLong(attributes.getValue(idx)));
                        }
                    }
                    break block33;
                }
                if (!qName.equals("workers")) break block39;
                this.workers = this.factory.createWorkers();
                if (!(this.stacktree.peek() instanceof Connector)) break block33;
                this.connector.setWorkers(this.workers);
                this.stacktree.push(this.workers);
                break block33;
            }
            if (qName.equals("worker")) {
                this.worker = this.factory.createWorker();
                if (this.stacktree.peek() instanceof Workers || this.stacktree.peek() instanceof Worker) {
                    this.stacktree.push(this.worker);
                    ((WorkersImpl)this.workers).addWorker(this.worker);
                    if (attributes != null) {
                        for (int idx = 0; idx < attributes.getLength(); ++idx) {
                            String attr = attributes.getQName(idx);
                            if (attr.equals("stage")) {
                                this.worker.setStage(attributes.getValue(idx));
                                continue;
                            }
                            if (attr.equals("requestProcessingTime=")) {
                                this.worker.setRequestProcessingTime(this.parseInt(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("requestBytesSent")) {
                                this.worker.setRequestBytesSent(this.parseLong(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("requestBytesReceived")) {
                                this.worker.setRequestBytesReceived(this.parseLong(attributes.getValue(idx)));
                                continue;
                            }
                            if (attr.equals("remoteAddr")) {
                                this.worker.setRemoteAddr(attributes.getValue(idx));
                                continue;
                            }
                            if (attr.equals("virtualHost")) {
                                this.worker.setVirtualHost(attributes.getValue(idx));
                                continue;
                            }
                            if (attr.equals("method")) {
                                this.worker.setMethod(attributes.getValue(idx));
                                continue;
                            }
                            if (attr.equals("currentUri")) {
                                this.worker.setCurrentUri(attributes.getValue(idx));
                                continue;
                            }
                            if (attr.equals("currentQueryString")) {
                                this.worker.setCurrentQueryString(attributes.getValue(idx));
                                continue;
                            }
                            if (!attr.equals("protocol")) continue;
                            this.worker.setProtocol(attributes.getValue(idx));
                        }
                    }
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("status")) {
            if (this.stacktree.peek() instanceof Status) {
                this.stacktree.pop();
            }
        } else if (qName.equals("jvm")) {
            if (this.stacktree.peek() instanceof Jvm) {
                this.stacktree.pop();
            }
        } else if (qName.equals("memory")) {
            if (this.stacktree.peek() instanceof Memory) {
                this.stacktree.pop();
            }
        } else if (qName.equals("connector")) {
            if (this.stacktree.peek() instanceof Connector || this.stacktree.peek() instanceof Connector) {
                this.stacktree.pop();
            }
        } else if (qName.equals("threadInfo")) {
            if (this.stacktree.peek() instanceof ThreadInfo) {
                this.stacktree.pop();
            }
        } else if (qName.equals("requestInfo")) {
            if (this.stacktree.peek() instanceof RequestInfo) {
                this.stacktree.pop();
            }
        } else if (qName.equals("workers")) {
            if (this.stacktree.peek() instanceof Workers) {
                this.stacktree.pop();
            }
        } else if (qName.equals("worker") && (this.stacktree.peek() instanceof Worker || this.stacktree.peek() instanceof Worker)) {
            this.stacktree.pop();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public long parseLong(String data) {
        long val = 0L;
        if (data.length() > 0) {
            try {
                val = Long.parseLong(data);
            }
            catch (NumberFormatException e) {
                val = 0L;
            }
        }
        return val;
    }

    public int parseInt(String data) {
        int val = 0;
        if (data.length() > 0) {
            try {
                val = Integer.parseInt(data);
            }
            catch (NumberFormatException e) {
                val = 0;
            }
        }
        return val;
    }

    public Status getContents() {
        return this.status;
    }
}

