/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.MonitorAccumModel;
import org.apache.jmeter.visualizers.MonitorListener;
import org.apache.jmeter.visualizers.MonitorModel;
import org.apache.jmeter.visualizers.ServerPanel;

public class MonitorHealthPanel
extends JPanel
implements MonitorListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private final HashMap<String, ServerPanel> serverPanelMap = new HashMap();
    private JPanel servers = null;
    private final MonitorAccumModel model;
    private JScrollPane serverScrollPane = null;
    private final String INFO_H = JMeterUtils.getResString((String)"monitor_equation_healthy");
    private final String INFO_A = JMeterUtils.getResString((String)"monitor_equation_active");
    private final String INFO_W = JMeterUtils.getResString((String)"monitor_equation_warning");
    private final String INFO_D = JMeterUtils.getResString((String)"monitor_equation_dead");
    private final String INFO_LOAD = JMeterUtils.getResString((String)"monitor_equation_load");

    @Deprecated
    public MonitorHealthPanel() {
        this.model = null;
    }

    public MonitorHealthPanel(MonitorAccumModel model) {
        this.model = model;
        this.model.addListener(this);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        ImageIcon legend = JMeterUtils.getImage((String)"monitor-legend.gif");
        JLabel label = new JLabel(legend);
        label.setPreferredSize(new Dimension(550, 25));
        this.add((Component)label, "North");
        this.servers = new JPanel();
        this.servers.setLayout(new BoxLayout(this.servers, 1));
        this.servers.setAlignmentX(0.0f);
        this.serverScrollPane = new JScrollPane(this.servers);
        this.serverScrollPane.setPreferredSize(new Dimension(300, 300));
        this.add((Component)this.serverScrollPane, "Center");
        String eqstring1 = " " + this.INFO_H + "   |   " + this.INFO_A;
        String eqstring2 = " " + this.INFO_W + "   |   " + this.INFO_D;
        String eqstring3 = " " + this.INFO_LOAD;
        JLabel eqs = new JLabel();
        eqs.setLayout(new BorderLayout());
        eqs.setPreferredSize(new Dimension(500, 60));
        eqs.add((Component)new JLabel(eqstring1), "North");
        eqs.add((Component)new JLabel(eqstring2), "Center");
        eqs.add((Component)new JLabel(eqstring3), "South");
        this.add((Component)eqs, "South");
    }

    public void addSample(MonitorModel model) {
        if (this.serverPanelMap.containsKey(model.getURL())) {
            ServerPanel pane = null;
            if (this.serverPanelMap.get(model.getURL()) != null) {
                pane = this.serverPanelMap.get(model.getURL());
            } else {
                pane = new ServerPanel(model);
                this.serverPanelMap.put(model.getURL(), pane);
            }
            pane.updateGui(model);
        } else {
            ServerPanel newpane = new ServerPanel(model);
            this.serverPanelMap.put(model.getURL(), newpane);
            this.servers.add(newpane);
            newpane.updateGui(model);
        }
        this.servers.updateUI();
    }

    public void clearData() {
        this.serverPanelMap.clear();
        this.servers.removeAll();
        this.servers.updateUI();
    }
}

