/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.MonitorAccumModel;
import org.apache.jmeter.visualizers.MonitorGraph;
import org.apache.jmeter.visualizers.MonitorHealthPanel;
import org.apache.jmeter.visualizers.MonitorPerformancePanel;
import org.apache.jmeter.visualizers.MonitorTabPane;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MonitorHealthVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
ItemListener,
GraphListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String CONNECTOR_PREFIX = "connector.prefix";
    private static final String CONNECTOR_PREFIX_DEFAULT = "";
    private static final String BUFFER = "monitor.buffer.size";
    private MonitorTabPane tabPane;
    private MonitorHealthPanel healthPane;
    private MonitorPerformancePanel perfPane;
    private MonitorAccumModel model;
    private MonitorGraph graph;
    private JLabeledTextField prefixField;

    public MonitorHealthVisualizer() {
        this.isStats = true;
        this.initModel();
        this.init();
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.prefixField.setText(el.getPropertyAsString(CONNECTOR_PREFIX, CONNECTOR_PREFIX_DEFAULT));
        this.model.setPrefix(this.prefixField.getText());
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(CONNECTOR_PREFIX, this.prefixField.getText(), CONNECTOR_PREFIX_DEFAULT);
        this.model.setPrefix(this.prefixField.getText());
    }

    private void initModel() {
        this.model = new MonitorAccumModel();
        this.graph = new MonitorGraph(this.model);
        this.model.setBufferSize(JMeterUtils.getPropDefault((String)BUFFER, (int)800));
    }

    public String getLabelResource() {
        return "monitor_health_title";
    }

    public void add(SampleResult res) {
        this.model.addSample(res);
        try {
            this.collector.recordStats((TestElement)this.model.getLastSample().cloneMonitorStats());
        }
        catch (Exception e) {
            log.debug("StatsModel was null", (Throwable)e);
        }
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.getWidth(), this.getHeight());
        Graphics image = result.getGraphics();
        this.graph.paintComponent(image);
        return result;
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public synchronized void updateGui() {
        this.repaint();
    }

    public synchronized void updateGui(Sample s) {
        this.repaint();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        this.add(this.makeTitlePanel(), "North");
        this.createTabs();
        this.prefixField = new JLabeledTextField(JMeterUtils.getResString((String)"monitor_label_prefix"));
        this.add((Component)this.prefixField, "South");
    }

    private void createTabs() {
        this.tabPane = new MonitorTabPane();
        this.createHealthPane(this.tabPane);
        this.createPerformancePane(this.tabPane);
        this.add(this.tabPane, "Center");
    }

    private void createHealthPane(MonitorTabPane pane) {
        this.healthPane = new MonitorHealthPanel(this.model);
        pane.addTab(JMeterUtils.getResString((String)"monitor_health_tab_title"), this.healthPane);
    }

    private void createPerformancePane(MonitorTabPane pane) {
        this.perfPane = new MonitorPerformancePanel(this.model, this.graph);
        pane.addTab(JMeterUtils.getResString((String)"monitor_performance_tab_title"), this.perfPane);
    }

    public void clearData() {
        this.model.clearData();
        this.healthPane.clearData();
        this.perfPane.clearData();
    }
}

