/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.monitor.model.ObjectFactory;
import org.apache.jmeter.monitor.model.Status;
import org.apache.jmeter.monitor.util.Stats;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.MonitorListener;
import org.apache.jmeter.visualizers.MonitorModel;
import org.apache.jmeter.visualizers.MonitorStats;

public class MonitorAccumModel
implements Clearable,
Serializable {
    private static final long serialVersionUID = 240L;
    private final Map<String, List<MonitorModel>> serverListMap = new HashMap<String, List<MonitorModel>>();
    private MonitorModel current;
    private final List<MonitorListener> listeners = new LinkedList<MonitorListener>();
    private int defaultBufferSize = 800;
    private String connectorPrefix = null;

    public int getBufferSize() {
        return this.defaultBufferSize;
    }

    public void setBufferSize(int buffer) {
        this.defaultBufferSize = buffer;
    }

    public void setPrefix(String prefix) {
        this.connectorPrefix = prefix;
    }

    public MonitorModel getLastSample() {
        return this.current;
    }

    public void addSample(MonitorModel model) {
        this.current = model;
        if (this.serverListMap.containsKey(model.getURL())) {
            List<MonitorModel> newlist = this.updateArray(model, this.serverListMap.get(model.getURL()));
            this.serverListMap.put(model.getURL(), newlist);
        } else {
            List<MonitorModel> samples = Collections.synchronizedList(new LinkedList());
            samples.add(model);
            this.serverListMap.put(model.getURL(), samples);
        }
    }

    private List<MonitorModel> updateArray(MonitorModel model, List<MonitorModel> list) {
        if (list.size() < this.defaultBufferSize) {
            list.add(model);
        } else {
            list.add(model);
            list.remove(0);
        }
        return list;
    }

    public List<MonitorModel> getAllSamples(String url) {
        if (!this.serverListMap.containsKey(url)) {
            return Collections.synchronizedList(new LinkedList());
        }
        return this.serverListMap.get(url);
    }

    public MonitorModel getSample(String url) {
        if (this.serverListMap.containsKey(url)) {
            return this.serverListMap.get(url).get(0);
        }
        return null;
    }

    public void addSample(SampleResult sample) {
        URL surl = null;
        if (sample instanceof HTTPSampleResult) {
            surl = ((HTTPSampleResult)sample).getURL();
            if (sample.isResponseCodeOK() && ((HTTPSampleResult)sample).isMonitor()) {
                ObjectFactory of = ObjectFactory.getInstance();
                Status st = of.parseBytes(sample.getResponseData());
                st.setConnectorPrefix(this.connectorPrefix);
                if (surl != null) {
                    MonitorStats stat = new MonitorStats(Stats.calculateStatus(st), Stats.calculateLoad(st), 0, Stats.calculateMemoryLoad(st), Stats.calculateThreadLoad(st), surl.getHost(), String.valueOf(surl.getPort()), surl.getProtocol(), System.currentTimeMillis());
                    MonitorModel mo = new MonitorModel(stat);
                    this.addSample(mo);
                    this.notifyListeners(mo);
                }
            } else if (((HTTPSampleResult)sample).isMonitor()) {
                this.noResponse(surl);
            }
        }
    }

    public void noResponse(URL url) {
        this.notifyListeners(this.createNewMonitorModel(url));
    }

    public MonitorModel createNewMonitorModel(URL url) {
        MonitorStats stat = new MonitorStats(0, 0, 0, 0, 0, url.getHost(), String.valueOf(url.getPort()), url.getProtocol(), System.currentTimeMillis());
        return new MonitorModel(stat);
    }

    public void clearData() {
        for (List<MonitorModel> modelList : this.serverListMap.values()) {
            modelList.clear();
        }
        this.serverListMap.clear();
    }

    public void notifyListeners(MonitorModel model) {
        for (int idx = 0; idx < this.listeners.size(); ++idx) {
            MonitorListener ml = this.listeners.get(idx);
            ml.addSample(model);
        }
    }

    public void addListener(MonitorListener listener) {
        this.listeners.add(listener);
    }
}

