/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.MonitorGuiListener;
import org.apache.jmeter.visualizers.MonitorModel;

public class ServerPanel
extends JPanel
implements MonitorGuiListener {
    private static final long serialVersionUID = 240L;
    private JLabel serverField;
    private JLabel timestampField;
    private final Dimension prefsize = new Dimension(25, 75);
    private JLabel healthIcon;
    private JLabel loadIcon;
    private static final ImageIcon HEALTHY = JMeterUtils.getImage((String)"monitor-healthy.gif");
    private static final ImageIcon ACTIVE = JMeterUtils.getImage((String)"monitor-active.gif");
    private static final ImageIcon WARNING = JMeterUtils.getImage((String)"monitor-warning.gif");
    private static final ImageIcon DEAD = JMeterUtils.getImage((String)"monitor-dead.gif");
    private static final ImageIcon LOAD_0 = JMeterUtils.getImage((String)"monitor-load-0.gif");
    private static final ImageIcon LOAD_1 = JMeterUtils.getImage((String)"monitor-load-1.gif");
    private static final ImageIcon LOAD_2 = JMeterUtils.getImage((String)"monitor-load-2.gif");
    private static final ImageIcon LOAD_3 = JMeterUtils.getImage((String)"monitor-load-3.gif");
    private static final ImageIcon LOAD_4 = JMeterUtils.getImage((String)"monitor-load-4.gif");
    private static final ImageIcon LOAD_5 = JMeterUtils.getImage((String)"monitor-load-5.gif");
    private static final ImageIcon LOAD_6 = JMeterUtils.getImage((String)"monitor-load-6.gif");
    private static final ImageIcon LOAD_7 = JMeterUtils.getImage((String)"monitor-load-7.gif");
    private static final ImageIcon LOAD_8 = JMeterUtils.getImage((String)"monitor-load-8.gif");
    private static final ImageIcon LOAD_9 = JMeterUtils.getImage((String)"monitor-load-9.gif");
    private static final ImageIcon LOAD_10 = JMeterUtils.getImage((String)"monitor-load-10.gif");

    public ServerPanel(MonitorModel model) {
        this.init(model);
    }

    @Deprecated
    public ServerPanel() {
    }

    private void init(MonitorModel model) {
        this.setLayout(new FlowLayout());
        this.serverField = new JLabel(model.getURL());
        this.add(this.serverField);
        this.healthIcon = new JLabel(ServerPanel.getHealthyImageIcon(model.getHealth()));
        this.healthIcon.setPreferredSize(this.prefsize);
        this.add(this.healthIcon);
        this.loadIcon = new JLabel(ServerPanel.getLoadImageIcon(model.getLoad()));
        this.add(this.loadIcon);
        this.timestampField = new JLabel(model.getTimestampString());
        this.add(this.timestampField);
    }

    private static ImageIcon getHealthyImageIcon(int health) {
        ImageIcon i = null;
        switch (health) {
            case 3: {
                i = HEALTHY;
                break;
            }
            case 2: {
                i = ACTIVE;
                break;
            }
            case 1: {
                i = WARNING;
                break;
            }
            case 0: {
                i = DEAD;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected health value: " + health);
            }
        }
        return i;
    }

    private static ImageIcon getLoadImageIcon(int load) {
        if (load == 0) {
            return LOAD_0;
        }
        if (load > 0 && load <= 10) {
            return LOAD_1;
        }
        if (load > 10 && load <= 20) {
            return LOAD_2;
        }
        if (load > 20 && load <= 30) {
            return LOAD_3;
        }
        if (load > 30 && load <= 40) {
            return LOAD_4;
        }
        if (load > 40 && load <= 50) {
            return LOAD_5;
        }
        if (load > 50 && load <= 60) {
            return LOAD_6;
        }
        if (load > 60 && load <= 70) {
            return LOAD_7;
        }
        if (load > 70 && load <= 80) {
            return LOAD_8;
        }
        if (load > 80 && load <= 90) {
            return LOAD_9;
        }
        return LOAD_10;
    }

    @Override
    public void updateGui(MonitorModel stat) {
        this.loadIcon.setIcon(ServerPanel.getLoadImageIcon(stat.getLoad()));
        this.healthIcon.setIcon(ServerPanel.getHealthyImageIcon(stat.getHealth()));
        this.timestampField.setText(stat.getTimestampString());
        this.updateGui();
    }

    @Override
    public void updateGui() {
        this.repaint();
    }
}

