/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.tree;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.tree.NamedTreeNode;
import org.apache.jmeter.report.gui.tree.ReportTreeModel;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class ReportTreeNode
extends DefaultMutableTreeNode
implements NamedTreeNode {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final ReportTreeModel treeModel;

    public ReportTreeNode() {
        this(null, null);
    }

    public ReportTreeNode(TestElement userObj, ReportTreeModel treeModel) {
        super(userObj);
        this.treeModel = treeModel;
    }

    public boolean isEnabled() {
        return this.getTestElement().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getTestElement().setEnabled(enabled);
        this.treeModel.nodeChanged(this);
    }

    public ImageIcon getIcon() {
        return this.getIcon(true);
    }

    public ImageIcon getIcon(boolean enabled) {
        try {
            if (this.getTestElement() instanceof TestBean) {
                try {
                    Image img = Introspector.getBeanInfo(this.getTestElement().getClass()).getIcon(1);
                    if (img == null) {
                        Object clazz = Introspector.getBeanInfo(this.getTestElement().getClass()).getBeanDescriptor().getValue("TestElement.gui_class");
                        if (clazz == null) {
                            log.error("Can't obtain GUI class for " + this.getTestElement().getClass().getName());
                            return null;
                        }
                        return GUIFactory.getIcon(Class.forName((String)clazz), (boolean)enabled);
                    }
                    return new ImageIcon(img);
                }
                catch (IntrospectionException e1) {
                    log.error("Can't obtain icon", (Throwable)e1);
                    throw new JMeterError((Throwable)e1);
                }
            }
            return GUIFactory.getIcon(Class.forName(this.getTestElement().getPropertyAsString("TestElement.gui_class")), (boolean)enabled);
        }
        catch (ClassNotFoundException e) {
            log.warn("Can't get icon for class " + this.getTestElement(), (Throwable)e);
            return null;
        }
    }

    public Collection<String> getMenuCategories() {
        try {
            return ReportGuiPackage.getInstance().getGui(this.getTestElement()).getMenuCategories();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu createPopupMenu() {
        try {
            return ReportGuiPackage.getInstance().getGui(this.getTestElement()).createPopupMenu();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public TestElement getTestElement() {
        return (TestElement)this.getUserObject();
    }

    public String getStaticLabel() {
        return ReportGuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getStaticLabel();
    }

    public String getDocAnchor() {
        return ReportGuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getDocAnchor();
    }

    public void setName(String name) {
        ((TestElement)this.getUserObject()).setName(name);
    }

    public String getName() {
        return ((TestElement)this.getUserObject()).getName();
    }

    public void nameChanged() {
        this.treeModel.nodeChanged(this);
    }
}

