/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.writers.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.jmeter.gui.util.ReportFilePanel;
import org.apache.jmeter.gui.util.ReportMenuFactory;
import org.apache.jmeter.report.gui.AbstractReportGui;
import org.apache.jmeter.report.writers.HTMLReportWriter;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class HTMLReportWriterGui
extends AbstractReportGui {
    private static final long serialVersionUID = 240L;
    private ReportFilePanel outputDirectory = new ReportFilePanel(JMeterUtils.getResString((String)"report_output_directory"), "*");

    public HTMLReportWriterGui() {
        this.init();
    }

    public String getLabelResource() {
        return "report_writer_html";
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        ReportMenuFactory.addFileMenu(pop);
        ReportMenuFactory.addEditMenu(pop, true);
        return pop;
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.setBackground(Color.white);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(10, 10));
        pane.setBackground(Color.white);
        pane.add((Component)this.getNamePanel(), "North");
        this.outputDirectory.setBackground(Color.white);
        pane.add((Component)((Object)this.outputDirectory), "South");
        this.add(pane, "North");
    }

    public TestElement createTestElement() {
        HTMLReportWriter element = new HTMLReportWriter();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        HTMLReportWriter wr = (HTMLReportWriter)element;
        wr.setTargetDirectory(this.outputDirectory.getFilename());
    }

    public void configure(TestElement element) {
        super.configure(element);
        HTMLReportWriter wr = (HTMLReportWriter)element;
        this.outputDirectory.setFilename(wr.getTargetDirectory());
    }
}

