/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import org.apache.jmeter.report.DataSet;
import org.apache.jmeter.report.ReportChart;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jorphan.util.JOrphanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChart
extends AbstractTestElement
implements ReportChart {
    private static final long serialVersionUID = 240L;
    public static final String REPORT_CHART_X_AXIS = "ReportChart.chart.x.axis";
    public static final String REPORT_CHART_Y_AXIS = "ReportChart.chart.y.axis";
    public static final String REPORT_CHART_X_LABEL = "ReportChart.chart.x.label";
    public static final String REPORT_CHART_Y_LABEL = "ReportChart.chart.y.label";
    public static final String REPORT_CHART_TITLE = "ReportChart.chart.title";
    public static final String REPORT_CHART_CAPTION = "ReportChart.chart.caption";
    public static final String REPORT_CHART_WIDTH = "ReportChart.chart.width";
    public static final String REPORT_CHART_HEIGHT = "ReportChart.chart.height";
    public static final int DEFAULT_WIDTH = 350;
    public static final int DEFAULT_HEIGHT = 350;
    public static final String X_DATA_FILENAME_LABEL = "Filename";
    public static final String X_DATA_DATE_LABEL = "Date";
    public static final String[] X_LABELS = new String[]{"Filename", "Date"};
    protected BufferedImage image = null;

    public String getXAxis() {
        return this.getPropertyAsString(REPORT_CHART_X_AXIS);
    }

    public String getFormattedXAxis() {
        String text = this.getXAxis();
        if (text.indexOf(46) > -1) {
            text = text.substring(text.indexOf(46) + 1);
            text = JOrphanUtils.replaceAllChars((String)text, (char)'_', (String)" ");
        }
        return text;
    }

    public void setXAxis(String field) {
        this.setProperty(REPORT_CHART_X_AXIS, field);
    }

    public String getYAxis() {
        return this.getPropertyAsString(REPORT_CHART_Y_AXIS);
    }

    public void setYAxis(String scale) {
        this.setProperty(REPORT_CHART_Y_AXIS, scale);
    }

    public String getXLabel() {
        return this.getPropertyAsString(REPORT_CHART_X_LABEL);
    }

    public void setXLabel(String label) {
        this.setProperty(REPORT_CHART_X_LABEL, label);
    }

    public String getYLabel() {
        return this.getPropertyAsString(REPORT_CHART_Y_LABEL);
    }

    public void setYLabel(String label) {
        this.setProperty(REPORT_CHART_Y_LABEL, label);
    }

    public String getTitle() {
        return this.getPropertyAsString(REPORT_CHART_TITLE);
    }

    public void setTitle(String title) {
        this.setProperty(REPORT_CHART_TITLE, title);
    }

    public String getCaption() {
        return this.getPropertyAsString(REPORT_CHART_CAPTION);
    }

    public void setCaption(String caption) {
        this.setProperty(REPORT_CHART_CAPTION, caption);
    }

    public int getWidth() {
        int w = this.getPropertyAsInt(REPORT_CHART_WIDTH);
        if (w <= 0) {
            return 350;
        }
        return w;
    }

    public void setWidth(String width) {
        this.setProperty(REPORT_CHART_WIDTH, String.valueOf(width));
    }

    public int getHeight() {
        int h = this.getPropertyAsInt(REPORT_CHART_HEIGHT);
        if (h <= 0) {
            return 350;
        }
        return h;
    }

    public void setHeight(String height) {
        this.setProperty(REPORT_CHART_HEIGHT, String.valueOf(height));
    }

    @Override
    public abstract JComponent renderChart(List<DataSet> var1);

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
    }

    public double getValue(SamplingStatCalculator stat) {
        if (this.getXAxis().equals("ReportTable.50_percent")) {
            return stat.getPercentPoint(0.5).doubleValue();
        }
        if (this.getXAxis().equals("ReportTable.90_percent")) {
            return stat.getPercentPoint(0.9).doubleValue();
        }
        if (this.getXAxis().equals("ReportTable.Error.rate")) {
            return stat.getErrorPercentage();
        }
        if (this.getXAxis().equals("ReportTable.Max")) {
            return stat.getMax().doubleValue();
        }
        if (this.getXAxis().equals("ReportTable.Mean")) {
            return stat.getMean();
        }
        if (this.getXAxis().equals("ReportTable.Median")) {
            return stat.getMedian().doubleValue();
        }
        if (this.getXAxis().equals("ReportTable.Min")) {
            return stat.getMin().doubleValue();
        }
        if (this.getXAxis().equals("ReportTable.Response_rate")) {
            return stat.getRate();
        }
        if (this.getXAxis().equals("ReportTable.Transfer_rate")) {
            return stat.getKBPerSecond();
        }
        return Double.NaN;
    }
}

