/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.protocol.tcp.sampler.TCPClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class TCPSampler
extends AbstractSampler
implements ThreadListener,
Interruptible {
    private static final long serialVersionUID = 280L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.LoginConfigGui", "org.apache.jmeter.protocol.tcp.config.gui.TCPConfigGui", "org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final String SERVER = "TCPSampler.server";
    public static final String PORT = "TCPSampler.port";
    public static final String FILENAME = "TCPSampler.filename";
    public static final String CLASSNAME = "TCPSampler.classname";
    public static final String NODELAY = "TCPSampler.nodelay";
    public static final String TIMEOUT = "TCPSampler.timeout";
    public static final String TIMEOUT_CONNECT = "TCPSampler.ctimeout";
    public static final String REQUEST = "TCPSampler.request";
    public static final String RE_USE_CONNECTION = "TCPSampler.reUseConnection";
    public static final boolean RE_USE_CONNECTION_DEFAULT = true;
    public static final String CLOSE_CONNECTION = "TCPSampler.closeConnection";
    public static final boolean CLOSE_CONNECTION_DEFAULT = false;
    public static final String SO_LINGER = "TCPSampler.soLinger";
    public static final String EOL_BYTE = "TCPSampler.EolByte";
    private static final String TCPKEY = "TCP";
    private static final String ERRKEY = "ERR";
    private static final String STATUS_PREFIX = JMeterUtils.getPropDefault((String)"tcp.status.prefix", (String)"");
    private static final String STATUS_SUFFIX = JMeterUtils.getPropDefault((String)"tcp.status.suffix", (String)"");
    private static final String STATUS_PROPERTIES = JMeterUtils.getPropDefault((String)"tcp.status.properties", (String)"");
    private static final Properties statusProps = new Properties();
    private static final boolean haveStatusProps;
    private static final ThreadLocal<Map<String, Object>> tp;
    private transient TCPClient protocolHandler;
    private transient boolean firstSample;
    private volatile transient Socket currentSocket;
    private static final String protoPrefix = "org.apache.jmeter.protocol.tcp.sampler.";

    public TCPSampler() {
        log.debug("Created " + (Object)((Object)this));
    }

    private String getError() {
        Map<String, Object> cp = tp.get();
        return (String)cp.get(ERRKEY);
    }

    private Socket getSocket(String socketKey) {
        Map<String, Object> cp = tp.get();
        Socket con = null;
        if (this.isReUseConnection() && (con = (Socket)cp.get(socketKey)) != null) {
            log.debug((Object)((Object)this) + " Reusing connection " + con);
        }
        if (con == null) {
            try {
                this.closeSocket(socketKey);
                InetSocketAddress sockaddr = new InetSocketAddress(this.getServer(), this.getPort());
                con = new Socket();
                if (this.getPropertyAsString(SO_LINGER, "").length() > 0) {
                    con.setSoLinger(true, this.getSoLinger());
                }
                con.connect(sockaddr, this.getConnectTimeout());
                if (log.isDebugEnabled()) {
                    log.debug("Created new connection " + con);
                }
                cp.put(socketKey, con);
            }
            catch (UnknownHostException e) {
                log.warn("Unknown host for " + this.getLabel(), (Throwable)e);
                cp.put(ERRKEY, e.toString());
                return null;
            }
            catch (IOException e) {
                log.warn("Could not create socket for " + this.getLabel(), (Throwable)e);
                cp.put(ERRKEY, e.toString());
                return null;
            }
        }
        try {
            con.setSoTimeout(this.getTimeout());
            con.setTcpNoDelay(this.getNoDelay());
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)this) + "  Timeout " + this.getTimeout() + " NoDelay " + this.getNoDelay());
            }
        }
        catch (SocketException se) {
            log.warn("Could not set timeout or nodelay for " + this.getLabel(), (Throwable)se);
            cp.put(ERRKEY, se.toString());
        }
        return con;
    }

    private String getSocketKey() {
        return "TCP#" + this.getServer() + "#" + this.getPort() + "#" + this.getUsername() + "#" + this.getPassword();
    }

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public void setServer(String newServer) {
        this.setProperty(SERVER, newServer);
    }

    public String getServer() {
        return this.getPropertyAsString(SERVER);
    }

    public boolean isReUseConnection() {
        return this.getPropertyAsBoolean(RE_USE_CONNECTION, true);
    }

    public void setCloseConnection(String close) {
        this.setProperty(CLOSE_CONNECTION, close, "");
    }

    public boolean isCloseConnection() {
        return this.getPropertyAsBoolean(CLOSE_CONNECTION, false);
    }

    public void setSoLinger(String soLinger) {
        this.setProperty(SO_LINGER, soLinger, "");
    }

    public int getSoLinger() {
        return this.getPropertyAsInt(SO_LINGER);
    }

    public void setEolByte(String eol) {
        this.setProperty(EOL_BYTE, eol, "");
    }

    public int getEolByte() {
        return this.getPropertyAsInt(EOL_BYTE);
    }

    public void setPort(String newFilename) {
        this.setProperty(PORT, newFilename);
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT);
    }

    public void setFilename(String newFilename) {
        this.setProperty(FILENAME, newFilename);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setRequestData(String newRequestData) {
        this.setProperty(REQUEST, newRequestData);
    }

    public String getRequestData() {
        return this.getPropertyAsString(REQUEST);
    }

    public void setTimeout(String newTimeout) {
        this.setProperty(TIMEOUT, newTimeout);
    }

    public int getTimeout() {
        return this.getPropertyAsInt(TIMEOUT);
    }

    public void setConnectTimeout(String newTimeout) {
        this.setProperty(TIMEOUT_CONNECT, newTimeout, "");
    }

    public int getConnectTimeout() {
        return this.getPropertyAsInt(TIMEOUT_CONNECT, 0);
    }

    public boolean getNoDelay() {
        return this.getPropertyAsBoolean(NODELAY);
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname, "");
    }

    public String getClassname() {
        String clazz = this.getPropertyAsString(CLASSNAME, "");
        if (clazz == null || clazz.length() == 0) {
            clazz = JMeterUtils.getPropDefault((String)"tcp.handler", (String)"TCPClientImpl");
        }
        return clazz;
    }

    public String getLabel() {
        return "tcp://" + this.getServer() + ":" + this.getPort();
    }

    private Class<?> getClass(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                c = Class.forName(protoPrefix + className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e1) {
                log.error("Could not find protocol class '" + className + "'");
            }
        }
        return c;
    }

    private TCPClient getProtocol() {
        TCPClient TCPClient2 = null;
        Class<?> javaClass = this.getClass(this.getClassname());
        if (javaClass == null) {
            return null;
        }
        try {
            TCPClient2 = (TCPClient)javaClass.newInstance();
            if (this.getPropertyAsString(EOL_BYTE, "").length() > 0) {
                TCPClient2.setEolByte(this.getEolByte());
                log.info("Using eolByte=" + this.getEolByte());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)this) + "Created: " + this.getClassname() + "@" + Integer.toHexString(TCPClient2.hashCode()));
            }
        }
        catch (Exception e) {
            log.error((Object)((Object)this) + " Exception creating: " + this.getClassname(), (Throwable)e);
        }
        return TCPClient2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        if (this.firstSample) {
            this.initSampling();
            this.firstSample = false;
        }
        boolean reUseConnection = this.isReUseConnection();
        boolean closeConnection = this.isCloseConnection();
        String socketKey = this.getSocketKey();
        if (log.isDebugEnabled()) {
            log.debug(this.getLabel() + " " + this.getFilename() + " " + this.getUsername() + " " + this.getPassword());
        }
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("Host: ").append(this.getServer());
        sb.append(" Port: ").append(this.getPort());
        sb.append("\n");
        sb.append("Reuse: ").append(reUseConnection);
        sb.append(" Close: ").append(closeConnection);
        sb.append("\n[");
        sb.append("SOLINGER: ").append(this.getSoLinger());
        sb.append(" EOL: ").append(this.getEolByte());
        sb.append(" noDelay: ").append(this.getNoDelay());
        sb.append("]");
        res.setSamplerData(sb.toString());
        res.sampleStart();
        try {
            Socket sock;
            try {
                sock = this.getSocket(socketKey);
            }
            finally {
                res.connectEnd();
            }
            if (sock == null) {
                res.setResponseCode("500");
                res.setResponseMessage(this.getError());
            } else if (this.protocolHandler == null) {
                res.setResponseCode("500");
                res.setResponseMessage("Protocol handler not found");
            } else {
                this.currentSocket = sock;
                InputStream is = sock.getInputStream();
                OutputStream os = sock.getOutputStream();
                String req = this.getRequestData();
                res.setSamplerData(req);
                this.protocolHandler.write(os, req);
                String in = this.protocolHandler.read(is);
                isSuccessful = this.setupSampleResult(res, in, null, this.protocolHandler.getCharset());
            }
        }
        catch (ReadException ex) {
            log.error("", (Throwable)ex);
            isSuccessful = this.setupSampleResult(res, ex.getPartialResponse(), ex, this.protocolHandler.getCharset());
            this.closeSocket(socketKey);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            isSuccessful = this.setupSampleResult(res, "", ex, this.protocolHandler.getCharset());
            this.closeSocket(socketKey);
        }
        finally {
            this.currentSocket = null;
            res.sampleEnd();
            res.setSuccessful(isSuccessful);
            if (!reUseConnection || closeConnection) {
                this.closeSocket(socketKey);
            }
        }
        return res;
    }

    private boolean setupSampleResult(SampleResult sampleResult, String readResponse, Exception exception, String encoding) {
        boolean isSuccessful;
        sampleResult.setResponseData(readResponse, encoding);
        sampleResult.setDataType("text");
        if (exception == null) {
            sampleResult.setResponseCodeOK();
            sampleResult.setResponseMessage("OK");
        } else {
            sampleResult.setResponseCode("500");
            sampleResult.setResponseMessage(exception.toString());
        }
        boolean bl = isSuccessful = exception == null;
        if (!StringUtils.isEmpty((CharSequence)readResponse) && STATUS_PREFIX.length() > 0) {
            int i = readResponse.indexOf(STATUS_PREFIX);
            int j = readResponse.indexOf(STATUS_SUFFIX, i + STATUS_PREFIX.length());
            if (i != -1 && j > i) {
                String rc = readResponse.substring(i + STATUS_PREFIX.length(), j);
                sampleResult.setResponseCode(rc);
                boolean bl2 = isSuccessful = isSuccessful && this.checkResponseCode(rc);
                if (haveStatusProps) {
                    sampleResult.setResponseMessage(statusProps.getProperty(rc, "Status code not found in properties"));
                } else {
                    sampleResult.setResponseMessage("No status property file");
                }
            } else {
                sampleResult.setResponseCode("999");
                sampleResult.setResponseMessage("Status value not found");
                isSuccessful = false;
            }
        }
        return isSuccessful;
    }

    private boolean checkResponseCode(String rc) {
        if (rc.compareTo("400") >= 0 && rc.compareTo("499") <= 0) {
            return false;
        }
        return rc.compareTo("500") < 0 || rc.compareTo("599") > 0;
    }

    public void threadStarted() {
        log.debug("Thread Started");
        this.firstSample = true;
    }

    private void initSampling() {
        this.protocolHandler = this.getProtocol();
        log.debug("Using Protocol Handler: " + (this.protocolHandler == null ? "NONE" : this.protocolHandler.getClass().getName()));
        if (this.protocolHandler != null) {
            this.protocolHandler.setupTest();
        }
    }

    private void closeSocket(String socketKey) {
        Map<String, Object> cp = tp.get();
        Socket con = (Socket)cp.remove(socketKey);
        if (con != null) {
            log.debug((Object)((Object)this) + " Closing connection " + con);
            try {
                con.close();
            }
            catch (IOException e) {
                log.warn("Error closing socket " + e);
            }
        }
    }

    public void threadFinished() {
        log.debug("Thread Finished");
        this.tearDown();
        if (this.protocolHandler != null) {
            this.protocolHandler.teardownTest();
        }
    }

    private void tearDown() {
        Map<String, Object> cp = tp.get();
        for (Map.Entry<String, Object> element : cp.entrySet()) {
            if (!element.getKey().startsWith(TCPKEY)) continue;
            try {
                ((Socket)element.getValue()).close();
            }
            catch (IOException iOException) {}
        }
        cp.clear();
        tp.remove();
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    public boolean interrupt() {
        Socket sock = this.currentSocket;
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        boolean hsp = false;
        log.debug("Status prefix=" + STATUS_PREFIX);
        log.debug("Status suffix=" + STATUS_SUFFIX);
        log.debug("Status properties=" + STATUS_PROPERTIES);
        if (STATUS_PROPERTIES.length() > 0) {
            File f = new File(STATUS_PROPERTIES);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                statusProps.load(fis);
                log.debug("Successfully loaded properties");
                hsp = true;
            }
            catch (FileNotFoundException e) {
                log.debug("Property file not found");
                JOrphanUtils.closeQuietly((Closeable)fis);
            }
            catch (IOException e2) {
                log.debug("Property file error " + e2.toString());
                {
                    catch (Throwable throwable) {
                        JOrphanUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                JOrphanUtils.closeQuietly((Closeable)fis);
            }
            JOrphanUtils.closeQuietly((Closeable)fis);
        }
        haveStatusProps = hsp;
        tp = new ThreadLocal<Map<String, Object>>(){

            @Override
            protected Map<String, Object> initialValue() {
                return new HashMap<String, Object>();
            }
        };
    }
}

