/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.converter.EnumConverter;
import org.apache.johnzon.mapper.reflection.Mappings;

public class Mapper {
    protected static final JsonObject EMPTY_OBJECT = Json.createObjectBuilder().build();
    private static final Converter<Object> FALLBACK_CONVERTER = new FallbackConverter();
    protected final Mappings mappings;
    protected final JsonReaderFactory readerFactory;
    protected final JsonGeneratorFactory generatorFactory;
    protected final boolean close;
    protected final ConcurrentMap<Type, Converter<?>> converters;
    protected final int version;

    public Mapper(JsonReaderFactory readerFactory, JsonGeneratorFactory generatorFactory, boolean doClose, Map<Class<?>, Converter<?>> converters, int version, Comparator<String> attributeOrder) {
        this.readerFactory = readerFactory;
        this.generatorFactory = generatorFactory;
        this.close = doClose;
        this.converters = new ConcurrentHashMap(converters);
        this.version = version;
        this.mappings = new Mappings(attributeOrder);
    }

    private static JsonGenerator writePrimitives(JsonGenerator generator, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            return generator.write(value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return generator.write(((Long)Long.class.cast(value)).longValue());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return generator.write(((Integer)Integer.class.cast(value)).intValue());
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return generator.write(((Number)Number.class.cast(value)).doubleValue());
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return generator.write(((Boolean)Boolean.class.cast(value)).booleanValue());
        }
        if (type == BigDecimal.class) {
            return generator.write((BigDecimal)BigDecimal.class.cast(value));
        }
        if (type == BigInteger.class) {
            return generator.write((BigInteger)BigInteger.class.cast(value));
        }
        if (type == Short.TYPE || type == Short.class) {
            return generator.write((int)((Short)Short.class.cast(value)).shortValue());
        }
        if (type == Character.TYPE || type == Character.class) {
            return generator.write(((Character)Character.class.cast(value)).toString());
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return generator.write((int)((Byte)Byte.class.cast(value)).byteValue());
        }
        return null;
    }

    private static JsonGenerator writePrimitives(JsonGenerator generator, String key, Class<?> type, Object value) {
        if (type == String.class) {
            return generator.write(key, value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return generator.write(key, ((Long)Long.class.cast(value)).longValue());
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return generator.write(key, ((Number)Number.class.cast(value)).intValue());
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return generator.write(key, ((Number)Number.class.cast(value)).doubleValue());
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return generator.write(key, ((Boolean)Boolean.class.cast(value)).booleanValue());
        }
        if (type == BigDecimal.class) {
            return generator.write(key, (BigDecimal)BigDecimal.class.cast(value));
        }
        if (type == BigInteger.class) {
            return generator.write(key, (BigInteger)BigInteger.class.cast(value));
        }
        if (type == Character.TYPE || type == Character.class) {
            return generator.write(key, ((Character)Character.class.cast(value)).toString());
        }
        return generator;
    }

    private static <T> String doConverFrom(T value, Converter<T> converter) {
        if (converter == null) {
            throw new MapperException("can't convert " + value + " to String");
        }
        return converter.toString(value);
    }

    private <T> Converter<T> findConverter(Type aClass) {
        Class clazz;
        Converter converter = (Converter)this.converters.get(aClass);
        if (converter != null) {
            return converter;
        }
        if (Class.class.isInstance(aClass) && (clazz = (Class)Class.class.cast(aClass)).isEnum()) {
            EnumConverter enumConverter = new EnumConverter(clazz);
            this.converters.putIfAbsent(clazz, enumConverter);
            return enumConverter;
        }
        return null;
    }

    private Object convertTo(Type aClass, String text) {
        Converter converter = this.findConverter(aClass);
        if (converter == null) {
            this.converters.putIfAbsent(aClass, FALLBACK_CONVERTER);
            return FALLBACK_CONVERTER;
        }
        return converter.fromString(text);
    }

    public <T> void writeArray(Object object, OutputStream stream) {
        this.writeArray(Arrays.asList((Object[])object), stream);
    }

    public <T> void writeArray(T[] object, OutputStream stream) {
        this.writeArray(Arrays.asList(object), stream);
    }

    public <T> void writeArray(T[] object, Writer stream) {
        this.writeArray(Arrays.asList(object), stream);
    }

    public <T> void writeArray(Collection<T> object, OutputStream stream) {
        this.writeArray(object, (Writer)new OutputStreamWriter(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeArray(Collection<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        try {
            if (object == null) {
                generator = generator.writeStartArray().writeEnd();
            } else {
                generator = generator.writeStartArray();
                for (T t : object) {
                    generator = this.writeItem(generator, t);
                }
                generator = generator.writeEnd();
            }
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    private void doCloseOrFlush(JsonGenerator generator) {
        if (this.close) {
            generator.close();
        } else {
            generator.flush();
        }
    }

    public <T> void writeIterable(Iterable<T> object, OutputStream stream) {
        this.writeIterable(object, new OutputStreamWriter(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeIterable(Iterable<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        try {
            if (object == null) {
                generator = generator.writeStartArray().writeEnd();
            } else {
                generator.writeStartArray();
                for (T t : object) {
                    generator = this.writeItem(generator, t);
                }
                generator.writeEnd();
            }
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    public void writeObject(Object object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        this.doWriteHandlingNullObject(object, generator);
    }

    public void writeObject(Object object, OutputStream stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        this.doWriteHandlingNullObject(object, generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteHandlingNullObject(Object object, JsonGenerator generator) {
        if (object == null) {
            generator.writeStartObject().writeEnd().close();
            return;
        }
        try {
            this.doWriteObject(generator, object);
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    private JsonGenerator doWriteObject(JsonGenerator generator, Object object) {
        try {
            JsonGenerator gen = generator;
            if (object == null) {
                return generator;
            }
            if (Map.class.isInstance(object)) {
                gen = gen.writeStartObject();
                gen = this.writeMapBody((Map)object, gen);
                gen = gen.writeEnd();
                return gen;
            }
            gen = gen.writeStartObject();
            gen = this.doWriteObjectBody(gen, object);
            return gen.writeEnd();
        }
        catch (InvocationTargetException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
    }

    private JsonGenerator doWriteObjectBody(JsonGenerator gen, Object object) throws IllegalAccessException, InvocationTargetException {
        Class<?> objectClass = object.getClass();
        Mappings.ClassMapping classMapping = this.mappings.findOrCreateClassMapping(objectClass);
        if (classMapping == null) {
            throw new MapperException("No mapping for " + objectClass.getName());
        }
        JsonGenerator generator = gen;
        for (Map.Entry<String, Mappings.Getter> getterEntry : classMapping.getters.entrySet()) {
            Mappings.Getter getter = getterEntry.getValue();
            Object value = getter.setter.invoke(object, new Object[0]);
            if (value == null || getter.version >= 0 && this.version >= getter.version) continue;
            generator = this.writeValue(generator, value.getClass(), getter.primitive, getter.array, getter.collection, getter.map, getterEntry.getKey(), getter.converter == null ? value : getter.converter.toString(value));
        }
        return generator;
    }

    private JsonGenerator writeMapBody(Map<?, ?> object, JsonGenerator gen) throws InvocationTargetException, IllegalAccessException {
        JsonGenerator generator = gen;
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            Object key = entry.getKey();
            Class<?> valueClass = value.getClass();
            boolean primitive = Mappings.isPrimitive(valueClass);
            boolean clazz = this.mappings.getClassMapping(valueClass) != null;
            boolean array = clazz || primitive ? false : valueClass.isArray();
            boolean collection = clazz || primitive || array ? false : Collection.class.isAssignableFrom(valueClass);
            boolean map = clazz || primitive || array || collection ? false : Map.class.isAssignableFrom(valueClass);
            generator = this.writeValue(generator, valueClass, primitive, array, collection, map, key == null ? "null" : key.toString(), value);
        }
        return generator;
    }

    private JsonGenerator writeValue(JsonGenerator generator, Class<?> type, boolean primitive, boolean array, boolean collection, boolean map, String key, Object value) throws InvocationTargetException, IllegalAccessException {
        if (array) {
            JsonGenerator gen = generator.writeStartArray(key);
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                gen = this.writeItem(gen, Array.get(value, i));
            }
            return gen.writeEnd();
        }
        if (collection) {
            JsonGenerator gen = generator.writeStartArray(key);
            for (Object o : (Collection)Collection.class.cast(value)) {
                gen = this.writeItem(gen, o);
            }
            return gen.writeEnd();
        }
        if (map) {
            JsonGenerator gen = generator.writeStartObject(key);
            gen = this.writeMapBody((Map)value, gen);
            return gen.writeEnd();
        }
        if (primitive) {
            return Mapper.writePrimitives(generator, key, type, value);
        }
        Converter converter = this.findConverter(type);
        if (converter != null) {
            return this.writeValue(generator, String.class, true, false, false, false, key, Mapper.doConverFrom(value, converter));
        }
        return this.doWriteObjectBody(generator.writeStartObject(key), value).writeEnd();
    }

    private JsonGenerator writeItem(JsonGenerator generator, Object o) {
        JsonGenerator newGen = Mapper.writePrimitives(generator, o);
        if (newGen == null) {
            return this.doWriteObject(generator, o);
        }
        return newGen;
    }

    public <T> T readObject(Reader stream, Type clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return this.mapObject(clazz, reader);
    }

    public <T> T readObject(InputStream stream, Type clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return this.mapObject(clazz, reader);
    }

    private <T> T mapObject(Type clazz, JsonReader reader) {
        try {
            Object object = this.buildObject(clazz, reader.readObject());
            return (T)object;
        }
        catch (InstantiationException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <C extends Collection<T>, T> C readCollection(InputStream stream, ParameterizedType genericType, Class<T> raw) {
        JsonReader reader = this.readerFactory.createReader(stream);
        Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(genericType, raw);
        if (mapping == null) {
            throw new UnsupportedOperationException("type " + genericType + " not supported");
        }
        try {
            Collection<T> collection = this.mapCollection(mapping, reader.readArray());
            return (C)collection;
        }
        catch (InstantiationException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <C extends Collection<T>, T> C readCollection(Reader stream, ParameterizedType genericType, Class<T> raw) {
        JsonReader reader = this.readerFactory.createReader(stream);
        Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(genericType, raw);
        if (mapping == null) {
            throw new UnsupportedOperationException("type " + genericType + " not supported");
        }
        try {
            Collection<T> collection = this.mapCollection(mapping, reader.readArray());
            return (C)collection;
        }
        catch (InstantiationException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <T> T[] readArray(Reader stream, Class<T> clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return this.mapArray(clazz, reader);
    }

    public <T> T[] readArray(InputStream stream, Class<T> clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return this.mapArray(clazz, reader);
    }

    private <T> T[] mapArray(Class<T> clazz, JsonReader reader) {
        try {
            Object[] objectArray = (Object[])this.buildArrayWithComponentType(reader.readArray(), clazz);
            return objectArray;
        }
        catch (InstantiationException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object buildObject(Type type, JsonObject object) throws InstantiationException, IllegalAccessException {
        Mappings.ClassMapping classMapping = this.mappings.findOrCreateClassMapping(type);
        if (classMapping == null) {
            if (!ParameterizedType.class.isInstance(type)) throw new MapperException("Can't map " + type);
            ParameterizedType aType = (ParameterizedType)ParameterizedType.class.cast(type);
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            if (fieldArgTypes.length < 2) throw new MapperException("Can't map " + type + ", not a map and no Mapping found");
            Class raw = (Class)Class.class.cast(aType.getRawType());
            AbstractMap map = SortedMap.class.isAssignableFrom(raw) ? new TreeMap() : (ConcurrentMap.class.isAssignableFrom(raw) ? new ConcurrentHashMap(object.size()) : (Map.class.isAssignableFrom(raw) ? new HashMap(object.size()) : null));
            if (map != null) {
                Type keyType = ParameterizedType.class.isInstance(fieldArgTypes[0]) ? fieldArgTypes[0] : fieldArgTypes[0];
                for (Map.Entry value : object.entrySet()) {
                    map.put(this.convertTo(keyType, (String)value.getKey()), this.toObject((JsonValue)value.getValue(), fieldArgTypes[1]));
                }
                return map;
            }
        }
        Object t = classMapping.clazz.newInstance();
        for (Map.Entry<String, Mappings.Setter> setter : classMapping.setters.entrySet()) {
            JsonValue jsonValue = (JsonValue)object.get((Object)setter.getKey());
            Mappings.Setter value = setter.getValue();
            Method setterMethod = value.setter;
            Object convertedValue = value.converter == null ? this.toObject(jsonValue, value.paramType) : (jsonValue.getValueType() == JsonValue.ValueType.STRING ? value.converter.fromString(((JsonString)JsonString.class.cast(jsonValue)).getString()) : value.converter.fromString(jsonValue.toString()));
            if (convertedValue == null) continue;
            try {
                setterMethod.invoke(t, convertedValue);
            }
            catch (InvocationTargetException e) {
                throw new MapperException(e.getCause());
            }
        }
        return t;
    }

    private Object toObject(JsonValue jsonValue, Type type) throws InstantiationException, IllegalAccessException {
        if (jsonValue == null || jsonValue == JsonValue.NULL) {
            return null;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (jsonValue == JsonValue.FALSE) {
                return Boolean.FALSE;
            }
            if (jsonValue == JsonValue.TRUE) {
                return Boolean.TRUE;
            }
            throw new MapperException("Unable to parse " + jsonValue + " to boolean");
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.convertTo((Type)Class.class.cast(type), ((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            return this.buildObject(type, (JsonObject)JsonObject.class.cast(jsonValue));
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            return this.buildArray(type, (JsonArray)JsonArray.class.cast(jsonValue));
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (type == Long.class || type == Long.TYPE) {
                return number.longValue();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return number.intValue();
            }
            if (type == Short.class || type == Short.TYPE) {
                return (short)number.intValue();
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return (byte)number.intValue();
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf((float)number.doubleValue());
            }
            if (type == Double.class || type == Double.TYPE) {
                return number.doubleValue();
            }
            if (type == BigInteger.class) {
                return number.bigIntegerValue();
            }
            if (type == BigDecimal.class) {
                return number.bigDecimalValue();
            }
        } else if (JsonString.class.isInstance(jsonValue)) {
            return this.convertTo((Type)Class.class.cast(type), ((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        throw new MapperException("Unable to parse " + jsonValue + " to " + type);
    }

    private Object buildArray(Type type, JsonArray jsonArray) throws IllegalAccessException, InstantiationException {
        Mappings.CollectionMapping mapping;
        Class clazz;
        if (Class.class.isInstance(type) && (clazz = (Class)Class.class.cast(type)).isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return this.buildArrayWithComponentType(jsonArray, componentType);
        }
        if (ParameterizedType.class.isInstance(type) && (mapping = this.mappings.findCollectionMapping((ParameterizedType)ParameterizedType.class.cast(type), (Class)((ParameterizedType)ParameterizedType.class.cast(type)).getRawType())) != null) {
            return this.mapCollection(mapping, jsonArray);
        }
        throw new UnsupportedOperationException("type " + type + " not supported");
    }

    private <T> Collection<T> mapCollection(Mappings.CollectionMapping mapping, JsonArray jsonArray) throws InstantiationException, IllegalAccessException {
        AbstractCollection collection;
        if (SortedSet.class == mapping.raw) {
            collection = new TreeSet();
        } else if (Set.class == mapping.raw) {
            collection = new HashSet(jsonArray.size());
        } else if (Queue.class == mapping.raw) {
            collection = new ArrayBlockingQueue(jsonArray.size());
        } else if (List.class == mapping.raw) {
            collection = new ArrayList(jsonArray.size());
        } else {
            throw new IllegalStateException("not supported collection type: " + mapping.raw.getName());
        }
        for (JsonValue value : jsonArray) {
            Object element = this.toObject(value, mapping.arg);
            collection.add(element);
        }
        return collection;
    }

    private Object buildArrayWithComponentType(JsonArray jsonArray, Class<?> componentType) throws InstantiationException, IllegalAccessException {
        Object array = Array.newInstance(componentType, jsonArray.size());
        int i = 0;
        for (JsonValue value : jsonArray) {
            Array.set(array, i++, this.toObject(value, componentType));
        }
        return array;
    }

    private static class FallbackConverter
    implements Converter<Object> {
        private FallbackConverter() {
        }

        @Override
        public String toString(Object instance) {
            return instance.toString();
        }

        @Override
        public Object fromString(String text) {
            throw new UnsupportedOperationException("Using fallback converter, this only works in write mode but not in read. Please register a custom converter to do so.");
        }
    }
}

