/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Converter;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    private final Map<String, T> values;

    public EnumConverter(Class<T> aClass) {
        Enum[] enumConstants = (Enum[])aClass.getEnumConstants();
        this.values = new HashMap<String, T>(enumConstants.length);
        for (Enum t : enumConstants) {
            this.values.put(t.name(), t);
        }
    }

    @Override
    public String toString(T instance) {
        return ((Enum)instance).name();
    }

    @Override
    public T fromString(String text) {
        return (T)((Enum)this.values.get(text));
    }
}

