/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.apache.kafka.connect.source.SourceConnector;

public class FileStreamSourceConnector
extends SourceConnector {
    public static final String TOPIC_CONFIG = "topic";
    public static final String FILE_CONFIG = "file";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("file", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Source filename. If not specified, the standard input will be used").define("topic", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "The topic to publish data to");
    private String filename;
    private String topic;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        this.filename = props.get(FILE_CONFIG);
        this.topic = props.get(TOPIC_CONFIG);
        if (this.topic == null || this.topic.isEmpty()) {
            throw new ConnectException("FileStreamSourceConnector configuration must include 'topic' setting");
        }
        if (this.topic.contains(",")) {
            throw new ConnectException("FileStreamSourceConnector should only have a single topic when used as a source.");
        }
    }

    public Class<? extends Task> taskClass() {
        return FileStreamSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.filename != null) {
            config.put(FILE_CONFIG, this.filename);
        }
        config.put(TOPIC_CONFIG, this.topic);
        configs.add(config);
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

