/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamSinkConnector
extends SinkConnector {
    private static final Logger log = LoggerFactory.getLogger(FileStreamSinkConnector.class);
    public static final String FILE_CONFIG = "file";
    static final ConfigDef CONFIG_DEF = new ConfigDef().define("file", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Destination filename. If not specified, the standard output will be used");
    private Map<String, String> props;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        this.props = props;
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, props);
        String filename = config.getString(FILE_CONFIG);
        filename = filename == null || filename.isEmpty() ? "standard output" : filename;
        log.info("Starting file sink connector writing to {}", (Object)filename);
    }

    public Class<? extends Task> taskClass() {
        return FileStreamSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.props);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public boolean alterOffsets(Map<String, String> connectorConfig, Map<TopicPartition, Long> offsets) {
        return true;
    }
}

