/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceCallback;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ClientUtils;
import org.apache.kafka.common.utils.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    private final long metadataFetchTimeoutMs;
    private final long totalMemorySize;
    private final Metrics metrics;
    private final Set<String> subscribedTopics;
    private final Set<TopicPartition> subscribedPartitions;

    public KafkaConsumer(Map<String, Object> configs) {
        this(new ConsumerConfig(configs), null);
    }

    public KafkaConsumer(Map<String, Object> configs, ConsumerRebalanceCallback callback) {
        this(new ConsumerConfig(configs), callback);
    }

    public KafkaConsumer(Properties properties) {
        this(new ConsumerConfig(properties), null);
    }

    public KafkaConsumer(Properties properties, ConsumerRebalanceCallback callback) {
        this(new ConsumerConfig(properties), callback);
    }

    private KafkaConsumer(ConsumerConfig config) {
        this(config, null);
    }

    private KafkaConsumer(ConsumerConfig config, ConsumerRebalanceCallback callback) {
        log.trace("Starting the Kafka consumer");
        this.subscribedTopics = new HashSet<String>();
        this.subscribedPartitions = new HashSet<TopicPartition>();
        this.metrics = new Metrics(new MetricConfig(), Collections.singletonList(new JmxReporter("kafka.consumer.")), new SystemTime());
        this.metadataFetchTimeoutMs = config.getLong("metadata.fetch.timeout.ms");
        this.totalMemorySize = config.getLong("total.memory.bytes");
        List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"));
        config.logUnused();
        log.debug("Kafka consumer started");
    }

    @Override
    public void subscribe(String ... topics) {
        if (this.subscribedPartitions.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (String topic : topics) {
            this.subscribedTopics.add(topic);
        }
    }

    @Override
    public void subscribe(TopicPartition ... partitions) {
        if (this.subscribedTopics.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (TopicPartition partition : partitions) {
            this.subscribedPartitions.add(partition);
        }
    }

    @Override
    public void unsubscribe(String ... topics) {
        for (String topic : topics) {
            if (!this.subscribedTopics.contains(topic)) {
                throw new IllegalStateException("Topic " + topic + " was never subscribed to. subscribe(" + topic + ") should be called prior" + " to unsubscribe(" + topic + ")");
            }
            this.subscribedTopics.remove(topic);
        }
    }

    @Override
    public void unsubscribe(TopicPartition ... partitions) {
        for (TopicPartition partition : partitions) {
            if (!this.subscribedPartitions.contains(partition)) {
                throw new IllegalStateException("Partition " + partition + " was never subscribed to. subscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ") should be called prior" + " to unsubscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ")");
            }
            this.subscribedPartitions.remove(partition);
        }
    }

    @Override
    public Map<String, ConsumerRecords> poll(long timeout) {
        return null;
    }

    @Override
    public OffsetMetadata commit(Map<TopicPartition, Long> offsets, boolean sync) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetMetadata commit(boolean sync) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(Map<TopicPartition, Long> offsets) {
    }

    @Override
    public Map<TopicPartition, Long> position(Collection<TopicPartition> partitions) {
        return null;
    }

    @Override
    public Map<TopicPartition, Long> committed(Collection<TopicPartition> partitions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<TopicPartition, Long> offsetsBeforeTime(long timestamp, Collection<TopicPartition> partitions) {
        return null;
    }

    @Override
    public Map<String, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void close() {
        log.trace("Closing the Kafka consumer.");
        this.subscribedTopics.clear();
        this.subscribedPartitions.clear();
        this.metrics.close();
        log.debug("The Kafka consumer has closed.");
    }
}

