/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Stat;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public final class Sensor {
    private final Metrics registry;
    private final String name;
    private final Sensor[] parents;
    private final List<Stat> stats;
    private final List<KafkaMetric> metrics;
    private final MetricConfig config;
    private final Time time;

    Sensor(Metrics registry, String name, Sensor[] parents, MetricConfig config, Time time) {
        this.registry = registry;
        this.name = Utils.notNull(name);
        this.parents = parents == null ? new Sensor[]{} : parents;
        this.metrics = new ArrayList<KafkaMetric>();
        this.stats = new ArrayList<Stat>();
        this.config = config;
        this.time = time;
        this.checkForest(new HashSet<Sensor>());
    }

    private void checkForest(Set<Sensor> sensors) {
        if (!sensors.add(this)) {
            throw new IllegalArgumentException("Circular dependency in sensors: " + this.name() + " is its own parent.");
        }
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i].checkForest(sensors);
        }
    }

    public String name() {
        return this.name;
    }

    public void record() {
        this.record(1.0);
    }

    public void record(double value) {
        this.record(value, this.time.milliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value, long timeMs) {
        Sensor sensor = this;
        synchronized (sensor) {
            for (int i = 0; i < this.stats.size(); ++i) {
                this.stats.get(i).record(this.config, value, timeMs);
            }
            this.checkQuotas(timeMs);
        }
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i].record(value, timeMs);
        }
    }

    private void checkQuotas(long timeMs) {
        for (int i = 0; i < this.metrics.size(); ++i) {
            Quota quota;
            KafkaMetric metric = this.metrics.get(i);
            MetricConfig config = metric.config();
            if (config == null || (quota = config.quota()) == null || quota.acceptable(metric.value(timeMs))) continue;
            throw new QuotaViolationException("Metric " + metric.name() + " is in violation of its quota of " + quota.bound());
        }
    }

    public void add(CompoundStat stat) {
        this.add(stat, null);
    }

    public synchronized void add(CompoundStat stat, MetricConfig config) {
        this.stats.add(Utils.notNull(stat));
        for (CompoundStat.NamedMeasurable m : stat.stats()) {
            KafkaMetric metric = new KafkaMetric(this, m.name(), m.description(), m.stat(), config == null ? this.config : config, this.time);
            this.registry.registerMetric(metric);
            this.metrics.add(metric);
        }
    }

    public void add(String name, MeasurableStat stat) {
        this.add(name, stat, null);
    }

    public void add(String name, String description, MeasurableStat stat) {
        this.add(name, description, stat, null);
    }

    public void add(String name, MeasurableStat stat, MetricConfig config) {
        this.add(name, "", stat, config);
    }

    public synchronized void add(String name, String description, MeasurableStat stat, MetricConfig config) {
        KafkaMetric metric = new KafkaMetric(this, Utils.notNull(name), Utils.notNull(description), Utils.notNull(stat), config == null ? this.config : config, this.time);
        this.registry.registerMetric(metric);
        this.metrics.add(metric);
        this.stats.add(stat);
    }

    synchronized List<KafkaMetric> metrics() {
        return Collections.unmodifiableList(this.metrics);
    }
}

