/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.errors.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Metadata {
    private static final Logger log = LoggerFactory.getLogger(Metadata.class);
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private int version;
    private long lastRefreshMs;
    private Cluster cluster;
    private boolean needUpdate;
    private final Set<String> topics;

    public Metadata() {
        this(100L, 3600000L);
    }

    public Metadata(long refreshBackoffMs, long metadataExpireMs) {
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.lastRefreshMs = 0L;
        this.version = 0;
        this.cluster = Cluster.empty();
        this.needUpdate = false;
        this.topics = new HashSet<String>();
    }

    public synchronized Cluster fetch() {
        return this.cluster;
    }

    public synchronized void add(String topic) {
        this.topics.add(topic);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.needUpdate ? 0L : Math.max(this.lastRefreshMs + this.metadataExpireMs - nowMs, 0L);
        long timeToAllowUpdate = this.lastRefreshMs + this.refreshBackoffMs - nowMs;
        return Math.max(timeToExpire, timeToAllowUpdate);
    }

    public synchronized int requestUpdate() {
        this.needUpdate = true;
        return this.version;
    }

    public synchronized void awaitUpdate(int lastVerison, long maxWaitMs) {
        long begin = System.currentTimeMillis();
        long remainingWaitMs = maxWaitMs;
        while (this.version <= lastVerison) {
            try {
                this.wait(remainingWaitMs);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long elapsed = System.currentTimeMillis() - begin;
            if (elapsed >= maxWaitMs) {
                throw new TimeoutException("Failed to update metadata after " + maxWaitMs + " ms.");
            }
            remainingWaitMs = maxWaitMs - elapsed;
        }
    }

    public synchronized Set<String> topics() {
        return new HashSet<String>(this.topics);
    }

    public synchronized void update(Cluster cluster, long now) {
        this.needUpdate = false;
        this.lastRefreshMs = now;
        ++this.version;
        this.cluster = cluster;
        this.notifyAll();
        log.debug("Updated cluster metadata version {} to {}", (Object)this.version, (Object)this.cluster);
    }

    public synchronized long lastUpdate() {
        return this.lastRefreshMs;
    }

    public long refreshBackoff() {
        return this.refreshBackoffMs;
    }
}

