/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

public final class Quota {
    private final boolean upper;
    private final double bound;

    public Quota(double bound, boolean upper) {
        this.bound = bound;
        this.upper = upper;
    }

    public static Quota upperBound(double upperBound) {
        return new Quota(upperBound, true);
    }

    public static Quota lowerBound(double lowerBound) {
        return new Quota(lowerBound, false);
    }

    public boolean isUpperBound() {
        return this.upper;
    }

    public double bound() {
        return this.bound;
    }

    public boolean acceptable(double value) {
        return this.upper && value <= this.bound || !this.upper && value >= this.bound;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.bound;
        result = 31 * result + (this.upper ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Quota)) {
            return false;
        }
        Quota that = (Quota)obj;
        return that.bound == this.bound && that.upper == this.upper;
    }
}

