/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = new RequestMatcher(){

        @Override
        public boolean matches(ClientRequest request) {
            return true;
        }
    };
    private final Time time;
    private int correlation = 0;
    private Node node = null;
    private final Set<String> ready = new HashSet<String>();
    private final Queue<ClientRequest> requests = new ArrayDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ArrayDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ArrayDeque<FutureResponse>();

    public MockClient(Time time) {
        this.time = time;
    }

    public boolean isReady(Node node, long now) {
        return this.ready.contains(node.idString());
    }

    public boolean ready(Node node, long now) {
        this.ready.add(node.idString());
        return true;
    }

    public long connectionDelay(Node node, long now) {
        return 0L;
    }

    public boolean connectionFailed(Node node) {
        return false;
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.request().destination().equals(node)) continue;
            this.responses.add(new ClientResponse(request, now, true, null));
            iter.remove();
        }
        this.ready.remove(node);
    }

    public void send(ClientRequest request, long now) {
        if (!this.futureResponses.isEmpty()) {
            FutureResponse futureResp = this.futureResponses.poll();
            if (!futureResp.requestMatcher.matches(request)) {
                throw new IllegalStateException("Next in line response did not match expected request");
            }
            ClientResponse resp = new ClientResponse(request, this.time.milliseconds(), futureResp.disconnected, futureResp.responseBody);
            this.responses.add(resp);
        } else {
            request.setSendTimeMs(now);
            this.requests.add(request);
        }
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>(this.responses);
        while (!this.responses.isEmpty()) {
            ClientResponse response = this.responses.poll();
            if (!response.request().hasCallback()) continue;
            response.request().callback().onComplete(response);
        }
        return copy;
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public void respond(Struct body) {
        this.respond(body, false);
    }

    public void respond(Struct body, boolean disconnected) {
        ClientRequest request = this.requests.remove();
        this.responses.add(new ClientResponse(request, this.time.milliseconds(), disconnected, body));
    }

    public void prepareResponse(Struct body) {
        this.prepareResponse(ALWAYS_TRUE, body, false);
    }

    public void prepareResponse(RequestMatcher matcher, Struct body) {
        this.prepareResponse(matcher, body, false);
    }

    public void prepareResponse(Struct body, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, body, disconnected);
    }

    public void prepareResponse(RequestMatcher matcher, Struct body, boolean disconnected) {
        this.futureResponses.add(new FutureResponse(body, disconnected, matcher));
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public int inFlightRequestCount(String node) {
        return this.requests.size();
    }

    public RequestHeader nextRequestHeader(ApiKeys key) {
        return new RequestHeader(key.id, "mock", this.correlation++);
    }

    public RequestHeader nextRequestHeader(ApiKeys key, short version) {
        return new RequestHeader(key.id, version, "mock", this.correlation++);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String node) {
        this.ready.remove(node);
    }

    public Node leastLoadedNode(long now) {
        return this.node;
    }

    public static interface RequestMatcher {
        public boolean matches(ClientRequest var1);
    }

    private class FutureResponse {
        public final Struct responseBody;
        public final boolean disconnected;
        public final RequestMatcher requestMatcher;

        public FutureResponse(Struct responseBody, boolean disconnected, RequestMatcher requestMatcher) {
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.requestMatcher = requestMatcher;
        }
    }
}

