/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.junit.Assert;
import org.junit.Test;

public class RecordSendTest {
    private TopicPartition topicPartition = new TopicPartition("test", 0);
    private long baseOffset = 45L;
    private long relOffset = 5L;

    @Test
    public void testTimeout() throws Exception {
        ProduceRequestResult request = new ProduceRequestResult();
        FutureRecordMetadata future = new FutureRecordMetadata(request, this.relOffset);
        Assert.assertFalse((String)"Request is not completed", (boolean)future.isDone());
        try {
            future.get(5L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        request.done(this.topicPartition, this.baseOffset, null);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)(this.baseOffset + this.relOffset), (long)future.get().offset());
    }

    @Test(expected=ExecutionException.class)
    public void testError() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(this.baseOffset, (RuntimeException)new CorruptRecordException(), 50L), this.relOffset);
        future.get();
    }

    @Test
    public void testBlocking() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(this.baseOffset, null, 50L), this.relOffset);
        Assert.assertEquals((long)(this.baseOffset + this.relOffset), (long)future.get().offset());
    }

    public ProduceRequestResult asyncRequest(final long baseOffset, final RuntimeException error, final long timeout) {
        final ProduceRequestResult request = new ProduceRequestResult();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(timeout);
                    request.done(RecordSendTest.this.topicPartition, baseOffset, error);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        return request;
    }
}

