/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProtocolSerializationTest {
    private Schema schema;
    private Struct struct;

    @Before
    public void setup() {
        this.schema = new Schema(new Field[]{new Field("int8", Type.INT8), new Field("int16", Type.INT16), new Field("int32", Type.INT32), new Field("int64", Type.INT64), new Field("string", Type.STRING), new Field("bytes", Type.BYTES), new Field("nullable_bytes", Type.NULLABLE_BYTES), new Field("array", (Type)new ArrayOf(Type.INT32)), new Field("struct", (Type)new Schema(new Field[]{new Field("field", (Type)new ArrayOf(Type.INT32))}))});
        this.struct = new Struct(this.schema).set("int8", (Object)1).set("int16", (Object)1).set("int32", (Object)1).set("int64", (Object)1L).set("string", (Object)"1").set("bytes", (Object)ByteBuffer.wrap("1".getBytes())).set("nullable_bytes", null).set("array", (Object)new Object[]{1});
        this.struct.set("struct", (Object)this.struct.instance("struct").set("field", (Object)new Object[]{1, 2, 3}));
    }

    @Test
    public void testSimple() {
        this.check(Type.INT8, (byte)-111);
        this.check(Type.INT16, (short)-11111);
        this.check(Type.INT32, -11111111);
        this.check(Type.INT64, -11111111111L);
        this.check(Type.STRING, "");
        this.check(Type.STRING, "hello");
        this.check(Type.STRING, "A\u00ea\u00f1\u00fcC");
        this.check(Type.BYTES, ByteBuffer.allocate(0));
        this.check(Type.BYTES, ByteBuffer.wrap("abcd".getBytes()));
        this.check(Type.NULLABLE_BYTES, null);
        this.check(Type.NULLABLE_BYTES, ByteBuffer.allocate(0));
        this.check(Type.NULLABLE_BYTES, ByteBuffer.wrap("abcd".getBytes()));
        this.check((Type)new ArrayOf(Type.INT32), new Object[]{1, 2, 3, 4});
        this.check((Type)new ArrayOf(Type.STRING), new Object[0]);
        this.check((Type)new ArrayOf(Type.STRING), new Object[]{"hello", "there", "beautiful"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNulls() {
        for (Field f : this.schema.fields()) {
            Object o = this.struct.get(f);
            try {
                this.struct.set(f, null);
                this.struct.validate();
                if (f.type.isNullable()) continue;
                Assert.fail((String)"Should not allow serialization of null value.");
            }
            catch (SchemaException e) {
                Assert.assertFalse((boolean)f.type.isNullable());
            }
            finally {
                this.struct.set(f, o);
            }
        }
    }

    @Test
    public void testDefault() {
        Schema schema = new Schema(new Field[]{new Field("field", Type.INT32, "doc", (Object)42)});
        Struct struct = new Struct(schema);
        Assert.assertEquals((String)"Should get the default value", (Object)42, (Object)struct.get("field"));
        struct.validate();
    }

    @Test
    public void testNullableDefault() {
        ByteBuffer empty = ByteBuffer.allocate(0);
        Schema schema = new Schema(new Field[]{new Field("field", Type.NULLABLE_BYTES, "doc", (Object)empty)});
        Struct struct = new Struct(schema);
        Assert.assertEquals((String)"Should get the default value", (Object)empty, (Object)struct.get("field"));
        struct.validate();
    }

    @Test
    public void testArray() {
        ArrayOf type = new ArrayOf(Type.INT8);
        int size = 10;
        ByteBuffer invalidBuffer = ByteBuffer.allocate(4 + size);
        invalidBuffer.putInt(Integer.MAX_VALUE);
        for (int i = 0; i < size; ++i) {
            invalidBuffer.put((byte)i);
        }
        invalidBuffer.rewind();
        try {
            type.read(invalidBuffer);
            Assert.fail((String)"Array size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    private Object roundtrip(Type type, Object obj) {
        ByteBuffer buffer = ByteBuffer.allocate(type.sizeOf(obj));
        type.write(buffer, obj);
        Assert.assertFalse((String)"The buffer should now be full.", (boolean)buffer.hasRemaining());
        buffer.rewind();
        Object read = type.read(buffer);
        Assert.assertFalse((String)"All bytes should have been read.", (boolean)buffer.hasRemaining());
        return read;
    }

    private void check(Type type, Object obj) {
        List<Object> result = this.roundtrip(type, obj);
        if (obj instanceof Object[]) {
            obj = Arrays.asList((Object[])obj);
            result = Arrays.asList((Object[])result);
        }
        Assert.assertEquals((String)"The object read back should be the same as what was written.", (Object)obj, (Object)result);
    }
}

