/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    @Test
    public void testStringSerializer() {
        String str = "my string";
        String mytopic = "testTopic";
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("UTF8");
        encodings.add("UTF-16");
        for (String encoding : encodings) {
            SerDeser<String> serDeser = this.getStringSerDeser(encoding);
            Serializer serializer = serDeser.serializer;
            Deserializer deserializer = serDeser.deserializer;
            Assert.assertEquals((String)("Should get the original string after serialization and deserialization with encoding " + encoding), (Object)str, (Object)deserializer.deserialize(mytopic, serializer.serialize(mytopic, (Object)str)));
            Assert.assertEquals((String)("Should support null in serialization and deserialization with encoding " + encoding), null, (Object)deserializer.deserialize(mytopic, serializer.serialize(mytopic, null)));
        }
    }

    @Test
    public void testIntegerSerializer() {
        Integer[] integers = new Integer[]{423412424, -41243432};
        String mytopic = "testTopic";
        IntegerSerializer serializer = new IntegerSerializer();
        IntegerDeserializer deserializer = new IntegerDeserializer();
        for (Integer integer : integers) {
            Assert.assertEquals((String)"Should get the original integer after serialization and deserialization", (Object)integer, (Object)deserializer.deserialize(mytopic, serializer.serialize(mytopic, (Object)integer)));
        }
        Assert.assertEquals((String)"Should support null in serialization and deserialization", null, (Object)deserializer.deserialize(mytopic, serializer.serialize(mytopic, null)));
    }

    private SerDeser<String> getStringSerDeser(String encoder) {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", encoder);
        StringSerializer serializer = new StringSerializer();
        serializer.configure(serializerConfigs, true);
        HashMap<String, String> deserializerConfigs = new HashMap<String, String>();
        deserializerConfigs.put("key.deserializer.encoding", encoder);
        StringDeserializer deserializer = new StringDeserializer();
        deserializer.configure(deserializerConfigs, true);
        return new SerDeser<String>((Serializer<String>)serializer, (Deserializer<String>)deserializer);
    }

    private static class SerDeser<T> {
        final Serializer<T> serializer;
        final Deserializer<T> deserializer;

        public SerDeser(Serializer<T> serializer, Deserializer<T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }
    }
}

