/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testGetHost() {
        Assert.assertEquals((Object)"127.0.0.1", (Object)Utils.getHost((String)"127.0.0.1:8000"));
        Assert.assertEquals((Object)"mydomain.com", (Object)Utils.getHost((String)"PLAINTEXT://mydomain.com:8080"));
        Assert.assertEquals((Object)"MyDomain.com", (Object)Utils.getHost((String)"PLAINTEXT://MyDomain.com:8080"));
        Assert.assertEquals((Object)"::1", (Object)Utils.getHost((String)"[::1]:1234"));
        Assert.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678"));
        Assert.assertEquals((Object)"2001:DB8:85A3:8D3:1319:8A2E:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678"));
    }

    @Test
    public void testGetPort() {
        Assert.assertEquals((long)8000L, (long)Utils.getPort((String)"127.0.0.1:8000").intValue());
        Assert.assertEquals((long)8080L, (long)Utils.getPort((String)"mydomain.com:8080").intValue());
        Assert.assertEquals((long)8080L, (long)Utils.getPort((String)"MyDomain.com:8080").intValue());
        Assert.assertEquals((long)1234L, (long)Utils.getPort((String)"[::1]:1234").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678").intValue());
    }

    @Test
    public void testFormatAddress() {
        Assert.assertEquals((Object)"127.0.0.1:8000", (Object)Utils.formatAddress((String)"127.0.0.1", (Integer)8000));
        Assert.assertEquals((Object)"mydomain.com:8080", (Object)Utils.formatAddress((String)"mydomain.com", (Integer)8080));
        Assert.assertEquals((Object)"[::1]:1234", (Object)Utils.formatAddress((String)"::1", (Integer)1234));
        Assert.assertEquals((Object)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678", (Object)Utils.formatAddress((String)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Integer)5678));
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"", (Object)Utils.join(Collections.emptyList(), (String)","));
        Assert.assertEquals((Object)"1", (Object)Utils.join(Arrays.asList("1"), (String)","));
        Assert.assertEquals((Object)"1,2,3", (Object)Utils.join(Arrays.asList(1, 2, 3), (String)","));
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)10L, (long)Utils.abs((int)-10));
        Assert.assertEquals((long)10L, (long)Utils.abs((int)10));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
    }

    private void subTest(ByteBuffer buffer) {
        Assert.assertEquals((long)65L, (long)Utils.readBytes((ByteBuffer)buffer, (int)0, (int)1)[0]);
        byte[] results = Utils.readBytes((ByteBuffer)buffer, (int)2, (int)3);
        Assert.assertEquals((long)121L, (long)results[0]);
        Assert.assertEquals((long)32L, (long)results[1]);
        Assert.assertEquals((long)83L, (long)results[2]);
        Assert.assertEquals((long)3L, (long)results.length);
        results = Utils.readBytes((ByteBuffer)buffer);
        Assert.assertEquals((long)65L, (long)results[0]);
        Assert.assertEquals((long)116L, (long)results[buffer.limit() - 1]);
        Assert.assertEquals((long)buffer.limit(), (long)results.length);
    }

    @Test
    public void testReadBytes() {
        byte[] myvar = "Any String you want".getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(myvar.length);
        buffer.put(myvar);
        buffer.rewind();
        this.subTest(buffer);
        buffer = ByteBuffer.wrap(myvar).asReadOnlyBuffer();
        this.subTest(buffer);
    }

    @Test
    public void testMin() {
        Assert.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[0]));
        Assert.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[]{2L, 3L}));
        Assert.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{1L, 3L}));
        Assert.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{3L, 1L}));
    }
}

