/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreateTopicsRequestData
implements ApiMessage {
    private CreatableTopicCollection topics;
    private int timeoutMs;
    private boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", (Type)Type.INT32, "How long to wait in milliseconds before timing out the request.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public CreateTopicsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateTopicsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public CreateTopicsRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public CreateTopicsRequestData() {
        this.topics = new CreatableTopicCollection(0);
        this.timeoutMs = 60000;
        this.validateOnly = false;
    }

    public short apiKey() {
        return 19;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 5;
    }

    public void read(Readable _readable, short _version) {
        int i;
        CreatableTopicCollection newCollection;
        int arrayLength;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _version >= 1 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                CreatableTopic topicsElement = (CreatableTopic)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                CreatableTopic topicsElement = (CreatableTopic)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        if (_version >= 1) {
            _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new CreatableTopicCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatableTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = _version >= 1 ? struct.getBoolean("validate_only") : false;
        if (_version >= 5 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 5) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopic element = (CreatableTopic)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        if (_version >= 1) {
            struct.set("validate_only", (Object)this.validateOnly);
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        if (_version >= 5) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public void fromJson(JsonNode _node, short _version) {
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("CreateTopicsRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        this.topics = new CreatableTopicCollection();
        for (JsonNode _element : _topicsNode) {
            this.topics.add(new CreatableTopic(_element, _version));
        }
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        this.timeoutMs = MessageUtil.jsonNodeToInt((JsonNode)_timeoutMsNode, (String)"CreateTopicsRequestData");
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
            }
            this.validateOnly = false;
        } else {
            if (!_validateOnlyNode.isBoolean()) {
                throw new RuntimeException("CreateTopicsRequestData expected Boolean type, but got " + _node.getNodeType());
            }
            this.validateOnly = _validateOnlyNode.asBoolean();
        }
    }

    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopic _element = (CreatableTopic)iterator.next();
            _topicsArray.add(_element.toJson(_version));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        _node.set("timeoutMs", (JsonNode)new IntNode(this.timeoutMs));
        if (_version >= 1) {
            _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)this.validateOnly));
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        return _node;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopic topicsElement = (CreatableTopic)iterator.next();
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        if (_version >= 1) {
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 5) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTopicsRequestData)) {
            return false;
        }
        CreateTopicsRequestData other = (CreateTopicsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    public CreateTopicsRequestData duplicate() {
        CreateTopicsRequestData _duplicate = new CreateTopicsRequestData();
        CreatableTopicCollection newTopics = new CreatableTopicCollection(this.topics.size());
        Iterator iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            CreatableTopic _element = (CreatableTopic)iterator.next();
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "CreateTopicsRequestData(topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public CreatableTopicCollection topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateTopicsRequestData setTopics(CreatableTopicCollection v) {
        this.topics = v;
        return this;
    }

    public CreateTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreateTopicsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", (Type)Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", (Type)Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything.")})));
        SCHEMA_5 = new Schema(new Field[]{new Field("topics", (Type)new CompactArrayOf((Type)CreatableTopic.SCHEMA_5), "The topics to create."), new Field("timeout_ms", (Type)Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", (Type)Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class CreatableTopicCollection
    extends ImplicitLinkedHashMultiCollection<CreatableTopic> {
        public CreatableTopicCollection() {
        }

        public CreatableTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicCollection(Iterator<CreatableTopic> iterator) {
            super(iterator);
        }

        public CreatableTopic find(String name) {
            CreatableTopic _key = new CreatableTopic();
            _key.setName(name);
            return (CreatableTopic)this.find(_key);
        }

        public List<CreatableTopic> findAll(String name) {
            CreatableTopic _key = new CreatableTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatableTopicCollection duplicate() {
            CreatableTopicCollection _duplicate = new CreatableTopicCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CreatableTopic _element = (CreatableTopic)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreateableTopicConfigCollection
    extends ImplicitLinkedHashMultiCollection<CreateableTopicConfig> {
        public CreateableTopicConfigCollection() {
        }

        public CreateableTopicConfigCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreateableTopicConfigCollection(Iterator<CreateableTopicConfig> iterator) {
            super(iterator);
        }

        public CreateableTopicConfig find(String name) {
            CreateableTopicConfig _key = new CreateableTopicConfig();
            _key.setName(name);
            return (CreateableTopicConfig)this.find(_key);
        }

        public List<CreateableTopicConfig> findAll(String name) {
            CreateableTopicConfig _key = new CreateableTopicConfig();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreateableTopicConfigCollection duplicate() {
            CreateableTopicConfigCollection _duplicate = new CreateableTopicConfigCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CreateableTopicConfig _element = (CreateableTopicConfig)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreateableTopicConfig
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private String value;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreateableTopicConfig(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreateableTopicConfig(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreateableTopicConfig(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreateableTopicConfig() {
            this.name = "";
            this.value = "";
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreateableTopicConfig");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.value);
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreateableTopicConfig");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.value = struct.getString("value");
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreateableTopicConfig");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("value", (Object)this.value);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreateableTopicConfig: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreateableTopicConfig expected a string type, but got " + _node.getNodeType());
            }
            this.name = _nameNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("CreateableTopicConfig: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (_valueNode.isNull()) {
                this.value = null;
            } else {
                if (!_valueNode.isTextual()) {
                    throw new RuntimeException("CreateableTopicConfig expected a string type, but got " + _node.getNodeType());
                }
                this.value = _valueNode.asText();
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(this.name));
            if (this.value == null) {
                _node.set("value", (JsonNode)NullNode.instance);
            } else {
                _node.set("value", (JsonNode)new TextNode(this.value));
            }
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreateableTopicConfig");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            if (this.value == null) {
                _size = _version >= 5 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.value, _stringBytes);
                _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreateableTopicConfig)) {
                return false;
            }
            CreateableTopicConfig other = (CreateableTopicConfig)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreateableTopicConfig)) {
                return false;
            }
            CreateableTopicConfig other = (CreateableTopicConfig)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public CreateableTopicConfig duplicate() {
            CreateableTopicConfig _duplicate = new CreateableTopicConfig();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            return _duplicate;
        }

        public String toString() {
            return "CreateableTopicConfig(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreateableTopicConfig setName(String v) {
            this.name = v;
            return this;
        }

        public CreateableTopicConfig setValue(String v) {
            this.value = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The configuration name."), new Field("value", (Type)Type.NULLABLE_STRING, "The configuration value.")}))));
            SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The configuration name."), new Field("value", (Type)Type.COMPACT_NULLABLE_STRING, "The configuration value."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class CreatableReplicaAssignmentCollection
    extends ImplicitLinkedHashMultiCollection<CreatableReplicaAssignment> {
        public CreatableReplicaAssignmentCollection() {
        }

        public CreatableReplicaAssignmentCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableReplicaAssignmentCollection(Iterator<CreatableReplicaAssignment> iterator) {
            super(iterator);
        }

        public CreatableReplicaAssignment find(int partitionIndex) {
            CreatableReplicaAssignment _key = new CreatableReplicaAssignment();
            _key.setPartitionIndex(partitionIndex);
            return (CreatableReplicaAssignment)this.find(_key);
        }

        public List<CreatableReplicaAssignment> findAll(int partitionIndex) {
            CreatableReplicaAssignment _key = new CreatableReplicaAssignment();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public CreatableReplicaAssignmentCollection duplicate() {
            CreatableReplicaAssignmentCollection _duplicate = new CreatableReplicaAssignmentCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CreatableReplicaAssignment _element = (CreatableReplicaAssignment)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatableReplicaAssignment
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private int partitionIndex;
        private List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreatableReplicaAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableReplicaAssignment(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableReplicaAssignment(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableReplicaAssignment() {
            this.partitionIndex = 0;
            this.brokerIds = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableReplicaAssignment");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableReplicaAssignment");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionIndex = struct.getInt("partition_index");
            Object[] _nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableReplicaAssignment");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            Integer[] _nestedObjects = new Integer[this.brokerIds.size()];
            int i = 0;
            for (Integer element : this.brokerIds) {
                _nestedObjects[i++] = element;
            }
            struct.set("broker_ids", (Object)_nestedObjects);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            this.partitionIndex = MessageUtil.jsonNodeToInt((JsonNode)_partitionIndexNode, (String)"CreatableReplicaAssignment");
            JsonNode _brokerIdsNode = _node.get("brokerIds");
            if (_brokerIdsNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'brokerIds', which is mandatory in version " + _version);
            }
            if (!_brokerIdsNode.isArray()) {
                throw new RuntimeException("CreatableReplicaAssignment expected a JSON array, but got " + _node.getNodeType());
            }
            this.brokerIds = new ArrayList<Integer>();
            for (JsonNode _element : _brokerIdsNode) {
                this.brokerIds.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"CreatableReplicaAssignment element"));
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(this.partitionIndex));
            ArrayNode _brokerIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : this.brokerIds) {
                _brokerIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("brokerIds", (JsonNode)_brokerIdsArray);
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableReplicaAssignment");
            }
            _size += 4;
            int _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.brokerIds.size() + 1))) : (_arraySize += 4);
            _size += (_arraySize += this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableReplicaAssignment)) {
                return false;
            }
            CreatableReplicaAssignment other = (CreatableReplicaAssignment)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableReplicaAssignment)) {
                return false;
            }
            CreatableReplicaAssignment other = (CreatableReplicaAssignment)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return !(this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public CreatableReplicaAssignment duplicate() {
            CreatableReplicaAssignment _duplicate = new CreatableReplicaAssignment();
            _duplicate.partitionIndex = this.partitionIndex;
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            return _duplicate;
        }

        public String toString() {
            return "CreatableReplicaAssignment(partitionIndex=" + this.partitionIndex + ", brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableReplicaAssignment setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public CreatableReplicaAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("broker_ids", (Type)new ArrayOf((Type)Type.INT32), "The brokers to place the partition on.")}))));
            SCHEMA_5 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("broker_ids", (Type)new CompactArrayOf((Type)Type.INT32), "The brokers to place the partition on."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class CreatableTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private int numPartitions;
        private short replicationFactor;
        private CreatableReplicaAssignmentCollection assignments;
        private CreateableTopicConfigCollection configs;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreatableTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopic(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopic() {
            this.name = "";
            this.numPartitions = 0;
            this.replicationFactor = 0;
            this.assignments = new CreatableReplicaAssignmentCollection(0);
            this.configs = new CreateableTopicConfigCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 5;
        }

        public void read(Readable _readable, short _version) {
            int i;
            ImplicitLinkedHashMultiCollection newCollection;
            int arrayLength;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopic");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.numPartitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((ImplicitLinkedHashCollection.Element)new CreatableReplicaAssignment(_readable, _version));
                }
                this.assignments = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((ImplicitLinkedHashCollection.Element)new CreatableReplicaAssignment(_readable, _version));
                }
                this.assignments = newCollection;
            }
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((ImplicitLinkedHashCollection.Element)new CreateableTopicConfig(_readable, _version));
                }
                this.configs = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((ImplicitLinkedHashCollection.Element)new CreateableTopicConfig(_readable, _version));
                }
                this.configs = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            CreateableTopicConfig configsElement;
            CreatableReplicaAssignment assignmentsElement;
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.numPartitions);
            _writable.writeShort(this.replicationFactor);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.assignments.size() + 1);
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.configs.size() + 1);
                _stringBytes = this.configs.iterator();
                while (_stringBytes.hasNext()) {
                    configsElement = (CreateableTopicConfig)_stringBytes.next();
                    configsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.configs.size());
                _stringBytes = this.configs.iterator();
                while (_stringBytes.hasNext()) {
                    configsElement = (CreateableTopicConfig)_stringBytes.next();
                    configsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.numPartitions = struct.getInt("num_partitions");
            this.replicationFactor = struct.getShort("replication_factor");
            Object[] _nestedObjects = struct.getArray("assignments");
            this.assignments = new CreatableReplicaAssignmentCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.assignments.add(new CreatableReplicaAssignment((Struct)nestedObject, _version));
            }
            _nestedObjects = struct.getArray("configs");
            this.configs = new CreateableTopicConfigCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.configs.add(new CreateableTopicConfig((Struct)nestedObject, _version));
            }
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            Object element;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("num_partitions", (Object)this.numPartitions);
            struct.set("replication_factor", (Object)this.replicationFactor);
            Struct[] _nestedObjects = new Struct[this.assignments.size()];
            int i = 0;
            Iterator iterator = this.assignments.iterator();
            while (iterator.hasNext()) {
                element = (CreatableReplicaAssignment)iterator.next();
                _nestedObjects[i++] = ((CreatableReplicaAssignment)element).toStruct(_version);
            }
            struct.set("assignments", (Object)_nestedObjects);
            _nestedObjects = new Struct[this.configs.size()];
            i = 0;
            iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                element = (CreateableTopicConfig)iterator.next();
                _nestedObjects[i++] = ((CreateableTopicConfig)element).toStruct(_version);
            }
            struct.set("configs", (Object)_nestedObjects);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopic expected a string type, but got " + _node.getNodeType());
            }
            this.name = _nameNode.asText();
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            }
            this.numPartitions = MessageUtil.jsonNodeToInt((JsonNode)_numPartitionsNode, (String)"CreatableTopic");
            JsonNode _replicationFactorNode = _node.get("replicationFactor");
            if (_replicationFactorNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'replicationFactor', which is mandatory in version " + _version);
            }
            this.replicationFactor = MessageUtil.jsonNodeToShort((JsonNode)_replicationFactorNode, (String)"CreatableTopic");
            JsonNode _assignmentsNode = _node.get("assignments");
            if (_assignmentsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'assignments', which is mandatory in version " + _version);
            }
            if (!_assignmentsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + _node.getNodeType());
            }
            this.assignments = new CreatableReplicaAssignmentCollection();
            for (JsonNode _element : _assignmentsNode) {
                this.assignments.add(new CreatableReplicaAssignment(_element, _version));
            }
            JsonNode _configsNode = _node.get("configs");
            if (_configsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'configs', which is mandatory in version " + _version);
            }
            if (!_configsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + _node.getNodeType());
            }
            this.configs = new CreateableTopicConfigCollection();
            for (JsonNode _element : _configsNode) {
                this.configs.add(new CreateableTopicConfig(_element, _version));
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(this.name));
            _node.set("numPartitions", (JsonNode)new IntNode(this.numPartitions));
            _node.set("replicationFactor", (JsonNode)new ShortNode(this.replicationFactor));
            ArrayNode _assignmentsArray = new ArrayNode(JsonNodeFactory.instance);
            Iterator iterator = this.assignments.iterator();
            while (iterator.hasNext()) {
                CreatableReplicaAssignment _element = (CreatableReplicaAssignment)iterator.next();
                _assignmentsArray.add(_element.toJson(_version));
            }
            _node.set("assignments", (JsonNode)_assignmentsArray);
            ArrayNode _configsArray = new ArrayNode(JsonNodeFactory.instance);
            Iterator iterator2 = this.configs.iterator();
            while (iterator2.hasNext()) {
                CreateableTopicConfig _element = (CreateableTopicConfig)iterator2.next();
                _configsArray.add(_element.toJson(_version));
            }
            _node.set("configs", (JsonNode)_configsArray);
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _size += 4;
            _size += 2;
            int _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.assignments.size() + 1))) : (_arraySize += 4);
            Iterator iterator = this.assignments.iterator();
            while (iterator.hasNext()) {
                CreatableReplicaAssignment assignmentsElement = (CreatableReplicaAssignment)iterator.next();
                _arraySize += assignmentsElement.size(_cache, _version);
            }
            _size += _arraySize;
            _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.configs.size() + 1))) : (_arraySize += 4);
            iterator = this.configs.iterator();
            while (iterator.hasNext()) {
                CreateableTopicConfig configsElement = (CreateableTopicConfig)iterator.next();
                _arraySize += configsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableTopic)) {
                return false;
            }
            CreatableTopic other = (CreatableTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopic)) {
                return false;
            }
            CreatableTopic other = (CreatableTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.assignments == null ? other.assignments != null : !this.assignments.equals((Object)other.assignments)) {
                return false;
            }
            return !(this.configs == null ? other.configs != null : !this.configs.equals((Object)other.configs));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public CreatableTopic duplicate() {
            CreatableTopic _duplicate = new CreatableTopic();
            _duplicate.name = this.name;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.replicationFactor = this.replicationFactor;
            CreatableReplicaAssignmentCollection newAssignments = new CreatableReplicaAssignmentCollection(this.assignments.size());
            Iterator iterator = this.assignments.iterator();
            while (iterator.hasNext()) {
                CreatableReplicaAssignment _element = (CreatableReplicaAssignment)iterator.next();
                newAssignments.add(_element.duplicate());
            }
            _duplicate.assignments = newAssignments;
            CreateableTopicConfigCollection newConfigs = new CreateableTopicConfigCollection(this.configs.size());
            Iterator iterator2 = this.configs.iterator();
            while (iterator2.hasNext()) {
                CreateableTopicConfig _element = (CreateableTopicConfig)iterator2.next();
                newConfigs.add(_element.duplicate());
            }
            _duplicate.configs = newConfigs;
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", assignments=" + MessageUtil.deepToString((Iterator)this.assignments.iterator()) + ", configs=" + MessageUtil.deepToString((Iterator)this.configs.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public CreatableReplicaAssignmentCollection assignments() {
            return this.assignments;
        }

        public CreateableTopicConfigCollection configs() {
            return this.configs;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopic setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public CreatableTopic setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public CreatableTopic setAssignments(CreatableReplicaAssignmentCollection v) {
            this.assignments = v;
            return this;
        }

        public CreatableTopic setConfigs(CreateableTopicConfigCollection v) {
            this.configs = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("num_partitions", (Type)Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", (Type)Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", (Type)new ArrayOf((Type)CreatableReplicaAssignment.SCHEMA_0), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", (Type)new ArrayOf((Type)CreateableTopicConfig.SCHEMA_0), "The custom topic configurations to set.")}))));
            SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("num_partitions", (Type)Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", (Type)Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", (Type)new CompactArrayOf((Type)CreatableReplicaAssignment.SCHEMA_5), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", (Type)new CompactArrayOf((Type)CreateableTopicConfig.SCHEMA_5), "The custom topic configurations to set."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

