/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RenewDelegationTokenResponseData
implements ApiMessage {
    private short errorCode;
    private long expiryTimestampMs;
    private int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public RenewDelegationTokenResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RenewDelegationTokenResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public RenewDelegationTokenResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public RenewDelegationTokenResponseData() {
        this.errorCode = 0;
        this.expiryTimestampMs = 0L;
        this.throttleTimeMs = 0;
    }

    public short apiKey() {
        return 39;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        this.expiryTimestampMs = _readable.readLong();
        this.throttleTimeMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        _writable.writeLong(this.expiryTimestampMs);
        _writable.writeInt(this.throttleTimeMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        this.expiryTimestampMs = struct.getLong("expiry_timestamp_ms");
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("expiry_timestamp_ms", (Object)this.expiryTimestampMs);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public void fromJson(JsonNode _node, short _version) {
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("RenewDelegationTokenResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        this.errorCode = MessageUtil.jsonNodeToShort((JsonNode)_errorCodeNode, (String)"RenewDelegationTokenResponseData");
        JsonNode _expiryTimestampMsNode = _node.get("expiryTimestampMs");
        if (_expiryTimestampMsNode == null) {
            throw new RuntimeException("RenewDelegationTokenResponseData: unable to locate field 'expiryTimestampMs', which is mandatory in version " + _version);
        }
        this.expiryTimestampMs = MessageUtil.jsonNodeToLong((JsonNode)_expiryTimestampMsNode, (String)"RenewDelegationTokenResponseData");
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("RenewDelegationTokenResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        this.throttleTimeMs = MessageUtil.jsonNodeToInt((JsonNode)_throttleTimeMsNode, (String)"RenewDelegationTokenResponseData");
    }

    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("errorCode", (JsonNode)new ShortNode(this.errorCode));
        _node.set("expiryTimestampMs", (JsonNode)new LongNode(this.expiryTimestampMs));
        _node.set("throttleTimeMs", (JsonNode)new IntNode(this.throttleTimeMs));
        return _node;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        _size += 8;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RenewDelegationTokenResponseData)) {
            return false;
        }
        RenewDelegationTokenResponseData other = (RenewDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.expiryTimestampMs != other.expiryTimestampMs) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.expiryTimestampMs >> 32) ^ (int)this.expiryTimestampMs);
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public RenewDelegationTokenResponseData duplicate() {
        RenewDelegationTokenResponseData _duplicate = new RenewDelegationTokenResponseData();
        _duplicate.errorCode = this.errorCode;
        _duplicate.expiryTimestampMs = this.expiryTimestampMs;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "RenewDelegationTokenResponseData(errorCode=" + this.errorCode + ", expiryTimestampMs=" + this.expiryTimestampMs + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long expiryTimestampMs() {
        return this.expiryTimestampMs;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RenewDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public RenewDelegationTokenResponseData setExpiryTimestampMs(long v) {
        this.expiryTimestampMs = v;
        return this;
    }

    public RenewDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("expiry_timestamp_ms", (Type)Type.INT64, "The timestamp in milliseconds at which this token expires."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
        SCHEMA_2 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("expiry_timestamp_ms", (Type)Type.INT64, "The timestamp in milliseconds at which this token expires."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

