/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;

public abstract class AbstractRequest
implements AbstractRequestResponse {
    private final short version;
    public final ApiKeys api;

    public AbstractRequest(ApiKeys api, short version) {
        if (!api.isVersionSupported(version)) {
            throw new UnsupportedVersionException("The " + (Object)((Object)api) + " protocol does not support version " + version);
        }
        this.version = version;
        this.api = api;
    }

    public short version() {
        return this.version;
    }

    public Send toSend(String destination, RequestHeader header) {
        return new NetworkSend(destination, this.serialize(header));
    }

    public ByteBuffer serialize(RequestHeader header) {
        return RequestUtils.serialize(header.toStruct(), this.toStruct());
    }

    protected abstract Struct toStruct();

    public String toString(boolean verbose) {
        return this.toStruct().toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public Map<Errors, Integer> errorCounts(Throwable e) {
        AbstractResponse response = this.getErrorResponse(0, e);
        if (response == null) {
            throw new IllegalStateException("Error counts could not be obtained for request " + this);
        }
        return response.errorCounts();
    }

    public static AbstractRequest parseRequest(ApiKeys apiKey, short apiVersion, Struct struct) {
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceRequest(struct, apiVersion);
            }
            case FETCH: {
                return new FetchRequest(new FetchRequestData(struct, apiVersion), apiVersion);
            }
            case LIST_OFFSETS: {
                return new ListOffsetRequest(struct, apiVersion);
            }
            case METADATA: {
                return new MetadataRequest(struct, apiVersion);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitRequest(struct, apiVersion);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchRequest(struct, apiVersion);
            }
            case FIND_COORDINATOR: {
                return new FindCoordinatorRequest(struct, apiVersion);
            }
            case JOIN_GROUP: {
                return new JoinGroupRequest(struct, apiVersion);
            }
            case HEARTBEAT: {
                return new HeartbeatRequest(struct, apiVersion);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupRequest(struct, apiVersion);
            }
            case SYNC_GROUP: {
                return new SyncGroupRequest(struct, apiVersion);
            }
            case STOP_REPLICA: {
                return new StopReplicaRequest(struct, apiVersion);
            }
            case CONTROLLED_SHUTDOWN: {
                return new ControlledShutdownRequest(struct, apiVersion);
            }
            case UPDATE_METADATA: {
                return new UpdateMetadataRequest(struct, apiVersion);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrRequest(struct, apiVersion);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsRequest(struct, apiVersion);
            }
            case LIST_GROUPS: {
                return new ListGroupsRequest(struct, apiVersion);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeRequest(struct, apiVersion);
            }
            case API_VERSIONS: {
                return new ApiVersionsRequest(struct, apiVersion);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsRequest(struct, apiVersion);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsRequest(struct, apiVersion);
            }
            case DELETE_RECORDS: {
                return new DeleteRecordsRequest(struct, apiVersion);
            }
            case INIT_PRODUCER_ID: {
                return new InitProducerIdRequest(struct, apiVersion);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return new OffsetsForLeaderEpochRequest(struct, apiVersion);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return new AddPartitionsToTxnRequest(struct, apiVersion);
            }
            case ADD_OFFSETS_TO_TXN: {
                return new AddOffsetsToTxnRequest(struct, apiVersion);
            }
            case END_TXN: {
                return new EndTxnRequest(struct, apiVersion);
            }
            case WRITE_TXN_MARKERS: {
                return new WriteTxnMarkersRequest(struct, apiVersion);
            }
            case TXN_OFFSET_COMMIT: {
                return new TxnOffsetCommitRequest(struct, apiVersion);
            }
            case DESCRIBE_ACLS: {
                return new DescribeAclsRequest(struct, apiVersion);
            }
            case CREATE_ACLS: {
                return new CreateAclsRequest(struct, apiVersion);
            }
            case DELETE_ACLS: {
                return new DeleteAclsRequest(struct, apiVersion);
            }
            case DESCRIBE_CONFIGS: {
                return new DescribeConfigsRequest(struct, apiVersion);
            }
            case ALTER_CONFIGS: {
                return new AlterConfigsRequest(struct, apiVersion);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return new AlterReplicaLogDirsRequest(struct, apiVersion);
            }
            case DESCRIBE_LOG_DIRS: {
                return new DescribeLogDirsRequest(struct, apiVersion);
            }
            case SASL_AUTHENTICATE: {
                return new SaslAuthenticateRequest(struct, apiVersion);
            }
            case CREATE_PARTITIONS: {
                return new CreatePartitionsRequest(struct, apiVersion);
            }
            case CREATE_DELEGATION_TOKEN: {
                return new CreateDelegationTokenRequest(struct, apiVersion);
            }
            case RENEW_DELEGATION_TOKEN: {
                return new RenewDelegationTokenRequest(struct, apiVersion);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return new ExpireDelegationTokenRequest(struct, apiVersion);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return new DescribeDelegationTokenRequest(struct, apiVersion);
            }
            case DELETE_GROUPS: {
                return new DeleteGroupsRequest(struct, apiVersion);
            }
            case ELECT_LEADERS: {
                return new ElectLeadersRequest(struct, apiVersion);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return new IncrementalAlterConfigsRequest(struct, apiVersion);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return new AlterPartitionReassignmentsRequest(struct, apiVersion);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return new ListPartitionReassignmentsRequest(struct, apiVersion);
            }
            case OFFSET_DELETE: {
                return new OffsetDeleteRequest(struct, apiVersion);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return new DescribeClientQuotasRequest(struct, apiVersion);
            }
            case ALTER_CLIENT_QUOTAS: {
                return new AlterClientQuotasRequest(struct, apiVersion);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return new DescribeUserScramCredentialsRequest(struct, apiVersion);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return new AlterUserScramCredentialsRequest(struct, apiVersion);
            }
            case VOTE: {
                return new VoteRequest(struct, apiVersion);
            }
            case BEGIN_QUORUM_EPOCH: {
                return new BeginQuorumEpochRequest(struct, apiVersion);
            }
            case END_QUORUM_EPOCH: {
                return new EndQuorumEpochRequest(struct, apiVersion);
            }
            case ALTER_ISR: {
                return new AlterIsrRequest(new AlterIsrRequestData(struct, apiVersion), apiVersion);
            }
            case UPDATE_FEATURES: {
                return new UpdateFeaturesRequest(struct, apiVersion);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final short oldestAllowedVersion;
        private final short latestAllowedVersion;

        public Builder(ApiKeys apiKey) {
            this(apiKey, apiKey.oldestVersion(), apiKey.latestVersion());
        }

        public Builder(ApiKeys apiKey, short allowedVersion) {
            this(apiKey, allowedVersion, allowedVersion);
        }

        public Builder(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
            this.apiKey = apiKey;
            this.oldestAllowedVersion = oldestAllowedVersion;
            this.latestAllowedVersion = latestAllowedVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short oldestAllowedVersion() {
            return this.oldestAllowedVersion;
        }

        public short latestAllowedVersion() {
            return this.latestAllowedVersion;
        }

        public T build() {
            return this.build(this.latestAllowedVersion());
        }

        public abstract T build(short var1);
    }
}

