/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.common.message.OffsetForLeaderEpochRequestData.*;

public class OffsetForLeaderEpochRequestDataJsonConverter {
    public static OffsetForLeaderEpochRequestData read(JsonNode _node, short _version) {
        OffsetForLeaderEpochRequestData _object = new OffsetForLeaderEpochRequestData();
        JsonNode _replicaIdNode = _node.get("replicaId");
        if (_replicaIdNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("OffsetForLeaderEpochRequestData: unable to locate field 'replicaId', which is mandatory in version " + _version);
            } else {
                _object.replicaId = -2;
            }
        } else {
            _object.replicaId = MessageUtil.jsonNodeToInt(_replicaIdNode, "OffsetForLeaderEpochRequestData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("OffsetForLeaderEpochRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        } else {
            if (!_topicsNode.isArray()) {
                throw new RuntimeException("OffsetForLeaderEpochRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<OffsetForLeaderTopic> _collection = new ArrayList<OffsetForLeaderTopic>();
            _object.topics = _collection;
            for (JsonNode _element : _topicsNode) {
                _collection.add(OffsetForLeaderTopicJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(OffsetForLeaderEpochRequestData _object, short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 3) {
            _node.set("replicaId", new IntNode(_object.replicaId));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (OffsetForLeaderTopic _element : _object.topics) {
            _topicsArray.add(OffsetForLeaderTopicJsonConverter.write(_element, _version));
        }
        _node.set("topics", _topicsArray);
        return _node;
    }
    
    public static class OffsetForLeaderPartitionJsonConverter {
        public static OffsetForLeaderPartition read(JsonNode _node, short _version) {
            OffsetForLeaderPartition _object = new OffsetForLeaderPartition();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("OffsetForLeaderPartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            } else {
                _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "OffsetForLeaderPartition");
            }
            JsonNode _currentLeaderEpochNode = _node.get("currentLeaderEpoch");
            if (_currentLeaderEpochNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("OffsetForLeaderPartition: unable to locate field 'currentLeaderEpoch', which is mandatory in version " + _version);
                } else {
                    _object.currentLeaderEpoch = -1;
                }
            } else {
                _object.currentLeaderEpoch = MessageUtil.jsonNodeToInt(_currentLeaderEpochNode, "OffsetForLeaderPartition");
            }
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("OffsetForLeaderPartition: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            } else {
                _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "OffsetForLeaderPartition");
            }
            return _object;
        }
        public static JsonNode write(OffsetForLeaderPartition _object, short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", new IntNode(_object.partitionIndex));
            if (_version >= 2) {
                _node.set("currentLeaderEpoch", new IntNode(_object.currentLeaderEpoch));
            }
            _node.set("leaderEpoch", new IntNode(_object.leaderEpoch));
            return _node;
        }
    }
    
    public static class OffsetForLeaderTopicJsonConverter {
        public static OffsetForLeaderTopic read(JsonNode _node, short _version) {
            OffsetForLeaderTopic _object = new OffsetForLeaderTopic();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("OffsetForLeaderTopic: unable to locate field 'name', which is mandatory in version " + _version);
            } else {
                if (!_nameNode.isTextual()) {
                    throw new RuntimeException("OffsetForLeaderTopic expected a string type, but got " + _node.getNodeType());
                }
                _object.name = _nameNode.asText();
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("OffsetForLeaderTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            } else {
                if (!_partitionsNode.isArray()) {
                    throw new RuntimeException("OffsetForLeaderTopic expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<OffsetForLeaderPartition> _collection = new ArrayList<OffsetForLeaderPartition>();
                _object.partitions = _collection;
                for (JsonNode _element : _partitionsNode) {
                    _collection.add(OffsetForLeaderPartitionJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }
        public static JsonNode write(OffsetForLeaderTopic _object, short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(_object.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (OffsetForLeaderPartition _element : _object.partitions) {
                _partitionsArray.add(OffsetForLeaderPartitionJsonConverter.write(_element, _version));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }
    }
}
