/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.ArrayDeque;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.protocol.RecordsWritable;
import org.junit.Assert;
import org.junit.Test;

public class RecordsWritableTest {
    @Test
    public void testBufferSlice() {
        ArrayDeque sends = new ArrayDeque();
        RecordsWritable writer = new RecordsWritable("dest", 10000, sends::add);
        for (int i = 0; i < 4; ++i) {
            writer.writeInt(i);
        }
        writer.flush();
        Assert.assertEquals((long)sends.size(), (long)1L);
        ByteBufferSend send = (ByteBufferSend)sends.remove();
        Assert.assertEquals((long)send.size(), (long)16L);
        Assert.assertEquals((long)send.remaining(), (long)16L);
        writer.flush();
        Assert.assertEquals((long)sends.size(), (long)0L);
        for (int i = 0; i < 100; ++i) {
            writer.writeInt(i);
        }
        writer.flush();
        Assert.assertEquals((long)sends.size(), (long)1L);
        send = (ByteBufferSend)sends.remove();
        Assert.assertEquals((long)send.size(), (long)400L);
        Assert.assertEquals((long)send.remaining(), (long)400L);
        writer.writeByte((byte)5);
        writer.flush();
        Assert.assertEquals((long)sends.size(), (long)1L);
        send = (ByteBufferSend)sends.remove();
        Assert.assertEquals((long)send.size(), (long)1L);
        Assert.assertEquals((long)send.remaining(), (long)1L);
    }
}

