/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LeaveGroupResponseTest {
    private final String memberIdOne = "member_1";
    private final String instanceIdOne = "instance_1";
    private final String memberIdTwo = "member_2";
    private final String instanceIdTwo = "instance_2";
    private final int throttleTimeMs = 10;
    private List<LeaveGroupResponseData.MemberResponse> memberResponses;

    @Before
    public void setUp() {
        this.memberResponses = Arrays.asList(new LeaveGroupResponseData.MemberResponse().setMemberId("member_1").setGroupInstanceId("instance_1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setMemberId("member_2").setGroupInstanceId("instance_2").setErrorCode(Errors.FENCED_INSTANCE_ID.code()));
    }

    @Test
    public void testConstructorWithStruct() {
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            Assert.assertEquals(expectedErrorCounts, (Object)leaveGroupResponse.errorCounts());
            if (version >= 1) {
                Assert.assertEquals((long)10L, (long)leaveGroupResponse.throttleTimeMs());
            } else {
                Assert.assertEquals((long)0L, (long)leaveGroupResponse.throttleTimeMs());
            }
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)leaveGroupResponse.error());
        }
    }

    @Test
    public void testConstructorWithMemberResponses() {
        HashMap<Errors, Integer> expectedErrorCounts = new HashMap<Errors, Integer>();
        expectedErrorCounts.put(Errors.UNKNOWN_MEMBER_ID, 1);
        expectedErrorCounts.put(Errors.FENCED_INSTANCE_ID, 1);
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(this.memberResponses, Errors.NONE, 10, version);
            if (version >= 3) {
                Assert.assertEquals(expectedErrorCounts, (Object)leaveGroupResponse.errorCounts());
                Assert.assertEquals(this.memberResponses, (Object)leaveGroupResponse.memberResponses());
            } else {
                Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_MEMBER_ID, 1), (Object)leaveGroupResponse.errorCounts());
                Assert.assertEquals(Collections.emptyList(), (Object)leaveGroupResponse.memberResponses());
            }
            if (version >= 1) {
                Assert.assertEquals((long)10L, (long)leaveGroupResponse.throttleTimeMs());
            } else {
                Assert.assertEquals((long)0L, (long)leaveGroupResponse.throttleTimeMs());
            }
            Assert.assertEquals((Object)Errors.UNKNOWN_MEMBER_ID, (Object)leaveGroupResponse.error());
        }
    }

    @Test
    public void testShouldThrottle() {
        LeaveGroupResponse response = new LeaveGroupResponse(new LeaveGroupResponseData());
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            if (version >= 2) {
                Assert.assertTrue((boolean)response.shouldClientThrottle(version));
                continue;
            }
            Assert.assertFalse((boolean)response.shouldClientThrottle(version));
        }
    }

    @Test
    public void testEqualityWithStruct() {
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupResponse primaryResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            LeaveGroupResponse secondaryResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            Assert.assertEquals((Object)primaryResponse, (Object)primaryResponse);
            Assert.assertEquals((Object)primaryResponse, (Object)secondaryResponse);
            Assert.assertEquals((long)primaryResponse.hashCode(), (long)secondaryResponse.hashCode());
        }
    }

    @Test
    public void testEqualityWithMemberResponses() {
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            List<LeaveGroupResponseData.MemberResponse> localResponses = version > 2 ? this.memberResponses : this.memberResponses.subList(0, 1);
            LeaveGroupResponse primaryResponse = new LeaveGroupResponse(localResponses, Errors.NONE, 10, version);
            Collections.reverse(localResponses);
            LeaveGroupResponse reversedResponse = new LeaveGroupResponse(localResponses, Errors.NONE, 10, version);
            Assert.assertEquals((Object)primaryResponse, (Object)primaryResponse);
            Assert.assertEquals((Object)primaryResponse, (Object)reversedResponse);
            Assert.assertEquals((long)primaryResponse.hashCode(), (long)reversedResponse.hashCode());
        }
    }
}

