/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SensorTest {
    private static final MetricConfig INFO_CONFIG = new MetricConfig().recordLevel(Sensor.RecordingLevel.INFO);
    private static final MetricConfig DEBUG_CONFIG = new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG);
    private static final MetricConfig TRACE_CONFIG = new MetricConfig().recordLevel(Sensor.RecordingLevel.TRACE);

    @Test
    public void testRecordLevelEnum() {
        Sensor.RecordingLevel configLevel = Sensor.RecordingLevel.INFO;
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assertions.assertFalse((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        Assertions.assertFalse((boolean)Sensor.RecordingLevel.TRACE.shouldRecord((int)configLevel.id));
        configLevel = Sensor.RecordingLevel.DEBUG;
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        Assertions.assertFalse((boolean)Sensor.RecordingLevel.TRACE.shouldRecord((int)configLevel.id));
        configLevel = Sensor.RecordingLevel.TRACE;
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        Assertions.assertTrue((boolean)Sensor.RecordingLevel.TRACE.shouldRecord((int)configLevel.id));
        Assertions.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.DEBUG.toString()), (Object)Sensor.RecordingLevel.DEBUG);
        Assertions.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.INFO.toString()), (Object)Sensor.RecordingLevel.INFO);
        Assertions.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.TRACE.toString()), (Object)Sensor.RecordingLevel.TRACE);
    }

    @Test
    public void testShouldRecordForInfoLevelSensor() {
        Sensor infoSensor = new Sensor(null, "infoSensor", null, INFO_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assertions.assertTrue((boolean)infoSensor.shouldRecord());
        infoSensor = new Sensor(null, "infoSensor", null, DEBUG_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assertions.assertTrue((boolean)infoSensor.shouldRecord());
        infoSensor = new Sensor(null, "infoSensor", null, TRACE_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assertions.assertTrue((boolean)infoSensor.shouldRecord());
    }

    @Test
    public void testShouldRecordForDebugLevelSensor() {
        Sensor debugSensor = new Sensor(null, "debugSensor", null, INFO_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assertions.assertFalse((boolean)debugSensor.shouldRecord());
        debugSensor = new Sensor(null, "debugSensor", null, DEBUG_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assertions.assertTrue((boolean)debugSensor.shouldRecord());
        debugSensor = new Sensor(null, "debugSensor", null, TRACE_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assertions.assertTrue((boolean)debugSensor.shouldRecord());
    }

    @Test
    public void testShouldRecordForTraceLevelSensor() {
        Sensor traceSensor = new Sensor(null, "traceSensor", null, INFO_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.TRACE);
        Assertions.assertFalse((boolean)traceSensor.shouldRecord());
        traceSensor = new Sensor(null, "traceSensor", null, DEBUG_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.TRACE);
        Assertions.assertFalse((boolean)traceSensor.shouldRecord());
        traceSensor = new Sensor(null, "traceSensor", null, TRACE_CONFIG, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.TRACE);
        Assertions.assertTrue((boolean)traceSensor.shouldRecord());
    }

    @Test
    public void testExpiredSensor() {
        MetricConfig config = new MetricConfig();
        MockTime mockTime = new MockTime();
        try (Metrics metrics = new Metrics(config, Arrays.asList(new JmxReporter()), (Time)mockTime, true);){
            long inactiveSensorExpirationTimeSeconds = 60L;
            Sensor sensor = new Sensor(metrics, "sensor", null, config, (Time)mockTime, inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel.INFO);
            Assertions.assertTrue((boolean)sensor.add(metrics.metricName("test1", "grp1"), (MeasurableStat)new Avg()));
            Map emptyTags = Collections.emptyMap();
            MetricName rateMetricName = new MetricName("rate", "test", "", emptyTags);
            MetricName totalMetricName = new MetricName("total", "test", "", emptyTags);
            Meter meter = new Meter(rateMetricName, totalMetricName);
            Assertions.assertTrue((boolean)sensor.add((CompoundStat)meter));
            mockTime.sleep(TimeUnit.SECONDS.toMillis(inactiveSensorExpirationTimeSeconds + 1L));
            Assertions.assertFalse((boolean)sensor.add(metrics.metricName("test3", "grp1"), (MeasurableStat)new Avg()));
            Assertions.assertFalse((boolean)sensor.add((CompoundStat)meter));
        }
    }

    @Test
    public void testIdempotentAdd() {
        Metrics metrics = new Metrics();
        Sensor sensor = metrics.sensor("sensor");
        Assertions.assertTrue((boolean)sensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new Avg()));
        Assertions.assertTrue((boolean)sensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new Avg()));
        Sensor anotherSensor = metrics.sensor("another-sensor");
        try {
            anotherSensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new Avg());
            Assertions.fail((String)"should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)sensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new WindowedSum()));
        Assertions.assertEquals((int)1, (int)sensor.metrics().size());
        Assertions.assertEquals(Avg.class, ((KafkaMetric)sensor.metrics().get(0)).measurable().getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckQuotasInMultiThreads() throws InterruptedException, ExecutionException {
        Metrics metrics = new Metrics(new MetricConfig().quota(Quota.upperBound((double)Double.MAX_VALUE)).timeWindow(1L, TimeUnit.MILLISECONDS).samples(100));
        final Sensor sensor = metrics.sensor("sensor");
        Assertions.assertTrue((boolean)sensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new Rate()));
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService service = Executors.newFixedThreadPool(10);
        ArrayList<Future<Throwable>> workers = new ArrayList<Future<Throwable>>(10);
        boolean needShutdown = true;
        try {
            int i = 0;
            while (i != 10) {
                final int n = i++;
                workers.add(service.submit(new Callable<Throwable>(){

                    @Override
                    public Throwable call() {
                        try {
                            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                            for (int j = 0; j != 20; ++j) {
                                sensor.record((double)(j * n), System.currentTimeMillis() + (long)j, false);
                                sensor.checkQuotas();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            return e;
                        }
                    }
                }));
            }
            latch.countDown();
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(10L, TimeUnit.SECONDS));
            needShutdown = false;
            for (Future future : workers) {
                Assertions.assertTrue((boolean)future.isDone(), (String)"If this failure happen frequently, we can try to increase the wait time");
                Assertions.assertNull(future.get(), (String)"Sensor#checkQuotas SHOULD be thread-safe!");
            }
        }
        finally {
            if (needShutdown) {
                service.shutdownNow();
            }
        }
    }

    @Test
    public void shouldReturnPresenceOfMetrics() {
        Metrics metrics = new Metrics();
        Sensor sensor = metrics.sensor("sensor");
        Assertions.assertFalse((boolean)sensor.hasMetrics());
        sensor.add(new MetricName("name1", "group1", "description1", Collections.emptyMap()), (MeasurableStat)new WindowedSum());
        Assertions.assertTrue((boolean)sensor.hasMetrics());
        sensor.add(new MetricName("name2", "group2", "description2", Collections.emptyMap()), (MeasurableStat)new CumulativeCount());
        Assertions.assertTrue((boolean)sensor.hasMetrics());
    }

    @Test
    public void testStrictQuotaEnforcementWithRate() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor", new MetricConfig().quota(Quota.upperBound((double)2.0)).timeWindow(1L, TimeUnit.SECONDS).samples(11), new Sensor[0]);
        MetricName metricName = metrics.metricName("rate", "test-group");
        Assertions.assertTrue((boolean)sensor.add(metricName, (MeasurableStat)new Rate()));
        KafkaMetric rateMetric = metrics.metric(metricName);
        this.strictRecord(sensor, 30.0, time.milliseconds());
        Assertions.assertEquals((double)3.0, (double)rateMetric.measurableValue(time.milliseconds()), (double)0.1);
        time.sleep(5000L);
        Assertions.assertEquals((double)3.0, (double)rateMetric.measurableValue(time.milliseconds()), (double)0.1);
        Assertions.assertThrows(QuotaViolationException.class, () -> this.strictRecord(sensor, 30.0, time.milliseconds()));
        metrics.close();
    }

    @Test
    public void testStrictQuotaEnforcementWithTokenBucket() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor", new MetricConfig().quota(Quota.upperBound((double)2.0)).timeWindow(1L, TimeUnit.SECONDS).samples(10), new Sensor[0]);
        MetricName metricName = metrics.metricName("credits", "test-group");
        Assertions.assertTrue((boolean)sensor.add(metricName, (MeasurableStat)new TokenBucket()));
        KafkaMetric tkMetric = metrics.metric(metricName);
        this.strictRecord(sensor, 30.0, time.milliseconds());
        Assertions.assertEquals((double)-10.0, (double)tkMetric.measurableValue(time.milliseconds()), (double)0.1);
        time.sleep(5000L);
        Assertions.assertEquals((double)0.0, (double)tkMetric.measurableValue(time.milliseconds()), (double)0.1);
        this.strictRecord(sensor, 30.0, time.milliseconds());
        Assertions.assertEquals((double)-30.0, (double)tkMetric.measurableValue(time.milliseconds()), (double)0.1);
        metrics.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strictRecord(Sensor sensor, double value, long timeMs) {
        Sensor sensor2 = sensor;
        synchronized (sensor2) {
            sensor.checkQuotas(timeMs);
            sensor.record(value, timeMs, false);
        }
    }

    @Test
    public void testRecordAndCheckQuotaUseMetricConfigOfEachStat() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor");
        MeasurableStat stat1 = (MeasurableStat)Mockito.mock(MeasurableStat.class);
        MetricName stat1Name = metrics.metricName("stat1", "test-group");
        MetricConfig stat1Config = new MetricConfig().quota(Quota.upperBound((double)5.0));
        sensor.add(stat1Name, stat1, stat1Config);
        MeasurableStat stat2 = (MeasurableStat)Mockito.mock(MeasurableStat.class);
        MetricName stat2Name = metrics.metricName("stat2", "test-group");
        MetricConfig stat2Config = new MetricConfig().quota(Quota.upperBound((double)10.0));
        sensor.add(stat2Name, stat2, stat2Config);
        sensor.record(10.0, 1L);
        ((MeasurableStat)Mockito.verify((Object)stat1)).record(stat1Config, 10.0, 1L);
        ((MeasurableStat)Mockito.verify((Object)stat2)).record(stat2Config, 10.0, 1L);
        sensor.checkQuotas(2L);
        ((MeasurableStat)Mockito.verify((Object)stat1)).measure(stat1Config, 2L);
        ((MeasurableStat)Mockito.verify((Object)stat2)).measure(stat2Config, 2L);
        metrics.close();
    }

    @Test
    public void testUpdatingMetricConfigIsReflectedInTheSensor() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor");
        MeasurableStat stat = (MeasurableStat)Mockito.mock(MeasurableStat.class);
        MetricName statName = metrics.metricName("stat", "test-group");
        MetricConfig statConfig = new MetricConfig().quota(Quota.upperBound((double)5.0));
        sensor.add(statName, stat, statConfig);
        sensor.record(10.0, 1L);
        ((MeasurableStat)Mockito.verify((Object)stat)).record(statConfig, 10.0, 1L);
        sensor.checkQuotas(2L);
        ((MeasurableStat)Mockito.verify((Object)stat)).measure(statConfig, 2L);
        MetricConfig newConfig = new MetricConfig().quota(Quota.upperBound((double)10.0));
        metrics.metric(statName).config(newConfig);
        sensor.record(10.0, 3L);
        ((MeasurableStat)Mockito.verify((Object)stat)).record(newConfig, 10.0, 3L);
        sensor.checkQuotas(4L);
        ((MeasurableStat)Mockito.verify((Object)stat)).measure(newConfig, 4L);
        metrics.close();
    }
}

