/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidatorFactory;
import org.apache.kafka.common.security.oauthbearer.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerValidatorCallbackHandler;
import org.apache.kafka.common.utils.Utils;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerValidatorCallbackHandlerTest
extends OAuthBearerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        String expectedAudience = "a";
        List<String> allAudiences = Arrays.asList(expectedAudience, "b", "c");
        AccessTokenBuilder builder = new AccessTokenBuilder().audience(expectedAudience).jwk(this.createRsaJwk()).alg("RS256");
        String accessToken = builder.build();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.expected.audience", allAudiences);
        try (OAuthBearerValidatorCallbackHandler handler = this.createHandler(configs, builder);){
            OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(accessToken);
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.token());
            OAuthBearerToken token = callback.token();
            Assertions.assertEquals((Object)accessToken, (Object)token.value());
            Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
            Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
            Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        }
    }

    @Test
    public void testInvalidAccessToken() throws Exception {
        String substring = "invalid_token";
        this.assertInvalidAccessTokenFails("this isn't valid", substring);
        this.assertInvalidAccessTokenFails("this.isn't.valid", substring);
        this.assertInvalidAccessTokenFails(this.createAccessKey("this", "isn't", "valid"), substring);
        this.assertInvalidAccessTokenFails(this.createAccessKey("{}", "{}", "{}"), substring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInvalidAccessTokenFails(String accessToken, String expectedMessageSubstring) throws Exception {
        Map<String, ?> configs = this.getSaslConfigs();
        try (OAuthBearerValidatorCallbackHandler handler = this.createHandler(configs, new AccessTokenBuilder());){
            OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(accessToken);
            handler.handle(new Callback[]{callback});
            Assertions.assertNull((Object)callback.token());
            String actualMessage = callback.errorStatus();
            Assertions.assertNotNull((Object)actualMessage);
            Assertions.assertTrue((boolean)actualMessage.contains(expectedMessageSubstring), (String)String.format("The error message \"%s\" didn't contain the expected substring \"%s\"", actualMessage, expectedMessageSubstring));
        }
    }

    private OAuthBearerValidatorCallbackHandler createHandler(Map<String, ?> options, AccessTokenBuilder builder) {
        OAuthBearerValidatorCallbackHandler handler = new OAuthBearerValidatorCallbackHandler();
        CloseableVerificationKeyResolver verificationKeyResolver = (jws, nestingContext) -> builder.jwk().getPublicKey();
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(options, (VerificationKeyResolver)verificationKeyResolver);
        handler.init(verificationKeyResolver, accessTokenValidator);
        return handler;
    }

    private String createAccessKey(String header, String payload, String signature) {
        Base64.Encoder enc = Base64.getEncoder();
        header = enc.encodeToString(Utils.utf8((String)header));
        payload = enc.encodeToString(Utils.utf8((String)payload));
        signature = enc.encodeToString(Utils.utf8((String)signature));
        return String.format("%s.%s.%s", header, payload, signature);
    }
}

