/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class ApiVersionsResponseTest {
    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void shouldHaveCorrectDefaultApiVersionsResponse(ApiMessageType.ListenerType scope) {
        ApiVersionsResponse defaultResponse = ApiVersionsResponse.defaultApiVersionsResponse((ApiMessageType.ListenerType)scope);
        Assertions.assertEquals((int)ApiKeys.apisForListener((ApiMessageType.ListenerType)scope).size(), (int)defaultResponse.data().apiKeys().size(), (String)"API versions for all API keys must be maintained.");
        for (ApiKeys key : ApiKeys.apisForListener((ApiMessageType.ListenerType)scope)) {
            int i;
            ApiVersionsResponseData.ApiVersion version = defaultResponse.apiVersion(key.id);
            Assertions.assertNotNull((Object)version, (String)("Could not find ApiVersion for API " + key.name));
            Assertions.assertEquals((short)version.minVersion(), (short)key.oldestVersion(), (String)("Incorrect min version for Api " + key.name));
            Assertions.assertEquals((short)version.maxVersion(), (short)key.latestVersion(), (String)("Incorrect max version for Api " + key.name));
            for (i = 0; i < version.minVersion(); ++i) {
                Assertions.assertNull((Object)key.messageType.requestSchemas()[i], (String)("Request version " + i + " for API " + version.apiKey() + " must be null"));
                Assertions.assertNull((Object)key.messageType.responseSchemas()[i], (String)("Response version " + i + " for API " + version.apiKey() + " must be null"));
            }
            for (i = version.minVersion(); i <= version.maxVersion(); ++i) {
                Assertions.assertNotNull((Object)key.messageType.requestSchemas()[i], (String)("Request version " + i + " for API " + version.apiKey() + " must not be null"));
                Assertions.assertNotNull((Object)key.messageType.responseSchemas()[i], (String)("Response version " + i + " for API " + version.apiKey() + " must not be null"));
            }
        }
        Assertions.assertTrue((boolean)defaultResponse.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)defaultResponse.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)defaultResponse.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldHaveCommonlyAgreedApiVersionResponseWithControllerOnForwardableAPIs() {
        ApiKeys forwardableAPIKey = ApiKeys.CREATE_ACLS;
        ApiKeys nonForwardableAPIKey = ApiKeys.JOIN_GROUP;
        boolean minVersion = false;
        boolean maxVersion = true;
        Map activeControllerApiVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)forwardableAPIKey, (Object)new ApiVersionsResponseData.ApiVersion().setApiKey(forwardableAPIKey.id).setMinVersion((short)0).setMaxVersion((short)1)), Utils.mkEntry((Object)nonForwardableAPIKey, (Object)new ApiVersionsResponseData.ApiVersion().setApiKey(nonForwardableAPIKey.id).setMinVersion((short)0).setMaxVersion((short)1))});
        ApiVersionsResponseData.ApiVersionCollection commonResponse = ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER, (RecordVersion)RecordVersion.current(), (Map)activeControllerApiVersions);
        this.verifyVersions(forwardableAPIKey.id, (short)0, (short)1, commonResponse);
        this.verifyVersions(nonForwardableAPIKey.id, ApiKeys.JOIN_GROUP.oldestVersion(), ApiKeys.JOIN_GROUP.latestVersion(), commonResponse);
    }

    @Test
    public void shouldCreateApiResponseOnlyWithKeysSupportedByMagicValue() {
        ApiVersionsResponse response = ApiVersionsResponse.createApiVersionsResponse((int)10, (RecordVersion)RecordVersion.V1, (Features)Features.emptySupportedFeatures(), Collections.emptyMap(), (long)-1L, null, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
        Assertions.assertTrue((boolean)response.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)response.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldReturnFeatureKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = ApiVersionsResponse.createApiVersionsResponse((int)10, (RecordVersion)RecordVersion.V1, (Features)Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new SupportedVersionRange(1, 4))})), (Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)3)}), (long)10L, null, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
        Assertions.assertEquals((int)1, (int)response.data().supportedFeatures().size());
        ApiVersionsResponseData.SupportedFeatureKey sKey = response.data().supportedFeatures().find("feature");
        Assertions.assertNotNull((Object)sKey);
        Assertions.assertEquals((int)1, (int)sKey.minVersion());
        Assertions.assertEquals((int)4, (int)sKey.maxVersion());
        Assertions.assertEquals((int)1, (int)response.data().finalizedFeatures().size());
        ApiVersionsResponseData.FinalizedFeatureKey fKey = response.data().finalizedFeatures().find("feature");
        Assertions.assertNotNull((Object)fKey);
        Assertions.assertEquals((int)3, (int)fKey.minVersionLevel());
        Assertions.assertEquals((int)3, (int)fKey.maxVersionLevel());
        Assertions.assertEquals((long)10L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldReturnAllKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = ApiVersionsResponse.createApiVersionsResponse((int)0, (RecordVersion)RecordVersion.current(), (Features)Features.emptySupportedFeatures(), Collections.emptyMap(), (long)-1L, null, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        Assertions.assertEquals(new HashSet(ApiKeys.zkBrokerApis()), this.apiKeysInResponse(response));
        Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
        Assertions.assertTrue((boolean)response.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)response.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void testMetadataQuorumApisAreDisabled() {
        ApiVersionsResponse response = ApiVersionsResponse.createApiVersionsResponse((int)0, (RecordVersion)RecordVersion.current(), (Features)Features.emptySupportedFeatures(), Collections.emptyMap(), (long)-1L, null, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        HashSet<ApiKeys> exposedApis = this.apiKeysInResponse(response);
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.VOTE));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.BEGIN_QUORUM_EPOCH));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.END_QUORUM_EPOCH));
        Assertions.assertFalse((boolean)exposedApis.contains(ApiKeys.DESCRIBE_QUORUM));
    }

    @Test
    public void testIntersect() {
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect(null, null).isPresent());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)new ApiVersionsResponseData.ApiVersion().setApiKey((short)10), (ApiVersionsResponseData.ApiVersion)new ApiVersionsResponseData.ApiVersion().setApiKey((short)3)));
        short min = 0;
        short max = 10;
        ApiVersionsResponseData.ApiVersion thisVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion(min).setMaxVersion((short)Short.MAX_VALUE);
        ApiVersionsResponseData.ApiVersion other = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion((short)Short.MIN_VALUE).setMaxVersion(max);
        ApiVersionsResponseData.ApiVersion expected = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion(min).setMaxVersion(max);
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)thisVersion, null).isPresent());
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect(null, (ApiVersionsResponseData.ApiVersion)other).isPresent());
        Assertions.assertEquals((Object)expected, ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)thisVersion, (ApiVersionsResponseData.ApiVersion)other).get());
        Assertions.assertEquals((Object)expected, ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)other, (ApiVersionsResponseData.ApiVersion)thisVersion).get());
    }

    private void verifyVersions(short forwardableAPIKey, short minVersion, short maxVersion, ApiVersionsResponseData.ApiVersionCollection commonResponse) {
        ApiVersionsResponseData.ApiVersion expectedVersionsForForwardableAPI = new ApiVersionsResponseData.ApiVersion().setApiKey(forwardableAPIKey).setMinVersion(minVersion).setMaxVersion(maxVersion);
        Assertions.assertEquals((Object)expectedVersionsForForwardableAPI, (Object)commonResponse.find(forwardableAPIKey));
    }

    private void verifyApiKeysForMagic(ApiVersionsResponse response, Byte maxMagic) {
        Iterator iterator = response.data().apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersion version = (ApiVersionsResponseData.ApiVersion)iterator.next();
            Assertions.assertTrue((ApiKeys.forId((int)version.apiKey()).minRequiredInterBrokerMagic <= maxMagic ? 1 : 0) != 0);
        }
    }

    private HashSet<ApiKeys> apiKeysInResponse(ApiVersionsResponse apiVersions) {
        HashSet<ApiKeys> apiKeys = new HashSet<ApiKeys>();
        Iterator iterator = apiVersions.data().apiKeys().iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseData.ApiVersion version = (ApiVersionsResponseData.ApiVersion)iterator.next();
            apiKeys.add(ApiKeys.forId((int)version.apiKey()));
        }
        return apiKeys;
    }
}

