/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerPartitionAssignorTest {
    @Test
    public void shouldInstantiateAssignor() {
        List assignors = ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList(StickyAssignor.class.getName()), Collections.emptyMap());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof StickyAssignor));
    }

    @Test
    public void shouldInstantiateListOfAssignors() {
        List assignors = ConsumerPartitionAssignor.getAssignorInstances(Arrays.asList(StickyAssignor.class.getName(), CooperativeStickyAssignor.class.getName()), Collections.emptyMap());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof StickyAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof CooperativeStickyAssignor));
    }

    @Test
    public void shouldThrowKafkaExceptionOnNonAssignor() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList(String.class.getName()), Collections.emptyMap()));
    }

    @Test
    public void shouldThrowKafkaExceptionOnAssignorNotFound() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList("Non-existent assignor"), Collections.emptyMap()));
    }

    @Test
    public void shouldInstantiateFromClassType() {
        List classTypes = this.initConsumerConfigWithClassTypes(Collections.singletonList(StickyAssignor.class)).getList("partition.assignment.strategy");
        List assignors = ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof StickyAssignor));
    }

    @Test
    public void shouldInstantiateFromListOfClassTypes() {
        List classTypes = this.initConsumerConfigWithClassTypes(Arrays.asList(StickyAssignor.class, CooperativeStickyAssignor.class)).getList("partition.assignment.strategy");
        List assignors = ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap());
        Assertions.assertTrue((boolean)(assignors.get(0) instanceof StickyAssignor));
        Assertions.assertTrue((boolean)(assignors.get(1) instanceof CooperativeStickyAssignor));
    }

    @Test
    public void shouldThrowKafkaExceptionOnListWithNonAssignorClassType() {
        List classTypes = this.initConsumerConfigWithClassTypes(Arrays.asList(StickyAssignor.class, String.class)).getList("partition.assignment.strategy");
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap()));
    }

    @Test
    public void shouldThrowKafkaExceptionOnAssignorsWithSameName() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Arrays.asList(RangeAssignor.class.getName(), TestConsumerPartitionAssignor.class.getName()), Collections.emptyMap()));
    }

    private ConsumerConfig initConsumerConfigWithClassTypes(List<Object> classTypes) {
        Properties props = new Properties();
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("partition.assignment.strategy", classTypes);
        return new ConsumerConfig(props);
    }

    public static class TestConsumerPartitionAssignor
    implements ConsumerPartitionAssignor {
        public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
            return null;
        }

        public String name() {
            return new RangeAssignor().name();
        }
    }
}

