/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public final class MessageTest {
    private final String memberId = "memberId";
    private final String instanceId = "instanceId";
    private final List<Integer> listOfVersionsNonBatchOffsetFetch = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);

    @Test
    public void testAddOffsetsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnRequestData().setTransactionalId("foobar").setProducerId(52596993799604990L).setProducerEpoch((short)123).setGroupId("baaz"));
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnResponseData().setThrottleTimeMs(42).setErrorCode((short)0));
    }

    @Test
    public void testAddPartitionsToTxnVersions() throws Exception {
        AddPartitionsToTxnRequestData v3AndBelowData = new AddPartitionsToTxnRequestData().setV3AndBelowTransactionalId("blah").setV3AndBelowProducerId(52596993799604990L).setV3AndBelowProducerEpoch((short)30000).setV3AndBelowTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("Topic").setPartitions(Collections.singletonList(1))).iterator()));
        this.testDuplication((Message)v3AndBelowData);
        this.testAllMessageRoundTripsUntilVersion((short)3, (Message)v3AndBelowData);
        AddPartitionsToTxnRequestData data = new AddPartitionsToTxnRequestData().setTransactions(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("blah").setProducerId(52596993799604990L).setProducerEpoch((short)30000).setTopics(v3AndBelowData.v3AndBelowTopics())).iterator()));
        this.testDuplication((Message)data);
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)data);
    }

    @Test
    public void testCreateTopicsVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new CreateTopicsRequestData().setTimeoutMs(1000).setTopics(new CreateTopicsRequestData.CreatableTopicCollection()));
    }

    @Test
    public void testDescribeAclsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeAclsRequestData().setResourceTypeFilter((byte)42).setResourceNameFilter(null).setPatternTypeFilter((byte)3).setPrincipalFilter("abc").setHostFilter(null).setOperation((byte)0).setPermissionType((byte)0));
    }

    @Test
    public void testMetadataVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new MetadataRequestData().setTopics(Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName("foo"), new MetadataRequestData.MetadataRequestTopic().setName("bar"))));
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(false).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
    }

    @Test
    public void testHeartbeatVersions() throws Exception {
        Supplier<HeartbeatRequestData> newRequest = () -> new HeartbeatRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupRequestVersions() throws Exception {
        Supplier<JoinGroupRequestData> newRequest = () -> new JoinGroupRequestData().setGroupId("groupId").setMemberId("memberId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection()).setSessionTimeoutMs(10000);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newRequest.get().setRebalanceTimeoutMs(20000));
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testListOffsetsRequestVersions() throws Exception {
        List<ListOffsetsRequestData.ListOffsetsTopic> v = Collections.singletonList(new ListOffsetsRequestData.ListOffsetsTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(123L))));
        Supplier<ListOffsetsRequestData> newRequest = () -> new ListOffsetsRequestData().setTopics(v).setReplicaId(0);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newRequest.get().setIsolationLevel(IsolationLevel.READ_COMMITTED.id()));
    }

    @Test
    public void testListOffsetsResponseVersions() throws Exception {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partition = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setOldStyleOffsets(Collections.singletonList(321L));
        List<ListOffsetsResponseData.ListOffsetsTopicResponse> topics = Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("topic").setPartitions(Collections.singletonList(partition)));
        Supplier<ListOffsetsResponseData> response = () -> new ListOffsetsResponseData().setTopics(topics);
        Iterator iterator = ApiKeys.LIST_OFFSETS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ListOffsetsResponseData responseData = response.get();
            if (version > 0) {
                ((ListOffsetsResponseData.ListOffsetsPartitionResponse)((ListOffsetsResponseData.ListOffsetsTopicResponse)responseData.topics().get(0)).partitions().get(0)).setOldStyleOffsets(Collections.emptyList()).setOffset(456L).setTimestamp(123L);
            }
            if (version > 1) {
                responseData.setThrottleTimeMs(1000);
            }
            if (version > 3) {
                partition.setLeaderEpoch(1);
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void testJoinGroupResponseVersions() throws Exception {
        Supplier<JoinGroupResponseData> newResponse = () -> new JoinGroupResponseData().setMemberId("memberId").setLeader("memberId").setGenerationId(1).setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId")));
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTrips((Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId("instanceId"));
    }

    @Test
    public void testLeaveGroupResponseVersions() throws Exception {
        Supplier<LeaveGroupResponseData> newResponse = () -> new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code());
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newResponse.get().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setMemberId("memberId").setGroupInstanceId("instanceId"))));
    }

    @Test
    public void testSyncGroupDefaultGroupInstanceId() throws Exception {
        Supplier<SyncGroupRequestData> request = () -> new SyncGroupRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15).setAssignments(new ArrayList());
        this.testAllMessageRoundTrips((Message)request.get());
        this.testAllMessageRoundTrips((Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetCommitDefaultGroupInstanceId() throws Exception {
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setTopics(new ArrayList()).setGroupId("groupId"));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setTopics(new ArrayList()).setGenerationId(15);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)7, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testDescribeGroupsRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeGroupsRequestData().setGroups(Collections.singletonList("group")).setIncludeAuthorizedOperations(false));
    }

    @Test
    public void testDescribeGroupsResponseVersions() throws Exception {
        DescribeGroupsResponseData.DescribedGroupMember baseMember = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId");
        DescribeGroupsResponseData.DescribedGroup baseGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(baseMember)).setProtocolType("consumer");
        DescribeGroupsResponseData baseResponse = new DescribeGroupsResponseData().setGroups(Collections.singletonList(baseGroup));
        this.testAllMessageRoundTrips((Message)baseResponse);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)baseResponse.setThrottleTimeMs(10));
        baseGroup.setAuthorizedOperations(1);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)baseResponse);
        baseMember.setGroupInstanceId("instanceId");
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)baseResponse);
    }

    @Test
    public void testDescribeClusterRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(true));
    }

    @Test
    public void testDescribeClusterResponseVersions() throws Exception {
        DescribeClusterResponseData data = new DescribeClusterResponseData().setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Collections.singletonList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("localhost").setPort(9092).setRack("rack1")).iterator())).setClusterId("clusterId").setControllerId(1).setClusterAuthorizedOperations(10);
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testGroupInstanceIdIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId").setGroupInstanceId("instanceId"))).setProtocolType("consumer")));
        DescribeGroupsResponseData expectedResponse = responseWithGroupInstanceId.duplicate();
        ((DescribeGroupsResponseData.DescribedGroupMember)((DescribeGroupsResponseData.DescribedGroup)expectedResponse.groups().get(0)).members().get(0)).setGroupInstanceId(null);
        this.testAllMessageRoundTripsBeforeVersion((short)4, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testThrottleTimeIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId"))).setProtocolType("consumer"))).setThrottleTimeMs(10);
        DescribeGroupsResponseData expectedResponse = responseWithGroupInstanceId.duplicate();
        expectedResponse.setThrottleTimeMs(0);
        this.testAllMessageRoundTripsBeforeVersion((short)1, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testOffsetForLeaderEpochVersions() throws Exception {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataNoCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3);
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataWithCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3).setCurrentLeaderEpoch(5);
        OffsetForLeaderEpochRequestData data = new OffsetForLeaderEpochRequestData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic("foo").setPartitions(Collections.singletonList(partitionDataNoCurrentEpoch)));
        this.testAllMessageRoundTrips((Message)data);
        this.testAllMessageRoundTripsBeforeVersion((short)2, (Message)partitionDataWithCurrentEpoch, (Message)partitionDataNoCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)partitionDataWithCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5));
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData());
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData().setReplicaId(-2));
    }

    @Test
    public void testLeaderAndIsrVersions() throws Exception {
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateNoAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0))));
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateWithAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0)).setAddingReplicas(Collections.singletonList(1)).setRemovingReplicas(Collections.singletonList(1))));
        this.testAllMessageRoundTripsBetweenVersions((short)2, (short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)), (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateNoAddingRemovingReplicas)));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)));
    }

    @Test
    public void testOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset((long)offset))))));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId(groupId).setMemberId("memberId").setGroupInstanceId("instanceId").setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset((long)offset).setCommitTimestamp(20L))))).setRetentionTimeMs(20L);
        Iterator iterator = ApiKeys.OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            OffsetCommitRequestData requestData = request.get();
            if (version < 1) {
                requestData.setMemberId("");
                requestData.setGenerationId(-1);
            }
            if (version != 1) {
                ((OffsetCommitRequestData.OffsetCommitRequestPartition)((OffsetCommitRequestData.OffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommitTimestamp(-1L);
            }
            if (version < 2 || version > 4) {
                requestData.setRetentionTimeMs(-1L);
            }
            if (version < 6) {
                ((OffsetCommitRequestData.OffsetCommitRequestPartition)((OffsetCommitRequestData.OffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            if (version < 7) {
                requestData.setGroupInstanceId(null);
            }
            if (version == 1) {
                this.testEquivalentMessageRoundTrip(version, (Message)requestData);
                continue;
            }
            if (version >= 2 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)5, (Message)requestData, (Message)requestData);
                continue;
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testOffsetCommitResponseVersions() throws Exception {
        Supplier<OffsetCommitResponseData> response = () -> new OffsetCommitResponseData().setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20);
        Iterator iterator = ApiKeys.OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            OffsetCommitResponseData responseData = response.get();
            if (version < 3) {
                responseData.setThrottleTimeMs(0);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)responseData);
        }
    }

    @Test
    public void testTxnOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        String txnId = "transactionalId";
        int producerId = 25;
        short producerEpoch = 10;
        String instanceId = "instance";
        String memberId = "member";
        int generationId = 1;
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset((long)offset))))));
        Supplier<TxnOffsetCommitRequestData> request = () -> new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setGroupInstanceId(instanceId).setMemberId(memberId).setGenerationId(generationId).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset((long)offset)))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitRequestData requestData = request.get();
            if (version < 2) {
                ((TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition)((TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            if (version < 3) {
                short finalVersion = version;
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGroupInstanceId(null);
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setMemberId("");
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGenerationId(-1);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testTxnOffsetCommitResponseVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20));
    }

    @Test
    public void testOffsetFetchV0ToV7() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        List<OffsetFetchRequestData.OffsetFetchRequestTopic> topics = Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(topicName).setPartitionIndexes(Collections.singletonList(5)));
        this.testAllMessageRoundTripsOffsetFetchV0ToV7((Message)new OffsetFetchRequestData().setTopics(new ArrayList()).setGroupId(groupId));
        this.testAllMessageRoundTripsOffsetFetchV0ToV7((Message)new OffsetFetchRequestData().setGroupId(groupId).setTopics(topics));
        OffsetFetchRequestData allPartitionData = new OffsetFetchRequestData().setGroupId(groupId).setTopics(null);
        OffsetFetchRequestData requireStableData = new OffsetFetchRequestData().setGroupId(groupId).setTopics(topics).setRequireStable(true);
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            short finalVersion = (short)version;
            if (version < 2) {
                Assertions.assertThrows(NullPointerException.class, () -> this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)allPartitionData));
            } else {
                this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7((short)version, (Message)allPartitionData);
            }
            if (version < 7) {
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)requireStableData));
                continue;
            }
            this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)requireStableData);
        }
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))).setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            OffsetFetchResponseData responseData = response.get();
            if (version <= 1) {
                responseData.setErrorCode(Errors.NONE.code());
            }
            if (version <= 2) {
                responseData.setThrottleTimeMs(0);
            }
            if (version <= 4) {
                ((OffsetFetchResponseData.OffsetFetchResponsePartition)((OffsetFetchResponseData.OffsetFetchResponseTopic)responseData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7((short)version, (Message)responseData);
        }
    }

    private void testAllMessageRoundTripsOffsetFetchV0ToV7(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(message.lowestSupportedVersion(), message);
    }

    private void testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= 7; version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    @Test
    public void testOffsetFetchV8AndAboveSingleGroup() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> topic = Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topicName).setPartitionIndexes(Collections.singletonList(5)));
        OffsetFetchRequestData allPartitionData = new OffsetFetchRequestData().setGroups(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setTopics(null)));
        OffsetFetchRequestData specifiedPartitionData = new OffsetFetchRequestData().setGroups(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setTopics(topic))).setRequireStable(true);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)allPartitionData);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)specifiedPartitionData);
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)specifiedPartitionData);
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)allPartitionData);
        }
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setGroups(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopics().setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))).setErrorCode(Errors.NOT_COORDINATOR.code()))).setThrottleTimeMs(10);
        Iterator iterator2 = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator2.hasNext()) {
            short version = (Short)iterator2.next();
            if (version < 8) continue;
            OffsetFetchResponseData responseData = response.get();
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)responseData);
        }
    }

    @Test
    public void testOffsetFetchV8AndAbove() throws Exception {
        String groupOne = "group1";
        String groupTwo = "group2";
        String groupThree = "group3";
        String groupFour = "group4";
        String groupFive = "group5";
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        OffsetFetchRequestData.OffsetFetchRequestTopics topicOne = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic1).setPartitionIndexes(Collections.singletonList(5));
        OffsetFetchRequestData.OffsetFetchRequestTopics topicTwo = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic2).setPartitionIndexes(Collections.singletonList(10));
        OffsetFetchRequestData.OffsetFetchRequestTopics topicThree = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic3).setPartitionIndexes(Collections.singletonList(15));
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupOneTopics = Collections.singletonList(topicOne);
        OffsetFetchRequestData.OffsetFetchRequestGroup group1 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupOne).setTopics(groupOneTopics);
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupTwoTopics = Arrays.asList(topicOne, topicTwo);
        OffsetFetchRequestData.OffsetFetchRequestGroup group2 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupTwo).setTopics(groupTwoTopics);
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupThreeTopics = Arrays.asList(topicOne, topicTwo, topicThree);
        OffsetFetchRequestData.OffsetFetchRequestGroup group3 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupThree).setTopics(groupThreeTopics);
        OffsetFetchRequestData.OffsetFetchRequestGroup group4 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupFour).setTopics(null);
        OffsetFetchRequestData.OffsetFetchRequestGroup group5 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupFive).setTopics(null);
        OffsetFetchRequestData requestData = new OffsetFetchRequestData().setGroups(Arrays.asList(group1, group2, group3, group4, group5)).setRequireStable(true);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)requestData);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)requestData.setRequireStable(false));
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)requestData);
        }
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic1 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic1).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())));
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic2 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic2).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(10).setMetadata("foo").setCommittedOffset(200L).setCommittedLeaderEpoch(2).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())));
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic3 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic3).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(15).setMetadata("bar").setCommittedOffset(300L).setCommittedLeaderEpoch(1).setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code())));
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup1 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupOne).setTopics(Collections.singletonList(responseTopic1)).setErrorCode(Errors.NOT_COORDINATOR.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup2 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupTwo).setTopics(Arrays.asList(responseTopic1, responseTopic2)).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup3 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupThree).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup4 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupFour).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup5 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupFive).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setGroups(Arrays.asList(responseGroup1, responseGroup2, responseGroup3, responseGroup4, responseGroup5)).setThrottleTimeMs(10);
        Iterator iterator2 = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator2.hasNext()) {
            short version = (Short)iterator2.next();
            if (version < 8) continue;
            OffsetFetchResponseData responseData = response.get();
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)responseData);
        }
    }

    private void testAllMessageRoundTripsOffsetFetchV8AndAbove(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove((short)8, message);
    }

    private void testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    @Test
    public void testProduceResponseVersions() throws Exception {
        String topicName = "topic";
        int partitionIndex = 0;
        short errorCode = Errors.INVALID_TOPIC_EXCEPTION.code();
        long baseOffset = 12L;
        int throttleTimeMs = 1234;
        long logAppendTimeMs = 1234L;
        long logStartOffset = 1234L;
        int batchIndex = 0;
        String batchIndexErrorMessage = "error message";
        String errorMessage = "global error message";
        this.testAllMessageRoundTrips((Message)new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset)))).iterator())));
        Supplier<ProduceResponseData> response = () -> new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset).setLogAppendTimeMs(logAppendTimeMs).setLogStartOffset(logStartOffset).setRecordErrors(Collections.singletonList(new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(batchIndex).setBatchIndexErrorMessage(batchIndexErrorMessage))).setErrorMessage(errorMessage)))).iterator())).setThrottleTimeMs(throttleTimeMs);
        Iterator iterator = ApiKeys.PRODUCE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ProduceResponseData responseData = response.get();
            if (version < 8) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setRecordErrors(Collections.emptyList());
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setErrorMessage(null);
            }
            if (version < 5) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogStartOffset(-1L);
            }
            if (version < 2) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogAppendTimeMs(-1L);
            }
            if (version < 1) {
                responseData.setThrottleTimeMs(0);
            }
            if (version >= 3 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)5, (Message)responseData, (Message)responseData);
                continue;
            }
            if (version >= 6 && version <= 7) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)8, (Message)responseData, (Message)responseData);
                continue;
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void defaultValueShouldBeWritable() {
        for (short version = 0; version <= 2; version = (short)(version + 1)) {
            MessageUtil.toByteBuffer((Message)new SimpleExampleMessageData(), (short)version);
        }
    }

    @Test
    public void testSimpleMessage() throws Exception {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyStruct(new SimpleExampleMessageData.MyStruct().setStructId(25).setArrayInStruct(Collections.singletonList(new SimpleExampleMessageData.StructArray().setArrayFieldId(20))));
        message.setMyTaggedStruct(new SimpleExampleMessageData.TaggedStruct().setStructId("abc"));
        message.setProcessId(Uuid.randomUuid());
        message.setMyNullableString("notNull");
        message.setMyInt16((short)3);
        message.setMyString("test string");
        SimpleExampleMessageData duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        duplicate.setMyTaggedIntArray(Collections.singletonList(123));
        Assertions.assertNotEquals((Object)duplicate, (Object)message);
        Assertions.assertNotEquals((Object)message, (Object)duplicate);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)message);
    }

    private void testAllMessageRoundTrips(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsFromVersion(message.lowestSupportedVersion(), message);
    }

    private void testDuplication(Message message) {
        Message duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        Assertions.assertEquals((int)duplicate.hashCode(), (int)message.hashCode());
        Assertions.assertEquals((int)message.hashCode(), (int)duplicate.hashCode());
    }

    private void testAllMessageRoundTripsBeforeVersion(short beforeVersion, Message message, Message expected) throws Exception {
        this.testAllMessageRoundTripsBetweenVersions((short)0, beforeVersion, message, expected);
    }

    private void testAllMessageRoundTripsBetweenVersions(short startVersion, short endVersion, Message message, Message expected) throws Exception {
        for (short version = startVersion; version < endVersion; version = (short)(version + 1)) {
            this.testMessageRoundTrip(version, message, expected);
        }
    }

    private void testAllMessageRoundTripsFromVersion(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testAllMessageRoundTripsUntilVersion(short untilVersion, Message message) throws Exception {
        for (short version = message.lowestSupportedVersion(); version <= untilVersion; version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testMessageRoundTrip(short version, Message message, Message expected) throws Exception {
        this.testByteBufferRoundTrip(version, message, expected);
    }

    private void testEquivalentMessageRoundTrip(short version, Message message) throws Exception {
        this.testByteBufferRoundTrip(version, message, message);
        this.testJsonRoundTrip(version, message, message);
    }

    private void testByteBufferRoundTrip(short version, Message message, Message expected) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes written for version " + version));
        Message message2 = (Message)message.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        buf.flip();
        message2.read((Readable)byteBufferAccessor, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes read back in for version " + version));
        Assertions.assertEquals((Object)expected, (Object)message2, (String)("The message object created after a round trip did not match for version " + version));
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private void testJsonRoundTrip(short version, Message message, Message expected) throws Exception {
        String jsonConverter = MessageTest.jsonConverterTypeName(message.getClass().getTypeName());
        Class<?> converter = Class.forName(jsonConverter);
        Method writeMethod = converter.getMethod("write", message.getClass(), Short.TYPE);
        JsonNode jsonNode = (JsonNode)writeMethod.invoke(null, message, version);
        Method readMethod = converter.getMethod("read", JsonNode.class, Short.TYPE);
        Message message2 = (Message)readMethod.invoke(null, jsonNode, version);
        Assertions.assertEquals((Object)expected, (Object)message2);
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private static String jsonConverterTypeName(String source) {
        int outerClassIndex = source.lastIndexOf(36);
        if (outerClassIndex == -1) {
            return source + "JsonConverter";
        }
        return source.substring(0, outerClassIndex) + "JsonConverter$" + source.substring(outerClassIndex + 1) + "JsonConverter";
    }

    @Test
    public void testMessageVersions() {
        for (ApiKeys apiKey : ApiKeys.values()) {
            ApiMessage message = null;
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newRequest();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No request message spec found for API " + apiKey));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Request message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()));
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newResponse();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No response message spec found for API " + apiKey));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Response message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()));
        }
    }

    @Test
    public void testDefaultValues() {
        this.verifyWriteRaisesUve((short)0, "validateOnly", (Message)new CreateTopicsRequestData().setValidateOnly(true));
        this.verifyWriteSucceeds((short)0, (Message)new CreateTopicsRequestData().setValidateOnly(false));
        this.verifyWriteSucceeds((short)0, (Message)new OffsetCommitRequestData().setRetentionTimeMs(123L));
        this.verifyWriteRaisesUve((short)5, "forgotten", (Message)new FetchRequestData().setForgottenTopicsData(Collections.singletonList(new FetchRequestData.ForgottenTopic().setTopic("foo"))));
    }

    @Test
    public void testNonIgnorableFieldWithDefaultNull() {
        this.verifyWriteRaisesUve((short)0, "groupInstanceId", (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId("instanceId"));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId(null));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId"));
    }

    @Test
    public void testWriteNullForNonNullableFieldRaisesException() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData().setTopics(null);
        Iterator iterator = ApiKeys.CREATE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.verifyWriteRaisesNpe(version, (Message)createTopics);
        }
        MetadataRequestData metadata = new MetadataRequestData().setTopics(null);
        this.verifyWriteRaisesNpe((short)0, (Message)metadata);
    }

    @Test
    public void testUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
        RawTaggedField field1000 = new RawTaggedField(1000, new byte[]{1, 2, 3});
        createTopics.unknownTaggedFields().add(field1000);
        this.verifyWriteRaisesUve((short)0, "Tagged fields were set", (Message)createTopics);
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
    }

    @Test
    public void testLongTaggedString() throws Exception {
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        String longString = new String(chars);
        SimpleExampleMessageData message = new SimpleExampleMessageData().setMyString(longString);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        short version = 1;
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position());
    }

    private void verifyWriteRaisesNpe(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        Assertions.assertThrows(NullPointerException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
    }

    private void verifyWriteRaisesUve(short version, String problemText, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        UnsupportedVersionException e = (UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
        Assertions.assertTrue((boolean)e.getMessage().contains(problemText), (String)("Expected to get an error message about " + problemText + ", but got: " + e.getMessage()));
    }

    private void verifyWriteSucceeds(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size * 2);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("Expected the serialized size to be " + size + ", but it was " + buf.position()));
    }

    @Test
    public void testCompareWithUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTimeoutMs(123);
        CreateTopicsRequestData createTopics2 = new CreateTopicsRequestData();
        createTopics2.setTimeoutMs(123);
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields();
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertNotEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertNotEquals((Object)createTopics2, (Object)createTopics);
        createTopics2.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
    }
}

