/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SerializationTest {
    private final String topic = "testTopic";
    private final Map<Class<?>, List<Object>> testData = new HashMap<Class<?>, List<Object>>(){
        {
            this.put(String.class, Arrays.asList(null, "my string"));
            this.put(Short.class, Arrays.asList(null, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE));
            this.put(Integer.class, Arrays.asList(null, 423412424, -41243432));
            this.put(Long.class, Arrays.asList(null, 0xCCCCCCCCCCCCCCCL, -922337203685477581L));
            this.put(Float.class, Arrays.asList(null, Float.valueOf(5678567.0f), Float.valueOf(-5678567.0f)));
            this.put(Double.class, Arrays.asList(null, 5678567.12312, -5678567.12341));
            this.put(byte[].class, Arrays.asList(null, "my string".getBytes()));
            this.put(ByteBuffer.class, Arrays.asList(null, ByteBuffer.wrap("my string".getBytes()), ByteBuffer.allocate(10).put("my string".getBytes()), ByteBuffer.allocateDirect(10).put("my string".getBytes())));
            this.put(Bytes.class, Arrays.asList(null, new Bytes("my string".getBytes())));
            this.put(UUID.class, Arrays.asList(null, UUID.randomUUID()));
        }
    };

    @Test
    public void allSerdesShouldRoundtripInput() {
        for (Map.Entry<Class<?>, List<Object>> test : this.testData.entrySet()) {
            Serde serde = Serdes.serdeFrom(test.getKey());
            Throwable throwable = null;
            try {
                for (Object value : test.getValue()) {
                    byte[] serialized = serde.serializer().serialize("testTopic", value);
                    Assertions.assertEquals((Object)value, (Object)serde.deserializer().deserialize("testTopic", serialized), (String)("Should get the original " + test.getKey().getSimpleName() + " after serialization and deserialization"));
                    if (value instanceof byte[]) {
                        Assertions.assertArrayEquals((byte[])((byte[])value), (byte[])((byte[])serde.deserializer().deserialize("testTopic", null, (byte[])value)), (String)("Should get the original " + test.getKey().getSimpleName() + " after serialization and deserialization"));
                        continue;
                    }
                    Assertions.assertEquals((Object)value, (Object)serde.deserializer().deserialize("testTopic", null, Utils.wrapNullable((byte[])serialized)), (String)("Should get the original " + test.getKey().getSimpleName() + " after serialization and deserialization"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test
    public void allSerdesShouldSupportNull() {
        for (Class<?> cls : this.testData.keySet()) {
            Serde serde = Serdes.serdeFrom(cls);
            Throwable throwable = null;
            try {
                Assertions.assertNull((Object)serde.serializer().serialize("testTopic", null), (String)("Should support null in " + cls.getSimpleName() + " serialization"));
                Assertions.assertNull((Object)serde.deserializer().deserialize("testTopic", null), (String)("Should support null in " + cls.getSimpleName() + " deserialization"));
                Assertions.assertNull((Object)serde.deserializer().deserialize("testTopic", null, (ByteBuffer)null), (String)("Should support null in " + cls.getSimpleName() + " deserialization"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test
    public void testSerdeFromUnknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Serdes.serdeFrom(DummyClass.class));
    }

    @Test
    public void testSerdeFromNotNull() {
        try (Serde serde = Serdes.Long();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> Serdes.serdeFrom(null, (Deserializer)serde.deserializer()));
        }
    }

    @Test
    public void stringSerdeShouldSupportDifferentEncodings() {
        String str = "my string";
        List<String> encodings = Arrays.asList(StandardCharsets.UTF_8.name(), StandardCharsets.UTF_16.name());
        for (String encoding : encodings) {
            Serde<String> serDeser = this.getStringSerde(encoding);
            Throwable throwable = null;
            try {
                Serializer serializer = serDeser.serializer();
                Deserializer deserializer = serDeser.deserializer();
                Assertions.assertEquals((Object)str, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)str)), (String)("Should get the original string after serialization and deserialization with encoding " + encoding));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serDeser == null) continue;
                if (throwable != null) {
                    try {
                        serDeser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serDeser.close();
            }
        }
    }

    @Test
    public void listSerdeShouldReturnEmptyCollection() {
        List<Integer> testData = Arrays.asList(new Integer[0]);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Integer());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get empty collection after serialization and deserialization on an empty list");
    }

    @Test
    public void listSerdeShouldReturnNull() {
        Object testData = null;
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Integer());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get null after serialization and deserialization on an empty list");
    }

    @Test
    public void listSerdeShouldRoundtripIntPrimitiveInput() {
        List<Integer> testData = Arrays.asList(1, 2, 3);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Integer());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of integer primitives after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForIntPrimitiveInput() {
        List<Integer> testData = Arrays.asList(1, 2, 3);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Integer());
        Assertions.assertEquals((int)21, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 21 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripShortPrimitiveInput() {
        List<Short> testData = Arrays.asList((short)1, (short)2, (short)3);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Short());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of short primitives after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForShortPrimitiveInput() {
        List<Short> testData = Arrays.asList((short)1, (short)2, (short)3);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Short());
        Assertions.assertEquals((int)15, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 15 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripFloatPrimitiveInput() {
        List<Float> testData = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f));
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Float());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of float primitives after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForFloatPrimitiveInput() {
        List<Float> testData = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f));
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Float());
        Assertions.assertEquals((int)21, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 21 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripLongPrimitiveInput() {
        List<Long> testData = Arrays.asList(1L, 2L, 3L);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Long());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of long primitives after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForLongPrimitiveInput() {
        List<Long> testData = Arrays.asList(1L, 2L, 3L);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Long());
        Assertions.assertEquals((int)33, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 33 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripDoublePrimitiveInput() {
        List<Double> testData = Arrays.asList(1.0, 2.0, 3.0);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Double());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of double primitives after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForDoublePrimitiveInput() {
        List<Double> testData = Arrays.asList(1.0, 2.0, 3.0);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Double());
        Assertions.assertEquals((int)33, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 33 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripUUIDInput() {
        List<UUID> testData = Arrays.asList(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID());
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.UUID());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of UUID after serialization and deserialization");
    }

    @Test
    public void listSerdeSerializerShouldReturnByteArrayOfFixedSizeForUUIDInput() {
        List<UUID> testData = Arrays.asList(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID());
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.UUID());
        Assertions.assertEquals((int)117, (int)listSerde.serializer().serialize("testTopic", testData).length, (String)"Should get length of 117 bytes after serialization");
    }

    @Test
    public void listSerdeShouldRoundtripNonPrimitiveInput() {
        List<String> testData = Arrays.asList("A", "B", "C");
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.String());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of strings list after serialization and deserialization");
    }

    @Test
    public void listSerdeShouldRoundtripPrimitiveInputWithNullEntries() {
        List<Integer> testData = Arrays.asList(1, null, 3);
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.Integer());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of integer primitives with null entries after serialization and deserialization");
    }

    @Test
    public void listSerdeShouldRoundtripNonPrimitiveInputWithNullEntries() {
        List<String> testData = Arrays.asList("A", null, "C");
        Serde listSerde = Serdes.ListSerde(ArrayList.class, (Serde)Serdes.String());
        Assertions.assertEquals(testData, (Object)listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)), (String)"Should get the original collection of strings list with null entries after serialization and deserialization");
    }

    @Test
    public void listSerdeShouldReturnLinkedList() {
        LinkedList testData = new LinkedList();
        Serde listSerde = Serdes.ListSerde(LinkedList.class, (Serde)Serdes.Integer());
        Assertions.assertTrue((boolean)(listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)) instanceof LinkedList), (String)"Should return List instance of type LinkedList");
    }

    @Test
    public void listSerdeShouldReturnStack() {
        Stack testData = new Stack();
        Serde listSerde = Serdes.ListSerde(Stack.class, (Serde)Serdes.Integer());
        Assertions.assertTrue((boolean)(listSerde.deserializer().deserialize("testTopic", listSerde.serializer().serialize("testTopic", testData)) instanceof Stack), (String)"Should return List instance of type Stack");
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnZeroBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[0]);
            });
        }
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnTooFewBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[3]);
            });
        }
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnTooManyBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[5]);
            });
        }
    }

    @Test
    public void floatSerdeShouldPreserveNaNValues() {
        int someNaNAsIntBits = 2139095041;
        float someNaN = Float.intBitsToFloat(someNaNAsIntBits);
        int anotherNaNAsIntBits = 2139095042;
        float anotherNaN = Float.intBitsToFloat(anotherNaNAsIntBits);
        try (Serde serde = Serdes.Float();){
            Float roundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(someNaN)));
            Assertions.assertEquals((int)someNaNAsIntBits, (int)Float.floatToRawIntBits(roundtrip.floatValue()));
            Float otherRoundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(anotherNaN)));
            Assertions.assertEquals((int)anotherNaNAsIntBits, (int)Float.floatToRawIntBits(otherRoundtrip.floatValue()));
        }
    }

    @Test
    public void testSerializeVoid() {
        try (Serde serde = Serdes.Void();){
            serde.serializer().serialize("testTopic", null);
        }
    }

    @Test
    public void testDeserializeVoid() {
        try (Serde serde = Serdes.Void();){
            serde.deserializer().deserialize("testTopic", null);
        }
    }

    @Test
    public void voidDeserializerShouldThrowOnNotNullValues() {
        try (Serde serde = Serdes.Void();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                Void cfr_ignored_0 = (Void)serde.deserializer().deserialize("testTopic", new byte[5]);
            });
        }
    }

    @Test
    public void stringDeserializerSupportByteBuffer() {
        String data = "Hello, ByteBuffer!";
        try (Serde serde = Serdes.String();){
            Serializer serializer = serde.serializer();
            Deserializer deserializer = serde.deserializer();
            byte[] serializedBytes = serializer.serialize("testTopic", (Object)"Hello, ByteBuffer!");
            ByteBuffer heapBuff = ByteBuffer.allocate(serializedBytes.length << 1).put(serializedBytes);
            heapBuff.flip();
            Assertions.assertEquals((Object)"Hello, ByteBuffer!", (Object)deserializer.deserialize("testTopic", null, heapBuff));
            ByteBuffer directBuff = ByteBuffer.allocateDirect(serializedBytes.length << 2).put(serializedBytes);
            directBuff.flip();
            Assertions.assertEquals((Object)"Hello, ByteBuffer!", (Object)deserializer.deserialize("testTopic", null, directBuff));
        }
    }

    private Serde<String> getStringSerde(String encoder) {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", encoder);
        Serializer serializer = Serdes.String().serializer();
        serializer.configure(serializerConfigs, true);
        HashMap<String, String> deserializerConfigs = new HashMap<String, String>();
        deserializerConfigs.put("key.deserializer.encoding", encoder);
        Deserializer deserializer = Serdes.String().deserializer();
        deserializer.configure(deserializerConfigs, true);
        return Serdes.serdeFrom((Serializer)serializer, (Deserializer)deserializer);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBooleanSerializer(Boolean dataToSerialize) {
        byte[] testData = new byte[]{(byte)(dataToSerialize != false ? 1 : 0)};
        Serde booleanSerde = Serdes.Boolean();
        Assertions.assertArrayEquals((byte[])testData, (byte[])booleanSerde.serializer().serialize("testTopic", (Object)dataToSerialize));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBooleanDeserializer(Boolean dataToDeserialize) {
        byte[] testData = new byte[]{(byte)(dataToDeserialize != false ? 1 : 0)};
        Serde booleanSerde = Serdes.Boolean();
        Assertions.assertEquals((Object)dataToDeserialize, (Object)booleanSerde.deserializer().deserialize("testTopic", testData));
    }

    @Test
    public void booleanDeserializerShouldThrowOnEmptyInput() {
        try (Serde serde = Serdes.Boolean();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Boolean cfr_ignored_0 = (Boolean)serde.deserializer().deserialize("testTopic", new byte[0]);
            });
        }
    }

    private class DummyClass {
        private DummyClass() {
        }
    }
}

