/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockShareConsumer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockShareConsumerTest {
    private final MockShareConsumer<String, String> consumer = new MockShareConsumer();

    @Test
    public void testSimpleMock() {
        this.consumer.subscribe(Collections.singleton("test"));
        Assertions.assertEquals((int)0, (int)this.consumer.poll(Duration.ZERO).count());
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 0L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key1", (Object)"value1", (Headers)new RecordHeaders(), Optional.empty());
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 1L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key2", (Object)"value2", (Headers)new RecordHeaders(), Optional.empty());
        this.consumer.addRecord(rec1);
        this.consumer.addRecord(rec2);
        ConsumerRecords recs = this.consumer.poll(Duration.ofMillis(1L));
        Iterator iter = recs.iterator();
        Assertions.assertEquals((Object)rec1, iter.next());
        Assertions.assertEquals((Object)rec2, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }
}

