/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeEvent;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ApplicationEventProcessorTest {
    private final CommitRequestManager commitRequestManager = (CommitRequestManager)Mockito.mock(CommitRequestManager.class);
    private final HeartbeatRequestManager heartbeatRequestManager = (HeartbeatRequestManager)Mockito.mock(HeartbeatRequestManager.class);
    private final MembershipManager membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
    private final SubscriptionState subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
    private ApplicationEventProcessor processor;

    private void setupProcessor(boolean withGroupId) {
        RequestManagers requestManagers = new RequestManagers(new LogContext(), (OffsetsRequestManager)Mockito.mock(OffsetsRequestManager.class), (TopicMetadataRequestManager)Mockito.mock(TopicMetadataRequestManager.class), (FetchRequestManager)Mockito.mock(FetchRequestManager.class), withGroupId ? Optional.of(Mockito.mock(CoordinatorRequestManager.class)) : Optional.empty(), withGroupId ? Optional.of(this.commitRequestManager) : Optional.empty(), withGroupId ? Optional.of(this.heartbeatRequestManager) : Optional.empty(), withGroupId ? Optional.of(this.membershipManager) : Optional.empty());
        this.processor = new ApplicationEventProcessor(new LogContext(), requestManagers, (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class), this.subscriptionState);
    }

    @Test
    public void testPrepClosingCommitEvents() {
        this.setupProcessor(true);
        List<NetworkClientDelegate.UnsentRequest> results = this.mockCommitResults();
        ((CommitRequestManager)Mockito.doReturn((Object)new NetworkClientDelegate.PollResult(100L, results)).when((Object)this.commitRequestManager)).pollOnClose();
        this.processor.process((ApplicationEvent)new CommitOnCloseEvent());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager)).signalClose();
    }

    @Test
    public void testProcessUnsubscribeEventWithGroupId() {
        this.setupProcessor(true);
        Mockito.when((Object)this.heartbeatRequestManager.membershipManager()).thenReturn((Object)this.membershipManager);
        Mockito.when((Object)this.membershipManager.leaveGroup()).thenReturn(CompletableFuture.completedFuture(null));
        this.processor.process((ApplicationEvent)new UnsubscribeEvent(0L));
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).leaveGroup();
    }

    @Test
    public void testProcessUnsubscribeEventWithoutGroupId() {
        this.setupProcessor(false);
        this.processor.process((ApplicationEvent)new UnsubscribeEvent(0L));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
    }

    private List<NetworkClientDelegate.UnsentRequest> mockCommitResults() {
        return Collections.singletonList(Mockito.mock(NetworkClientDelegate.UnsentRequest.class));
    }
}

