/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlattenedIteratorTest {
    @Test
    public void testNestedLists() {
        List<List> list = Arrays.asList(Arrays.asList("foo", "a", "bc"), Collections.singletonList("ddddd"), Arrays.asList("", "bar2", "baz45"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(list.stream().flatMap(Collection::stream).collect(Collectors.toList()), flattened);
        ArrayList flattened2 = new ArrayList();
        flattenedIterable.forEach(flattened2::add);
        Assertions.assertEquals(flattened, flattened2);
    }

    @Test
    public void testEmptyList() {
        List list = Collections.emptyList();
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(Collections.emptyList(), flattened);
    }

    @Test
    public void testNestedSingleEmptyList() {
        List list = Collections.singletonList(Collections.emptyList());
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(Collections.emptyList(), flattened);
    }

    @Test
    public void testEmptyListFollowedByNonEmpty() {
        List<List> list = Arrays.asList(Collections.emptyList(), Arrays.asList("boo", "b", "de"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(list.stream().flatMap(Collection::stream).collect(Collectors.toList()), flattened);
    }

    @Test
    public void testEmptyListInBetweenNonEmpty() {
        List<List> list = Arrays.asList(Collections.singletonList("aadwdwdw"), Collections.emptyList(), Arrays.asList("ee", "aa", "dd"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(list.stream().flatMap(Collection::stream).collect(Collectors.toList()), flattened);
    }

    @Test
    public void testEmptyListAtTheEnd() {
        List<List> list = Arrays.asList(Arrays.asList("ee", "dd"), Collections.singletonList("e"), Collections.emptyList());
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), List::iterator);
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assertions.assertEquals(list.stream().flatMap(Collection::stream).collect(Collectors.toList()), flattened);
    }
}

