/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;

public class Consumer
extends Thread {
    private final ConsumerConnector consumer = kafka.consumer.Consumer.createJavaConsumerConnector((ConsumerConfig)Consumer.createConsumerConfig());
    private final String topic;

    public Consumer(String topic) {
        this.topic = topic;
    }

    private static ConsumerConfig createConsumerConfig() {
        Properties props = new Properties();
        props.put("zookeeper.connect", "127.0.0.1:2181");
        props.put("group.id", "group1");
        props.put("zookeeper.session.timeout.ms", "400");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        return new ConsumerConfig(props);
    }

    @Override
    public void run() {
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(this.topic, new Integer(1));
        Map consumerMap = this.consumer.createMessageStreams(topicCountMap);
        KafkaStream stream = (KafkaStream)((List)consumerMap.get(this.topic)).get(0);
        ConsumerIterator it = stream.iterator();
        while (it.hasNext()) {
            System.out.println(new String((byte[])it.next().message()));
        }
    }
}

