/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.examples.Producer;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;

public class SimpleConsumerDemo {
    private static void printMessages(ByteBufferMessageSet messageSet) throws UnsupportedEncodingException {
        for (MessageAndOffset messageAndOffset : messageSet) {
            ByteBuffer payload = messageAndOffset.message().payload();
            byte[] bytes = new byte[payload.limit()];
            payload.get(bytes);
            System.out.println(new String(bytes, "UTF-8"));
        }
    }

    private static void generateData() {
        Producer producer2 = new Producer("topic2");
        producer2.start();
        Producer producer3 = new Producer("topic3");
        producer3.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleConsumerDemo.generateData();
        SimpleConsumer simpleConsumer = new SimpleConsumer("localhost", 9092, 100000, 65536, "SimpleConsumerDemoClient");
        System.out.println("Testing single fetch");
        FetchRequest req = new FetchRequestBuilder().clientId("SimpleConsumerDemoClient").addFetch("topic2", 0, 0L, 100).build();
        FetchResponse fetchResponse = simpleConsumer.fetch(req);
        SimpleConsumerDemo.printMessages(fetchResponse.messageSet("topic2", 0));
        System.out.println("Testing single multi-fetch");
        HashMap<String, List<Integer>> topicMap = new HashMap<String, List<Integer>>(){
            {
                this.put("topic2", new ArrayList<Integer>(){
                    {
                        this.add(0);
                    }
                });
                this.put("topic3", new ArrayList<Integer>(){
                    {
                        this.add(0);
                    }
                });
            }
        };
        req = new FetchRequestBuilder().clientId("SimpleConsumerDemoClient").addFetch("topic2", 0, 0L, 100).addFetch("topic3", 0, 0L, 100).build();
        fetchResponse = simpleConsumer.fetch(req);
        int fetchReq = 0;
        for (Map.Entry entry : topicMap.entrySet()) {
            String topic = (String)entry.getKey();
            for (Integer offset : (List)entry.getValue()) {
                System.out.println("Response from fetch request no: " + ++fetchReq);
                SimpleConsumerDemo.printMessages(fetchResponse.messageSet(topic, offset.intValue()));
            }
        }
    }
}

