/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public class ConsumerGroup
implements Group {
    private final SnapshotRegistry snapshotRegistry;
    private final String groupId;
    private final TimelineObject<ConsumerGroupState> state;
    private final TimelineInteger groupEpoch;
    private final TimelineHashMap<String, ConsumerGroupMember> members;
    private final TimelineHashMap<String, Integer> serverAssignors;
    private final TimelineHashMap<String, Integer> subscribedTopicNames;
    private final TimelineHashMap<String, TopicMetadata> subscribedTopicMetadata;
    private final TimelineInteger targetAssignmentEpoch;
    private final TimelineHashMap<String, Assignment> targetAssignment;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, Integer>> currentPartitionEpoch;
    private DeadlineAndEpoch metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;

    public ConsumerGroup(SnapshotRegistry snapshotRegistry, String groupId) {
        this.snapshotRegistry = Objects.requireNonNull(snapshotRegistry);
        this.groupId = Objects.requireNonNull(groupId);
        this.state = new TimelineObject(snapshotRegistry, (Object)ConsumerGroupState.EMPTY);
        this.groupEpoch = new TimelineInteger(snapshotRegistry);
        this.members = new TimelineHashMap(snapshotRegistry, 0);
        this.serverAssignors = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicNames = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicMetadata = new TimelineHashMap(snapshotRegistry, 0);
        this.targetAssignmentEpoch = new TimelineInteger(snapshotRegistry);
        this.targetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.currentPartitionEpoch = new TimelineHashMap(snapshotRegistry, 0);
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.CONSUMER;
    }

    @Override
    public String stateAsString() {
        return ((ConsumerGroupState)((Object)this.state.get())).toString();
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public ConsumerGroupState state() {
        return (ConsumerGroupState)((Object)this.state.get());
    }

    public int groupEpoch() {
        return this.groupEpoch.get();
    }

    public void setGroupEpoch(int groupEpoch) {
        this.groupEpoch.set(groupEpoch);
        this.maybeUpdateGroupState();
    }

    public int assignmentEpoch() {
        return this.targetAssignmentEpoch.get();
    }

    public void setTargetAssignmentEpoch(int targetAssignmentEpoch) {
        this.targetAssignmentEpoch.set(targetAssignmentEpoch);
        this.maybeUpdateGroupState();
    }

    public ConsumerGroupMember getOrMaybeCreateMember(String memberId, boolean createIfNotExists) {
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId);
        if (member == null) {
            if (!createIfNotExists) {
                throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
            }
            member = new ConsumerGroupMember.Builder(memberId).build();
            this.members.put((Object)memberId, (Object)member);
        }
        return member;
    }

    public void updateMember(ConsumerGroupMember newMember) {
        if (newMember == null) {
            throw new IllegalArgumentException("newMember cannot be null.");
        }
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.put((Object)newMember.memberId(), (Object)newMember);
        this.maybeUpdateSubscribedTopicNames(oldMember, newMember);
        this.maybeUpdateServerAssignors(oldMember, newMember);
        this.maybeUpdatePartitionEpoch(oldMember, newMember);
        this.maybeUpdateGroupState();
    }

    public void removeMember(String memberId) {
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.remove((Object)memberId);
        this.maybeUpdateSubscribedTopicNames(oldMember, null);
        this.maybeUpdateServerAssignors(oldMember, null);
        this.maybeRemovePartitionEpoch(oldMember);
        this.maybeUpdateGroupState();
    }

    public boolean hasMember(String memberId) {
        return this.members.containsKey((Object)memberId);
    }

    public int numMembers() {
        return this.members.size();
    }

    public Map<String, ConsumerGroupMember> members() {
        return Collections.unmodifiableMap(this.members);
    }

    public Set<String> subscribedTopicNames() {
        return Collections.unmodifiableSet(this.subscribedTopicNames.keySet());
    }

    public Assignment targetAssignment(String memberId) {
        return (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY);
    }

    public void updateTargetAssignment(String memberId, Assignment newTargetAssignment) {
        this.targetAssignment.put((Object)memberId, (Object)newTargetAssignment);
    }

    public void removeTargetAssignment(String memberId) {
        this.targetAssignment.remove((Object)memberId);
    }

    public Map<String, Assignment> targetAssignment() {
        return Collections.unmodifiableMap(this.targetAssignment);
    }

    public int currentPartitionEpoch(Uuid topicId, int partitionId) {
        Map partitions = (Map)this.currentPartitionEpoch.get((Object)topicId);
        if (partitions == null) {
            return -1;
        }
        return partitions.getOrDefault(partitionId, -1);
    }

    public Optional<String> computePreferredServerAssignor(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>((Map<String, Integer>)this.serverAssignors);
        ConsumerGroup.maybeUpdateServerAssignors(counts, oldMember, newMember);
        return counts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Optional<String> preferredServerAssignor() {
        return this.serverAssignors.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Map<String, TopicMetadata> subscriptionMetadata() {
        return Collections.unmodifiableMap(this.subscribedTopicMetadata);
    }

    public void setSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscribedTopicMetadata.clear();
        this.subscribedTopicMetadata.putAll(subscriptionMetadata);
    }

    public Map<String, TopicMetadata> computeSubscriptionMetadata(ConsumerGroupMember oldMember, ConsumerGroupMember newMember, TopicsImage topicsImage, ClusterImage clusterImage) {
        HashMap<String, Integer> subscribedTopicNames = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedTopicNames);
        ConsumerGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, oldMember, newMember);
        HashMap newSubscriptionMetadata = new HashMap(subscribedTopicNames.size());
        subscribedTopicNames.forEach((topicName, count) -> {
            TopicImage topicImage = topicsImage.getTopic(topicName);
            if (topicImage != null) {
                HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>();
                topicImage.partitions().forEach((partition, partitionRegistration) -> {
                    HashSet racks = new HashSet();
                    for (int replica : partitionRegistration.replicas) {
                        Optional rackOptional = clusterImage.broker(replica).rack();
                        rackOptional.ifPresent(racks::add);
                    }
                    if (!racks.isEmpty()) {
                        partitionRacks.put((Integer)partition, racks);
                    }
                });
                newSubscriptionMetadata.put(topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size(), partitionRacks));
            }
        });
        return Collections.unmodifiableMap(newSubscriptionMetadata);
    }

    public void setMetadataRefreshDeadline(long deadlineMs, int groupEpoch) {
        this.metadataRefreshDeadline = new DeadlineAndEpoch(deadlineMs, groupEpoch);
    }

    public void requestMetadataRefresh() {
        this.metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;
    }

    public boolean hasMetadataExpired(long currentTimeMs) {
        return currentTimeMs >= this.metadataRefreshDeadline.deadlineMs || this.groupEpoch() < this.metadataRefreshDeadline.epoch;
    }

    public DeadlineAndEpoch metadataRefreshDeadline() {
        return this.metadataRefreshDeadline;
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int memberEpoch) throws UnknownMemberIdException, StaleMemberEpochException {
        if (memberEpoch < 0 && this.members().isEmpty()) {
            return;
        }
        ConsumerGroupMember member = this.getOrMaybeCreateMember(memberId, false);
        if (memberEpoch != member.memberEpoch()) {
            throw Errors.STALE_MEMBER_EPOCH.exception();
        }
    }

    private void maybeUpdateGroupState() {
        if (this.members.isEmpty()) {
            this.state.set((Object)ConsumerGroupState.EMPTY);
        } else if (this.groupEpoch.get() > this.targetAssignmentEpoch.get()) {
            this.state.set((Object)ConsumerGroupState.ASSIGNING);
        } else {
            for (ConsumerGroupMember member : this.members.values()) {
                if (member.targetMemberEpoch() == this.targetAssignmentEpoch.get() && member.state() == ConsumerGroupMember.MemberState.STABLE) continue;
                this.state.set((Object)ConsumerGroupState.RECONCILING);
                return;
            }
            this.state.set((Object)ConsumerGroupState.STABLE);
        }
    }

    private void maybeUpdateServerAssignors(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateServerAssignors(this.serverAssignors, oldMember, newMember);
    }

    private static void maybeUpdateServerAssignors(Map<String, Integer> serverAssignorCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, ConsumerGroup::decValue));
        }
        if (newMember != null) {
            newMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, ConsumerGroup::incValue));
        }
    }

    private void maybeUpdateSubscribedTopicNames(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateSubscribedTopicNames(this.subscribedTopicNames, oldMember, newMember);
    }

    private static void maybeUpdateSubscribedTopicNames(Map<String, Integer> subscribedTopicCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, ConsumerGroup::decValue));
        }
        if (newMember != null) {
            newMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, ConsumerGroup::incValue));
        }
    }

    private void maybeUpdatePartitionEpoch(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember == null) {
            this.addPartitionEpochs(newMember.assignedPartitions(), newMember.memberEpoch());
            this.addPartitionEpochs(newMember.partitionsPendingRevocation(), newMember.memberEpoch());
        } else {
            if (!oldMember.assignedPartitions().equals(newMember.assignedPartitions())) {
                this.removePartitionEpochs(oldMember.assignedPartitions());
                this.addPartitionEpochs(newMember.assignedPartitions(), newMember.memberEpoch());
            }
            if (!oldMember.partitionsPendingRevocation().equals(newMember.partitionsPendingRevocation())) {
                this.removePartitionEpochs(oldMember.partitionsPendingRevocation());
                this.addPartitionEpochs(newMember.partitionsPendingRevocation(), newMember.memberEpoch());
            }
        }
    }

    private void maybeRemovePartitionEpoch(ConsumerGroupMember oldMember) {
        if (oldMember != null) {
            this.removePartitionEpochs(oldMember.assignedPartitions());
            this.removePartitionEpochs(oldMember.partitionsPendingRevocation());
        }
    }

    private void removePartitionEpochs(Map<Uuid, Set<Integer>> assignment) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull != null) {
                assignedPartitions.forEach(arg_0 -> ((TimelineHashMap)partitionsOrNull).remove(arg_0));
                if (partitionsOrNull.isEmpty()) {
                    return null;
                }
                return partitionsOrNull;
            }
            return null;
        }));
    }

    private void addPartitionEpochs(Map<Uuid, Set<Integer>> assignment, int epoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull == null) {
                partitionsOrNull = new TimelineHashMap(this.snapshotRegistry, assignedPartitions.size());
            }
            for (Integer partitionId : assignedPartitions) {
                partitionsOrNull.put((Object)partitionId, (Object)epoch);
            }
            return partitionsOrNull;
        }));
    }

    private static Integer decValue(String key, Integer value) {
        if (value == null) {
            return null;
        }
        return value == 1 ? null : Integer.valueOf(value - 1);
    }

    private static Integer incValue(String key, Integer value) {
        return value == null ? 1 : value + 1;
    }

    public static class DeadlineAndEpoch {
        static final DeadlineAndEpoch EMPTY = new DeadlineAndEpoch(0L, 0);
        public final long deadlineMs;
        public final int epoch;

        DeadlineAndEpoch(long deadlineMs, int epoch) {
            this.deadlineMs = deadlineMs;
            this.epoch = epoch;
        }
    }

    public static enum ConsumerGroupState {
        EMPTY("empty"),
        ASSIGNING("assigning"),
        RECONCILING("reconciling"),
        STABLE("stable"),
        DEAD("dead");

        private final String name;

        private ConsumerGroupState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

