/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue.*;

public class ConsumerGroupCurrentMemberAssignmentValueJsonConverter {
    public static ConsumerGroupCurrentMemberAssignmentValue read(JsonNode _node, short _version) {
        ConsumerGroupCurrentMemberAssignmentValue _object = new ConsumerGroupCurrentMemberAssignmentValue();
        JsonNode _memberEpochNode = _node.get("memberEpoch");
        if (_memberEpochNode == null) {
            throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue: unable to locate field 'memberEpoch', which is mandatory in version " + _version);
        } else {
            _object.memberEpoch = MessageUtil.jsonNodeToInt(_memberEpochNode, "ConsumerGroupCurrentMemberAssignmentValue");
        }
        JsonNode _previousMemberEpochNode = _node.get("previousMemberEpoch");
        if (_previousMemberEpochNode == null) {
            throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue: unable to locate field 'previousMemberEpoch', which is mandatory in version " + _version);
        } else {
            _object.previousMemberEpoch = MessageUtil.jsonNodeToInt(_previousMemberEpochNode, "ConsumerGroupCurrentMemberAssignmentValue");
        }
        JsonNode _stateNode = _node.get("state");
        if (_stateNode == null) {
            throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue: unable to locate field 'state', which is mandatory in version " + _version);
        } else {
            _object.state = MessageUtil.jsonNodeToByte(_stateNode, "ConsumerGroupCurrentMemberAssignmentValue");
        }
        JsonNode _assignedPartitionsNode = _node.get("assignedPartitions");
        if (_assignedPartitionsNode == null) {
            throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue: unable to locate field 'assignedPartitions', which is mandatory in version " + _version);
        } else {
            if (!_assignedPartitionsNode.isArray()) {
                throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<TopicPartitions> _collection = new ArrayList<TopicPartitions>(_assignedPartitionsNode.size());
            _object.assignedPartitions = _collection;
            for (JsonNode _element : _assignedPartitionsNode) {
                _collection.add(TopicPartitionsJsonConverter.read(_element, _version));
            }
        }
        JsonNode _partitionsPendingRevocationNode = _node.get("partitionsPendingRevocation");
        if (_partitionsPendingRevocationNode == null) {
            throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue: unable to locate field 'partitionsPendingRevocation', which is mandatory in version " + _version);
        } else {
            if (!_partitionsPendingRevocationNode.isArray()) {
                throw new RuntimeException("ConsumerGroupCurrentMemberAssignmentValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<TopicPartitions> _collection = new ArrayList<TopicPartitions>(_partitionsPendingRevocationNode.size());
            _object.partitionsPendingRevocation = _collection;
            for (JsonNode _element : _partitionsPendingRevocationNode) {
                _collection.add(TopicPartitionsJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(ConsumerGroupCurrentMemberAssignmentValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("memberEpoch", new IntNode(_object.memberEpoch));
        _node.set("previousMemberEpoch", new IntNode(_object.previousMemberEpoch));
        _node.set("state", new ShortNode(_object.state));
        ArrayNode _assignedPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
        for (TopicPartitions _element : _object.assignedPartitions) {
            _assignedPartitionsArray.add(TopicPartitionsJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("assignedPartitions", _assignedPartitionsArray);
        ArrayNode _partitionsPendingRevocationArray = new ArrayNode(JsonNodeFactory.instance);
        for (TopicPartitions _element : _object.partitionsPendingRevocation) {
            _partitionsPendingRevocationArray.add(TopicPartitionsJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("partitionsPendingRevocation", _partitionsPendingRevocationArray);
        return _node;
    }
    public static JsonNode write(ConsumerGroupCurrentMemberAssignmentValue _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class TopicPartitionsJsonConverter {
        public static TopicPartitions read(JsonNode _node, short _version) {
            TopicPartitions _object = new TopicPartitions();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicPartitions: unable to locate field 'topicId', which is mandatory in version " + _version);
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("TopicPartitions expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicPartitions: unable to locate field 'partitions', which is mandatory in version " + _version);
            } else {
                if (!_partitionsNode.isArray()) {
                    throw new RuntimeException("TopicPartitions expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
                _object.partitions = _collection;
                for (JsonNode _element : _partitionsNode) {
                    _collection.add(MessageUtil.jsonNodeToInt(_element, "TopicPartitions element"));
                }
            }
            return _object;
        }
        public static JsonNode write(TopicPartitions _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add(new IntNode(_element));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }
        public static JsonNode write(TopicPartitions _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
