/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class PartitionChangeBuilder {
    private final PartitionRegistration partition;
    private final Uuid topicId;
    private final int partitionId;
    private final Function<Integer, Boolean> isAcceptableLeader;
    private final Supplier<Boolean> uncleanElectionOk;
    private List<Integer> targetIsr;
    private List<Integer> targetReplicas;
    private List<Integer> targetRemoving;
    private List<Integer> targetAdding;
    private boolean alwaysElectPreferredIfPossible;

    public static boolean changeRecordIsNoOp(PartitionChangeRecord record) {
        if (record.isr() != null) {
            return false;
        }
        if (record.leader() != -2) {
            return false;
        }
        if (record.replicas() != null) {
            return false;
        }
        if (record.removingReplicas() != null) {
            return false;
        }
        return record.addingReplicas() == null;
    }

    public PartitionChangeBuilder(PartitionRegistration partition, Uuid topicId, int partitionId, Function<Integer, Boolean> isAcceptableLeader, Supplier<Boolean> uncleanElectionOk) {
        this.partition = partition;
        this.topicId = topicId;
        this.partitionId = partitionId;
        this.isAcceptableLeader = isAcceptableLeader;
        this.uncleanElectionOk = uncleanElectionOk;
        this.targetIsr = Replicas.toList(partition.isr);
        this.targetReplicas = Replicas.toList(partition.replicas);
        this.targetRemoving = Replicas.toList(partition.removingReplicas);
        this.targetAdding = Replicas.toList(partition.addingReplicas);
        this.alwaysElectPreferredIfPossible = false;
    }

    public PartitionChangeBuilder setTargetIsr(List<Integer> targetIsr) {
        this.targetIsr = targetIsr;
        return this;
    }

    public PartitionChangeBuilder setTargetReplicas(List<Integer> targetReplicas) {
        this.targetReplicas = targetReplicas;
        return this;
    }

    public PartitionChangeBuilder setAlwaysElectPreferredIfPossible(boolean alwaysElectPreferredIfPossible) {
        this.alwaysElectPreferredIfPossible = alwaysElectPreferredIfPossible;
        return this;
    }

    public PartitionChangeBuilder setTargetRemoving(List<Integer> targetRemoving) {
        this.targetRemoving = targetRemoving;
        return this;
    }

    public PartitionChangeBuilder setTargetAdding(List<Integer> targetAdding) {
        this.targetAdding = targetAdding;
        return this;
    }

    boolean shouldTryElection() {
        if (!this.targetIsr.contains(this.partition.leader)) {
            return true;
        }
        return this.alwaysElectPreferredIfPossible && !this.partition.hasPreferredLeader();
    }

    private void tryElection(PartitionChangeRecord record) {
        BestLeader bestLeader = new BestLeader();
        if (bestLeader.node != this.partition.leader) {
            record.setLeader(bestLeader.node);
            if (bestLeader.unclean) {
                record.setIsr(Collections.singletonList(bestLeader.node));
            }
        }
    }

    void triggerLeaderEpochBumpIfNeeded(PartitionChangeRecord record) {
        if (!(record.leader() != -2 || Replicas.contains(this.targetIsr, this.partition.isr) && Replicas.contains(this.targetReplicas, this.partition.replicas))) {
            record.setLeader(this.partition.leader);
        }
    }

    private void completeReassignmentIfNeeded() {
        if (this.targetRemoving.isEmpty() && this.targetAdding.isEmpty()) {
            return;
        }
        List<Integer> newTargetIsr = this.targetIsr;
        List<Integer> newTargetReplicas = this.targetReplicas;
        if (!this.targetRemoving.isEmpty()) {
            newTargetIsr = new ArrayList<Integer>(this.targetIsr.size());
            for (int replica : this.targetIsr) {
                if (this.targetRemoving.contains(replica)) continue;
                newTargetIsr.add(replica);
            }
            if (newTargetIsr.isEmpty()) {
                return;
            }
            newTargetReplicas = new ArrayList<Integer>(this.targetReplicas.size());
            for (int replica : this.targetReplicas) {
                if (this.targetRemoving.contains(replica)) continue;
                newTargetReplicas.add(replica);
            }
            if (newTargetReplicas.isEmpty()) {
                return;
            }
        }
        for (int replica : this.targetAdding) {
            if (newTargetIsr.contains(replica)) continue;
            return;
        }
        this.targetIsr = newTargetIsr;
        this.targetReplicas = newTargetReplicas;
        this.targetRemoving = Collections.emptyList();
        this.targetAdding = Collections.emptyList();
    }

    public Optional<ApiMessageAndVersion> build() {
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(this.topicId).setPartitionId(this.partitionId);
        this.completeReassignmentIfNeeded();
        if (this.shouldTryElection()) {
            this.tryElection(record);
        }
        this.triggerLeaderEpochBumpIfNeeded(record);
        if (!this.targetIsr.isEmpty() && !this.targetIsr.equals(Replicas.toList(this.partition.isr))) {
            record.setIsr(this.targetIsr);
        }
        if (!this.targetReplicas.isEmpty() && !this.targetReplicas.equals(Replicas.toList(this.partition.replicas))) {
            record.setReplicas(this.targetReplicas);
        }
        if (!this.targetRemoving.equals(Replicas.toList(this.partition.removingReplicas))) {
            record.setRemovingReplicas(this.targetRemoving);
        }
        if (!this.targetAdding.equals(Replicas.toList(this.partition.addingReplicas))) {
            record.setAddingReplicas(this.targetAdding);
        }
        if (PartitionChangeBuilder.changeRecordIsNoOp(record)) {
            return Optional.empty();
        }
        return Optional.of(new ApiMessageAndVersion((ApiMessage)record, MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
    }

    class BestLeader {
        final int node;
        final boolean unclean;

        BestLeader() {
            int replica;
            Iterator iterator = PartitionChangeBuilder.this.targetReplicas.iterator();
            while (iterator.hasNext()) {
                replica = (Integer)iterator.next();
                if (!PartitionChangeBuilder.this.targetIsr.contains(replica) || !((Boolean)PartitionChangeBuilder.this.isAcceptableLeader.apply(replica)).booleanValue()) continue;
                this.node = replica;
                this.unclean = false;
                return;
            }
            if (((Boolean)PartitionChangeBuilder.this.uncleanElectionOk.get()).booleanValue()) {
                iterator = PartitionChangeBuilder.this.targetReplicas.iterator();
                while (iterator.hasNext()) {
                    replica = (Integer)iterator.next();
                    if (!((Boolean)PartitionChangeBuilder.this.isAcceptableLeader.apply(replica)).booleanValue()) continue;
                    this.node = replica;
                    this.unclean = true;
                    return;
                }
            }
            this.node = -1;
            this.unclean = false;
        }
    }
}

