/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotaImage;
import org.apache.kafka.image.ClientQuotasImage;

public final class ClientQuotasDelta {
    private final ClientQuotasImage image;
    private final Map<ClientQuotaEntity, ClientQuotaDelta> changes = new HashMap<ClientQuotaEntity, ClientQuotaDelta>();

    public ClientQuotasDelta(ClientQuotasImage image) {
        this.image = image;
    }

    public Map<ClientQuotaEntity, ClientQuotaDelta> changes() {
        return this.changes;
    }

    public void finishSnapshot() {
        for (Map.Entry<ClientQuotaEntity, ClientQuotaImage> entry : this.image.entities().entrySet()) {
            ClientQuotaEntity entity = entry.getKey();
            ClientQuotaImage quotaImage = entry.getValue();
            ClientQuotaDelta quotaDelta = this.changes.computeIfAbsent(entity, __ -> new ClientQuotaDelta(quotaImage));
            quotaDelta.finishSnapshot();
        }
    }

    public void replay(ClientQuotaRecord record) {
        ClientQuotaEntity entity = ClientQuotaImage.dataToEntity(record.entity());
        ClientQuotaDelta change = this.changes.computeIfAbsent(entity, __ -> new ClientQuotaDelta(this.image.entities().getOrDefault(entity, ClientQuotaImage.EMPTY)));
        change.replay(record);
    }

    public ClientQuotasImage apply() {
        ClientQuotaEntity entity;
        HashMap<ClientQuotaEntity, ClientQuotaImage> newEntities = new HashMap<ClientQuotaEntity, ClientQuotaImage>(this.image.entities().size());
        for (Map.Entry<ClientQuotaEntity, ClientQuotaImage> entry : this.image.entities().entrySet()) {
            entity = entry.getKey();
            ClientQuotaDelta change = this.changes.get(entity);
            if (change == null) {
                newEntities.put(entity, entry.getValue());
                continue;
            }
            ClientQuotaImage quotaImage = change.apply();
            if (quotaImage.isEmpty()) continue;
            newEntities.put(entity, quotaImage);
        }
        for (Map.Entry<ClientQuotaEntity, Object> entry : this.changes.entrySet()) {
            ClientQuotaImage quotaImage;
            entity = entry.getKey();
            if (newEntities.containsKey(entity) || (quotaImage = ((ClientQuotaDelta)entry.getValue()).apply()).isEmpty()) continue;
            newEntities.put(entity, quotaImage);
        }
        return new ClientQuotasImage(newEntities);
    }
}

