/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class QuorumControllerMetrics
implements AutoCloseable {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private final Optional<MetricsRegistry> registry;
    private volatile boolean active;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final Consumer<Long> eventQueueTimeUpdater;
    private final Consumer<Long> eventQueueProcessingTimeUpdater;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);

    private Consumer<Long> newHistogram(MetricName name, boolean biased) {
        if (this.registry.isPresent()) {
            Histogram histogram = this.registry.get().newHistogram(name, biased);
            return e -> histogram.update(e.longValue());
        }
        return __ -> {};
    }

    public QuorumControllerMetrics(Optional<MetricsRegistry> registry, final Time time) {
        this.registry = registry;
        this.active = false;
        registry.ifPresent(r -> r.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        }));
        this.eventQueueTimeUpdater = this.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTimeUpdater = this.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return time.milliseconds() - QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTimeUpdater.accept(durationMs);
    }

    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTimeUpdater.accept(durationMs);
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.addAndGet(1L);
    }

    public void setTimedOutHeartbeats(long heartbeats) {
        this.timedOutHeartbeats.set(heartbeats);
    }

    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(ACTIVE_CONTROLLER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

