/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.storage;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class ScramParser {
    static List<ApiMessageAndVersion> parse(List<String> arguments) throws Exception {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        for (String argument : arguments) {
            Map.Entry<ScramMechanism, String> entry = ScramParser.parsePerMechanismArgument(argument);
            PerMechanismData data = new PerMechanismData(entry.getKey(), entry.getValue());
            records.add(new ApiMessageAndVersion((ApiMessage)data.toRecord(), 0));
        }
        return records;
    }

    static Map.Entry<ScramMechanism, String> parsePerMechanismArgument(String input) {
        int equalsIndex = (input = input.trim()).indexOf(61);
        if (equalsIndex < 0) {
            throw new FormatterException("Failed to find equals sign in SCRAM argument '" + input + "'");
        }
        String mechanismString = input.substring(0, equalsIndex);
        String configString = input.substring(equalsIndex + 1);
        ScramMechanism mechanism = ScramMechanism.forMechanismName((String)mechanismString);
        if (mechanism == null) {
            throw new FormatterException("The add-scram mechanism " + mechanismString + " is not supported.");
        }
        if (!configString.startsWith("[")) {
            throw new FormatterException("Expected configuration string to start with [");
        }
        if (!configString.endsWith("]")) {
            throw new FormatterException("Expected configuration string to end with ]");
        }
        return new AbstractMap.SimpleImmutableEntry<ScramMechanism, String>(mechanism, configString.substring(1, configString.length() - 1));
    }

    static Map.Entry<String, String> splitTrimmedConfigStringComponent(String input) {
        int i;
        for (i = 0; i < input.length() && input.charAt(i) != '='; ++i) {
        }
        if (i == input.length()) {
            throw new FormatterException("No equals sign found in SCRAM component: " + input);
        }
        String value = input.substring(i + 1);
        if (value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(input.substring(0, i), value);
    }

    static final class PerMechanismData {
        private final ScramMechanism mechanism;
        private final String configuredName;
        private final Optional<byte[]> configuredSalt;
        private final OptionalInt configuredIterations;
        private final Optional<String> configuredPasswordString;
        private final Optional<byte[]> configuredSaltedPassword;

        PerMechanismData(ScramMechanism mechanism, String configuredName, Optional<byte[]> configuredSalt, OptionalInt configuredIterations, Optional<String> configuredPasswordString, Optional<byte[]> configuredSaltedPassword) {
            this.mechanism = mechanism;
            this.configuredName = configuredName;
            this.configuredSalt = configuredSalt;
            this.configuredIterations = configuredIterations;
            this.configuredPasswordString = configuredPasswordString;
            this.configuredSaltedPassword = configuredSaltedPassword;
        }

        PerMechanismData(ScramMechanism mechanism, String configString) {
            this.mechanism = mechanism;
            String[] configComponents = configString.split(",");
            TreeMap<String, String> components = new TreeMap<String, String>();
            for (String configComponent : configComponents) {
                Map.Entry<String, String> entry = ScramParser.splitTrimmedConfigStringComponent(configComponent);
                components.put(entry.getKey(), entry.getValue());
            }
            this.configuredName = (String)components.remove("name");
            if (this.configuredName == null) {
                throw new FormatterException("You must supply 'name' to add-scram");
            }
            String saltString = (String)components.remove("salt");
            if (saltString == null) {
                this.configuredSalt = Optional.empty();
            } else {
                try {
                    this.configuredSalt = Optional.of(Base64.getDecoder().decode(saltString));
                }
                catch (IllegalArgumentException e) {
                    throw new FormatterException("Failed to decode given salt: " + saltString, e);
                }
            }
            String iterationsString = (String)components.remove("iterations");
            if (iterationsString == null) {
                this.configuredIterations = OptionalInt.empty();
            } else {
                try {
                    this.configuredIterations = OptionalInt.of(Integer.parseInt(iterationsString));
                }
                catch (NumberFormatException e) {
                    throw new FormatterException("Failed to parse iterations count: " + iterationsString, e);
                }
            }
            String passwordString = (String)components.remove("password");
            String saltedPasswordString = (String)components.remove("saltedpassword");
            if (passwordString == null) {
                if (saltedPasswordString == null) {
                    throw new FormatterException("You must supply one of 'password' or 'saltedpassword' to add-scram");
                }
                if (!this.configuredSalt.isPresent()) {
                    throw new FormatterException("You must supply 'salt' with 'saltedpassword' to add-scram");
                }
                try {
                    this.configuredPasswordString = Optional.empty();
                    this.configuredSaltedPassword = Optional.of(Base64.getDecoder().decode(saltedPasswordString));
                }
                catch (IllegalArgumentException e) {
                    throw new FormatterException("Failed to decode given saltedPassword: " + saltedPasswordString, e);
                }
            } else {
                this.configuredPasswordString = Optional.of(passwordString);
                this.configuredSaltedPassword = Optional.empty();
            }
            if (!components.isEmpty()) {
                throw new FormatterException("Unknown SCRAM configurations: " + components.keySet().stream().collect(Collectors.joining(", ")));
            }
        }

        byte[] salt() throws Exception {
            if (this.configuredSalt.isPresent()) {
                return this.configuredSalt.get();
            }
            return new ScramFormatter(this.mechanism).secureRandomBytes();
        }

        int iterations() {
            if (this.configuredIterations.isPresent()) {
                return this.configuredIterations.getAsInt();
            }
            return 4096;
        }

        byte[] saltedPassword(byte[] salt, int iterations) throws Exception {
            if (this.configuredSaltedPassword.isPresent()) {
                return this.configuredSaltedPassword.get();
            }
            return new ScramFormatter(this.mechanism).saltedPassword(this.configuredPasswordString.get(), salt, iterations);
        }

        UserScramCredentialRecord toRecord() throws Exception {
            ScramFormatter formatter = new ScramFormatter(this.mechanism);
            byte[] salt = this.salt();
            int iterations = this.iterations();
            if (iterations < this.mechanism.minIterations()) {
                throw new FormatterException("The 'iterations' value must be >= " + this.mechanism.minIterations() + " for add-scram using " + this.mechanism);
            }
            if (iterations > this.mechanism.maxIterations()) {
                throw new FormatterException("The 'iterations' value must be <= " + this.mechanism.maxIterations() + " for add-scram using " + this.mechanism);
            }
            byte[] saltedPassword = this.saltedPassword(salt, iterations);
            return new UserScramCredentialRecord().setName(this.configuredName).setMechanism(this.mechanism.type()).setSalt(salt).setStoredKey(formatter.storedKey(formatter.clientKey(saltedPassword))).setServerKey(formatter.serverKey(saltedPassword)).setIterations(iterations);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(PerMechanismData.class)) {
                return false;
            }
            PerMechanismData other = (PerMechanismData)o;
            return this.mechanism.equals((Object)other.mechanism) && this.configuredName.equals(other.configuredName) && Arrays.equals(this.configuredSalt.orElseGet(() -> null), other.configuredSalt.orElseGet(() -> null)) && this.configuredIterations.equals(other.configuredIterations) && this.configuredPasswordString.equals(other.configuredPasswordString) && Arrays.equals(this.configuredSaltedPassword.orElseGet(() -> null), other.configuredSaltedPassword.orElseGet(() -> null));
        }

        public int hashCode() {
            return Objects.hash(this.mechanism, this.configuredName, this.configuredSalt, this.configuredIterations, this.configuredPasswordString, this.configuredSaltedPassword);
        }

        public String toString() {
            return "PerMechanismData(mechanism=" + this.mechanism + ", configuredName=" + this.configuredName + ", configuredSalt=" + this.configuredSalt.map(v -> Arrays.toString(v)) + ", configuredIterations=" + this.configuredIterations + ", configuredPasswordString=" + this.configuredPasswordString + ", configuredSaltedPassword=" + this.configuredSaltedPassword.map(v -> Arrays.toString(v)) + ")";
        }
    }
}

