/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.perf.ConsumerPerformance$;
import kafka.perf.ConsumerPerformance$ConsumerPerfConfig$;
import kafka.perf.ConsumerPerformance$ConsumerPerfThread$;
import kafka.perf.PerfConfig;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\t}q!B\u0001\u0003\u0011\u000b9\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0011\u0001XM\u001d4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!A\u0002\u0005\u000b\u0005\u0011\u0005\t\u0011#\u0002\f\u0005M\u0019uN\\:v[\u0016\u0014\b+\u001a:g_Jl\u0017M\\2f'\rIA\u0002\u0006\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011\u0015Y\u0012\u0002\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u001f\u0013\t\u0007I\u0011B\u0010\u0002\r1|wmZ3s+\u0005\u0001\u0003CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0015awn\u001a\u001bk\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0012#A\u0002'pO\u001e,'\u000f\u0003\u0004,\u0013\u0001\u0006I\u0001I\u0001\bY><w-\u001a:!\u0011\u0015i\u0013\u0002\"\u0001/\u0003\u0011i\u0017-\u001b8\u0015\u0005=\u0012\u0004CA\u000b1\u0013\t\tdC\u0001\u0003V]&$\b\"B\u001a-\u0001\u0004!\u0014\u0001B1sON\u00042!F\u001b8\u0013\t1dCA\u0003BeJ\f\u0017\u0010\u0005\u00029w9\u0011Q#O\u0005\u0003uY\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!H\u0006\u0004\t\u007f%!\t\u0011!A\u0001\u0001\n\u00112i\u001c8tk6,'\u000fU3sM\u000e{gNZ5h'\rq\u0014\t\u0006\t\u0003\u0011\tK!a\u0011\u0002\u0003\u0015A+'OZ\"p]\u001aLw\r\u0003\u00054}\t\u0005\t\u0015!\u00035\u0011\u0015Yb\b\"\u0001G)\t9\u0015\n\u0005\u0002I}5\t\u0011\u0002C\u00034\u000b\u0002\u0007A\u0007C\u0004L}\t\u0007I\u0011\u0001'\u0002\u0019i\\7i\u001c8oK\u000e$x\n\u001d;\u0016\u00035\u00032AT)8\u001b\u0005y%\"\u0001)\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002S\u001f\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDa\u0001\u0016 !\u0002\u0013i\u0015!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004W}\t\u0007I\u0011\u0001'\u0002\u0011Q|\u0007/[2PaRDa\u0001\u0017 !\u0002\u0013i\u0015!\u0003;pa&\u001cw\n\u001d;!\u0011\u001dQfH1A\u0005\u00021\u000b!b\u001a:pkBLEm\u00149u\u0011\u0019af\b)A\u0005\u001b\u0006YqM]8va&#w\n\u001d;!\u0011\u001dqfH1A\u0005\u0002}\u000bABZ3uG\"\u001c\u0016N_3PaR,\u0012\u0001\u0019\t\u0004\u001dF\u000b\u0007CA\u0007c\u0013\t\u0019gBA\u0004J]R,w-\u001a:\t\r\u0015t\u0004\u0015!\u0003a\u000351W\r^2i'&TXm\u00149uA!9qM\u0010b\u0001\n\u0003A\u0017a\u0006:fg\u0016$()Z4j]:LgnZ(gMN,Go\u00149u+\u0005I\u0007C\u0001(k\u0013\tYwJA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJDa!\u001c !\u0002\u0013I\u0017\u0001\u0007:fg\u0016$()Z4j]:LgnZ(gMN,Go\u00149uA!9qN\u0010b\u0001\n\u0003y\u0016aE:pG.,GOQ;gM\u0016\u00148+\u001b>f\u001fB$\bBB9?A\u0003%\u0001-\u0001\u000bt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K>\u0003H\u000f\t\u0005\bgz\u0012\r\u0011\"\u0001`\u00035qW/\u001c+ie\u0016\fGm](qi\"1QO\u0010Q\u0001\n\u0001\faB\\;n)\"\u0014X-\u00193t\u001fB$\b\u0005C\u0004x}\t\u0007I\u0011\u0001=\u0002\u000f=\u0004H/[8ogV\t\u0011\u0010\u0005\u0002Ou&\u00111p\u0014\u0002\n\u001fB$\u0018n\u001c8TKRDa!  !\u0002\u0013I\u0018\u0001C8qi&|gn\u001d\u0011\t\u0011}t$\u0019!C\u0001\u0003\u0003\tQ\u0001\u001d:paN,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u0011\u0003\u0011)H/\u001b7\n\t\u00055\u0011q\u0001\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002CA\t}\u0001\u0006I!a\u0001\u0002\rA\u0014x\u000e]:!\u0011%\t)B\u0010b\u0001\n\u0003\t9\"\u0001\bd_:\u001cX/\\3s\u0007>tg-[4\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A!\u0001\u0005d_:\u001cX/\\3s\u0013\u0011\t\u0019#!\b\u0003\u001d\r{gn];nKJ\u001cuN\u001c4jO\"A\u0011q\u0005 !\u0002\u0013\tI\"A\bd_:\u001cX/\\3s\u0007>tg-[4!\u0011%\tYC\u0010b\u0001\n\u0003\ti#\u0001\u0006ok6$\u0006N]3bIN,\"!a\f\u0011\u0007U\t\t$C\u0002\u00024Y\u00111!\u00138u\u0011!\t9D\u0010Q\u0001\n\u0005=\u0012a\u00038v[RC'/Z1eg\u0002B\u0011\"a\u000f?\u0005\u0004%\t!!\u0010\u0002\u000bQ|\u0007/[2\u0016\u0003]Bq!!\u0011?A\u0003%q'\u0001\u0004u_BL7\r\t\u0005\n\u0003\u000br$\u0019!C\u0001\u0003\u000f\n1B\\;n\u001b\u0016\u001c8/Y4fgV\u0011\u0011\u0011\n\t\u0004+\u0005-\u0013bAA'-\t!Aj\u001c8h\u0011!\t\tF\u0010Q\u0001\n\u0005%\u0013\u0001\u00048v[6+7o]1hKN\u0004\u0003\"CA+}\t\u0007I\u0011AA\u0017\u0003E\u0011X\r]8si&tw-\u00138uKJ4\u0018\r\u001c\u0005\t\u00033r\u0004\u0015!\u0003\u00020\u0005\u0011\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197!\u0011%\tiF\u0010b\u0001\n\u0003\ty&A\ttQ><H)\u001a;bS2,Gm\u0015;biN,\"!!\u0019\u0011\u0007U\t\u0019'C\u0002\u0002fY\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002jy\u0002\u000b\u0011BA1\u0003I\u0019\bn\\<EKR\f\u0017\u000e\\3e'R\fGo\u001d\u0011\t\u0013\u00055dH1A\u0005\u0002\u0005=\u0014A\u00033bi\u00164uN]7biV\u0011\u0011\u0011\u000f\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011q\u000f\t\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003w\n)H\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"A\u0011q\u0010 !\u0002\u0013\t\t(A\u0006eCR,gi\u001c:nCR\u0004\u0003\"CAB}\t\u0007I\u0011AA0\u0003)A\u0017\u000eZ3IK\u0006$WM\u001d\u0005\t\u0003\u000fs\u0004\u0015!\u0003\u0002b\u0005Y\u0001.\u001b3f\u0011\u0016\fG-\u001a:!\r)\tY)\u0003C\u0001\u0002\u0003\u0005\u0011Q\u0012\u0002\u0013\u0007>t7/^7feB+'O\u001a+ie\u0016\fGmE\u0003\u0002\n\u0006=E\u0003E\u0002\u000e\u0003#K1!a%\u000f\u0005\u0019!\u0006N]3bI\"Y\u0011qSAE\u0005\u0003\u0005\u000b\u0011BA\u0018\u0003!!\bN]3bI&#\u0007BCAN\u0003\u0013\u0013\t\u0011)A\u0005o\u0005!a.Y7f\u0011-\ty*!#\u0003\u0002\u0003\u0006I!!)\u0002\rM$(/Z1n!!\tY\"a)\u0002(\u0006\u001d\u0016\u0002BAS\u0003;\u00111bS1gW\u0006\u001cFO]3b[B!Q#NAU!\r)\u00121V\u0005\u0004\u0003[3\"\u0001\u0002\"zi\u0016D!\"!-\u0002\n\n\u0005\t\u0015!\u0003H\u0003\u0019\u0019wN\u001c4jO\"Y\u0011QWAE\u0005\u0003\u0005\u000b\u0011BA\\\u0003E!x\u000e^1m\u001b\u0016\u001c8/Y4fgJ+\u0017\r\u001a\t\u0005\u0003s\u000b\u0019-\u0004\u0002\u0002<*!\u0011QXA`\u0003\u0019\tGo\\7jG*!\u0011\u0011YA\u0004\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u000b\fYL\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD1\"!3\u0002\n\n\u0005\t\u0015!\u0003\u00028\u0006qAo\u001c;bY\nKH/Z:SK\u0006$\u0007bB\u000e\u0002\n\u0012\u0005\u0011Q\u001a\u000b\u000f\u0003\u001f\f\t.a5\u0002V\u0006]\u0017\u0011\\An!\rA\u0015\u0011\u0012\u0005\t\u0003/\u000bY\r1\u0001\u00020!9\u00111TAf\u0001\u00049\u0004\u0002CAP\u0003\u0017\u0004\r!!)\t\u000f\u0005E\u00161\u001aa\u0001\u000f\"A\u0011QWAf\u0001\u0004\t9\f\u0003\u0005\u0002J\u0006-\u0007\u0019AA\\\u0011)\ty.!#C\u0002\u0013%\u0011\u0011]\u0001\u000eg\",H\u000fZ8x]2\u000bGo\u00195\u0016\u0005\u0005\r\b\u0003BAs\u0003Ol!!a0\n\t\u0005%\u0018q\u0018\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011%\ti/!#!\u0002\u0013\t\u0019/\u0001\btQV$Hm\\<o\u0019\u0006$8\r\u001b\u0011\t\u0011\u0005E\u0018\u0011\u0012C\u0001\u0003g\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002_!A\u0011q_AE\t\u0003\n\u00190A\u0002sk:D\u0001\"a?\u0002\n\u0012%\u0011Q`\u0001\raJLg\u000e^'fgN\fw-\u001a\u000b\u0010_\u0005}(1\u0001B\u0004\u0005\u0017\u0011yAa\u0005\u0003\u0018!A!\u0011AA}\u0001\u0004\ty#\u0001\u0002jI\"A!QAA}\u0001\u0004\tI%A\u0005csR,7OU3bI\"A!\u0011BA}\u0001\u0004\tI%A\u0007mCN$()\u001f;fgJ+\u0017\r\u001a\u0005\t\u0005\u001b\tI\u00101\u0001\u0002J\u0005aQ.Z:tC\u001e,7OU3bI\"A!\u0011CA}\u0001\u0004\tI%\u0001\tmCN$X*Z:tC\u001e,7OU3bI\"A!QCA}\u0001\u0004\tI%A\u0004ti\u0006\u0014H/T:\t\u0011\te\u0011\u0011 a\u0001\u0003\u0013\nQ!\u001a8e\u001bND\u0001B!\b\u0002\n\u0012%\u00111_\u0001\u0011g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016\u0004")
public final class ConsumerPerformance {
    public static final void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfThread
    extends Thread
    implements ScalaObject {
        public final int kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId;
        private final KafkaStream<byte[], byte[]> stream;
        public final ConsumerPerfConfig kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final CountDownLatch shutdownLatch;

        private CountDownLatch shutdownLatch() {
            return this.shutdownLatch;
        }

        public void shutdown() {
            this.shutdownLatch().await();
        }

        @Override
        public void run() {
            LongRef longRef = new LongRef(0L);
            LongRef longRef2 = new LongRef(0L);
            long l = System.currentTimeMillis();
            LongRef longRef3 = new LongRef(l);
            LongRef longRef4 = new LongRef(0L);
            LongRef longRef5 = new LongRef(0L);
            try {
                this.stream.withFilter((Function1)new ConsumerPerfThread$$anonfun$run$1(this, longRef2)).foreach((Function1)new ConsumerPerfThread$$anonfun$run$2(this, longRef, longRef2, longRef3, longRef4, longRef5));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(longRef2.elem);
            this.totalBytesRead.addAndGet(longRef.elem);
            if (this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.showDetailedStats()) {
                this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$printMessage(this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId, longRef.elem, longRef4.elem, longRef2.elem, longRef5.elem, l, System.currentTimeMillis());
            }
            this.shutdownComplete();
        }

        public final void kafka$perf$ConsumerPerformance$ConsumerPerfThread$$printMessage(int n, long l, long l2, long l3, long l4, long l5, long l6) {
            long l7 = l6 - l5;
            double d = (double)l * 1.0 / (double)0x100000;
            double d2 = (double)(l - l2) * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %d, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.dateFormat().format(BoxesRunTime.boxToLong((long)l6)), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.consumerConfig().fetchMessageMaxBytes()), BoxesRunTime.boxToDouble((double)d), BoxesRunTime.boxToDouble((double)(1000.0 * (d2 / (double)l7))), BoxesRunTime.boxToLong((long)l3), BoxesRunTime.boxToDouble((double)((double)((l3 - l4) / l7) * 1000.0))})));
        }

        private void shutdownComplete() {
            this.shutdownLatch().countDown();
        }

        public ConsumerPerfThread(int n, String string, KafkaStream<byte[], byte[]> kafkaStream, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2) {
            this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId = n;
            this.stream = kafkaStream;
            this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config = consumerPerfConfig;
            this.totalMessagesRead = atomicLong;
            this.totalBytesRead = atomicLong2;
            super(string);
            this.shutdownLatch = new CountDownLatch(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfConfig
    extends PerfConfig
    implements ScalaObject {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final OptionSet options;
        private final Properties props;
        private final ConsumerConfig consumerConfig;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Properties props() {
            return this.props;
        }

        public ConsumerConfig consumerConfig() {
            return this.consumerConfig;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] stringArray) {
            super(stringArray);
            this.options = this.parser().parse(stringArray);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{this.topicOpt(), this.zkConnectOpt()})).foreach((Function1)new ConsumerPerfConfig$$anonfun$1(this));
            this.props = new Properties();
            this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
            this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
            this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
            this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
            this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
            this.props().put("consumer.timeout.ms", "5000");
            this.consumerConfig = new ConsumerConfig(this.props());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }
}

